/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.keyinfo;

import iaik.xml.crypto.EccProviderAdapter;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dom.XmldsigDOMStructure;
import iaik.xml.crypto.dsig.keyinfo.DSAKeyValueImpl;
import iaik.xml.crypto.dsig.keyinfo.ECDSAKeyValueTypeImpl;
import iaik.xml.crypto.dsig.keyinfo.EccelerateDSAKeyValueImpl;
import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.dsig.keyinfo.RSAKeyValueImpl;
import iaik.xml.crypto.enc.keyinfo.DHKeyValueImpl;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.interfaces.DHPublicKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.w3c.dom.Node;

public class KeyValueImpl
extends XmldsigDOMStructure
implements KeyValue {
    protected KeyValueType keyValue_;
    static Class h;

    public KeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.keyValue_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete or key type is not supported.");
        }
    }

    public KeyValueImpl(PublicKey publicKey) throws KeyException {
        if (publicKey == null) {
            throw new NullPointerException("Argument 'publicKey' must not be null");
        }
        if (publicKey instanceof DSAPublicKey) {
            this.keyValue_ = new DSAKeyValueImpl((DSAPublicKey)publicKey);
        } else if (publicKey instanceof RSAPublicKey) {
            this.keyValue_ = new RSAKeyValueImpl((RSAPublicKey)publicKey);
        } else {
            ClassLoader classLoader = (h == null ? (h = KeyValueImpl.b("iaik.xml.crypto.dsig.keyinfo.KeyValueImpl")) : h).getClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass("iaik.security.dh.ESDHPublicKey");
                if (clazz.isAssignableFrom(publicKey.getClass())) {
                    this.keyValue_ = new DHKeyValueImpl((DHPublicKey)publicKey);
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (EccProviderAdapter.ECC_PROVIDER_CLASS != null && EccProviderAdapter.isEcPublicKey(publicKey)) {
                this.keyValue_ = EccProviderAdapter.USE_ECCELERATE ? EccelerateDSAKeyValueImpl.newInstance(publicKey) : ECDSAKeyValueTypeImpl.newInstance(publicKey);
                return;
            }
            throw new KeyException("Key type '" + publicKey.getClass().getName() + "' is not supported.");
        }
    }

    public String getLocalName() {
        return "KeyValue";
    }

    public PublicKey getPublicKey() throws KeyException {
        return this.keyValue_.getPublicKey();
    }

    protected List getChildStructures() {
        ArrayList<KeyValueType> arrayList = new ArrayList<KeyValueType>();
        arrayList.add(this.keyValue_);
        return arrayList;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof KeyValueType) {
            this.keyValue_ = (KeyValueType)dOMStructure;
        }
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

