/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig.spec;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.dsig.spec.AlgorithmParameterImpl;
import iaik.xml.crypto.utils.DOMUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSASSAPSSParameterImpl
extends AlgorithmParameterImpl
implements SignatureMethodParameterSpec {
    protected DigestMethodImpl digestMethod_;
    protected Integer saltLength_;
    protected Integer trailerField_;
    protected DigestMethodImpl mgfDigestMethod_;
    protected String mgf_;

    public RSASSAPSSParameterImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public RSASSAPSSParameterImpl(DigestMethod digestMethod, Integer n2, Integer n3, DigestMethod digestMethod2, String string) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.digestMethod_ = digestMethod == null || digestMethod instanceof DigestMethodImpl ? (DigestMethodImpl)digestMethod : new DigestMethodImpl(digestMethod.getAlgorithm(), (DigestMethodParameterSpec)digestMethod.getParameterSpec());
        this.saltLength_ = n2;
        this.trailerField_ = n3;
        this.mgfDigestMethod_ = digestMethod2 == null || digestMethod2 instanceof DigestMethodImpl ? (DigestMethodImpl)digestMethod2 : new DigestMethodImpl(digestMethod2.getAlgorithm(), (DigestMethodParameterSpec)digestMethod2.getParameterSpec());
        this.mgf_ = string;
    }

    public String getLocalName() {
        return "RSAPSSParams";
    }

    public String getNamespace() {
        return "http://www.w3.org/2007/05/xmldsig-more#";
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod_;
    }

    public String getMGF() {
        return this.mgf_;
    }

    public DigestMethod getMGFDigestMethod() {
        return this.mgfDigestMethod_;
    }

    public Integer getSaltLength() {
        return this.saltLength_;
    }

    public Integer getTrailerField() {
        return this.trailerField_;
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element;
        Element element2 = super.marshalElement(dOMCryptoContext, node, node2);
        if (this.digestMethod_ != null) {
            this.digestMethod_.marshal(dOMCryptoContext, element2, null);
        }
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix(this.getNamespace(), dOMCryptoContext.getDefaultNamespacePrefix());
        if (this.mgf_ != null || this.mgfDigestMethod_ != null) {
            element = document.createElementNS(this.getNamespace(), RSASSAPSSParameterImpl.getQualifiedName(string, "MaskGenerationFunction"));
            element2.appendChild(element);
            if (this.mgf_ != null) {
                Attr attr = document.createAttributeNS("", "Algorithm");
                attr.setValue(this.mgf_);
                element.setAttributeNode(attr);
            }
            if (this.mgfDigestMethod_ != null) {
                this.mgfDigestMethod_.marshal(dOMCryptoContext, element, null);
            }
        }
        if (this.saltLength_ != null) {
            element = document.createElementNS(this.getNamespace(), RSASSAPSSParameterImpl.getQualifiedName(string, "SaltLength"));
            DOMUtils.addTextToElement(element, this.saltLength_.toString());
            element2.appendChild(element);
        }
        if (this.trailerField_ != null) {
            element = document.createElementNS(this.getNamespace(), RSASSAPSSParameterImpl.getQualifiedName(string, "TrailerField"));
            DOMUtils.addTextToElement(element, this.trailerField_.toString());
            element2.appendChild(element);
        }
        return element2;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof DigestMethodImpl) {
            this.digestMethod_ = (DigestMethodImpl)dOMStructure;
        }
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalStructures(nodeList, dOMCryptoContext);
        if (nodeList == null) {
            return;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (node.getNodeType() != 1 || !this.getNamespace().equals(node.getNamespaceURI())) continue;
            if ("MaskGenerationFunction".equals(node.getLocalName())) {
                Object object;
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null && (object = namedNodeMap.getNamedItemNS(null, "Algorithm")) != null) {
                    this.mgf_ = object.getNodeValue();
                }
                if ((object = ((Element)node).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod")).getLength() > 1) {
                    throw new MarshalException("Only one Digest Method allowed in MaskGenerationFunction");
                }
                if (object.getLength() <= 0) continue;
                Node node2 = object.item(0);
                this.mgfDigestMethod_ = new DigestMethodImpl(dOMCryptoContext, node2);
                continue;
            }
            if ("SaltLength".equals(node.getLocalName())) {
                this.saltLength_ = new Integer(DOMUtils.getAllTextFromChildren((Element)node));
                continue;
            }
            if (!"TrailerField".equals(node.getLocalName())) continue;
            this.trailerField_ = new Integer(DOMUtils.getAllTextFromChildren((Element)node));
        }
    }
}

