/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.asn1.structures.Name;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.X509KeySelectorResult;
import iaik.xml.crypto.utils.i;
import iaik.xml.crypto.utils.j;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.dom.DOMDecryptContext;
import javax.xml.crypto.enc.keyinfo.AgreementMethod;
import javax.xml.crypto.enc.keyinfo.EncryptedKey;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class KeySelectorImpl
extends KeySelector {
    protected String failReason_ = "";

    public final KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        KeySelectorResult keySelectorResult;
        ArrayList<KeySelectorResult> arrayList = new ArrayList<KeySelectorResult>();
        KeyInfoHints keyInfoHints = this.newKeyInfoHints(keyInfo, xMLCryptoContext);
        Object object = this.select(keyInfoHints, purpose, algorithmMethod, xMLCryptoContext);
        if (object != null) {
            arrayList.add((KeySelectorResult)object);
        }
        object = null;
        try {
            object = this.getKeyFactoryInstance(algorithmMethod, this.keySelectorPurpose2DelegationPurpose(purpose));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (object == null) {
            if (keyInfoHints.encryptedKey_ != null && (keySelectorResult = this.select(keyInfoHints.encryptedKey_, purpose, algorithmMethod, xMLCryptoContext)) != null) {
                arrayList.add(keySelectorResult);
            }
            if (keyInfoHints.agreementMethod_ != null && (keySelectorResult = this.select(keyInfoHints.agreementMethod_, purpose, algorithmMethod, xMLCryptoContext)) != null) {
                arrayList.add(keySelectorResult);
            }
        }
        if (keyInfoHints.keyValue_ != null) {
            arrayList.add(this.select(keyInfoHints.keyValue_, purpose, algorithmMethod, xMLCryptoContext));
        }
        if (!keyInfoHints.x509Data_.isEmpty()) {
            keySelectorResult = null;
            Iterator iterator = keyInfoHints.x509Data_.iterator();
            while (iterator.hasNext() && keySelectorResult == null) {
                keySelectorResult = this.select((X509Data)iterator.next(), purpose, algorithmMethod, xMLCryptoContext);
                if (keySelectorResult == null) continue;
                arrayList.add(keySelectorResult);
            }
        }
        if (keyInfoHints.rawCert_ != null && (keySelectorResult = this.select(keyInfoHints.rawCert_, purpose, algorithmMethod, xMLCryptoContext)) != null) {
            arrayList.add(keySelectorResult);
        }
        if (arrayList.isEmpty() && (keySelectorResult = this.select(purpose, algorithmMethod, xMLCryptoContext)) != null) {
            arrayList.add(keySelectorResult);
        }
        return this.select(keyInfoHints, arrayList.toArray(new KeySelectorResult[arrayList.size()]));
    }

    protected XSecProvider.Purpose keySelectorPurpose2DelegationPurpose(KeySelector.Purpose purpose) throws KeySelectorException {
        if (purpose == KeySelector.Purpose.VERIFY || purpose == KeySelector.Purpose.ENCRYPT) {
            return XSecProvider.Purpose.KeyFactoryPurpose.PUBLIC;
        }
        if (purpose == KeySelector.Purpose.SIGN || purpose == KeySelector.Purpose.DECRYPT) {
            return XSecProvider.Purpose.KeyFactoryPurpose.PRIVATE;
        }
        throw new KeySelectorException("Unknown Purpose:" + purpose);
    }

    protected KeyInfoHints newKeyInfoHints(KeyInfo keyInfo, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return new KeyInfoHints(keyInfo, xMLCryptoContext);
    }

    protected KeySelectorResult select(KeyInfoHints keyInfoHints, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return null;
    }

    protected KeySelectorResult select(EncryptedKey encryptedKey, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        Key key;
        KeySelector keySelector = xMLCryptoContext.getKeySelector();
        Element element = (Element)((DOMStructure)((Object)encryptedKey)).getNode();
        DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
        try {
            key = encryptedKey.decryptKey(dOMDecryptContext, algorithmMethod);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new KeySelectorException("Failed to decrypt EncryptedKey. " + xMLEncryptionException.getMessage(), xMLEncryptionException);
        }
        return new KeySelectorResultImpl(key);
    }

    protected KeySelectorResult select(AgreementMethod agreementMethod, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return null;
    }

    protected KeySelectorResult select(X509Data x509Data, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        if (purpose != null && purpose != KeySelector.Purpose.VERIFY && purpose != KeySelector.Purpose.ENCRYPT) {
            this.failReason_ = this.failReason_ + "This KeySelector only supports " + KeySelector.Purpose.VERIFY + " and " + KeySelector.Purpose.ENCRYPT + ". ";
        } else if (x509Data != null) {
            Serializable serializable;
            List<Object> list = new ArrayList<java.security.cert.X509Certificate>();
            ArrayList arrayList = new ArrayList();
            X509IssuerSerial[] x509IssuerSerialArray = null;
            String[] stringArray = null;
            Object[] objectArray = null;
            Certificate[] certificateArray = new ArrayList();
            Iterator<X509Certificate> iterator = new ArrayList();
            Object object = new ArrayList();
            X509Certificate x509Certificate = x509Data.getContent().iterator();
            while (x509Certificate.hasNext()) {
                Object e2 = x509Certificate.next();
                if (e2 instanceof java.security.cert.X509Certificate) {
                    serializable = (java.security.cert.X509Certificate)e2;
                    list.add(serializable);
                    continue;
                }
                if (e2 instanceof X509CRL) {
                    arrayList.add(e2);
                    continue;
                }
                if (e2 instanceof String) {
                    iterator.add((X509Certificate)e2);
                    continue;
                }
                if (e2 instanceof byte[]) {
                    object.add(e2);
                    continue;
                }
                if (!(e2 instanceof X509IssuerSerial)) continue;
                certificateArray.add(e2);
            }
            stringArray = new String[iterator.size()];
            iterator.toArray(stringArray);
            x509IssuerSerialArray = new X509IssuerSerial[certificateArray.size()];
            certificateArray.toArray(x509IssuerSerialArray);
            objectArray = new Object[object.size()];
            if (!list.isEmpty()) {
                certificateArray = new java.security.cert.X509Certificate[list.size()];
                list.toArray(certificateArray);
                list.clear();
                iterator = null;
                try {
                    object = Util.convertCertificateChain((Certificate[])certificateArray);
                    x509Certificate = Util.arrangeCertificateChain((X509Certificate[])object, (boolean)false);
                    if (x509Certificate == null) {
                        list = Arrays.asList(object);
                        iterator = list.iterator();
                    } else {
                        iterator = Collections.nCopies(1, x509Certificate[0]).iterator();
                        list = Arrays.asList(x509Certificate);
                    }
                }
                catch (CertificateException certificateException) {
                    this.failReason_ = this.failReason_ + "Error parsing certificate(s) in KeyInfo. ";
                }
                object = null;
                while (iterator.hasNext()) {
                    x509Certificate = iterator.next();
                    boolean bl = false;
                    serializable = x509Certificate.getPublicKey();
                    KeyFactory keyFactory = null;
                    try {
                        keyFactory = this.getKeyFactoryInstance(algorithmMethod, this.keySelectorPurpose2DelegationPurpose(purpose));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        this.failReason_ = this.failReason_ + "Could not find KeyFactory for \"" + algorithmMethod.getAlgorithm() + "\". ";
                        bl = false;
                        break;
                    }
                    try {
                        keyFactory.translateKey((Key)serializable);
                        bl = true;
                        if (object != null && !serializable.equals(object)) {
                            this.failReason_ = this.failReason_ + "Two different certificates in KeyInfo neither belong to the same chain, nor contain the same public key. ";
                            bl = false;
                            break;
                        }
                        object = serializable;
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        this.failReason_ = this.failReason_ + "Public key in certificate does not match signature method. ";
                        this.failReason_ = this.failReason_ + "Invalid key for signature method \"" + algorithmMethod.getAlgorithm() + "\". ";
                        bl = false;
                        break;
                    }
                    if (stringArray != null && stringArray.length > 0) {
                        try {
                            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                                String string = stringArray[i2];
                                if (bl &= KeySelectorImpl.matchSubjectDN((java.security.cert.X509Certificate)x509Certificate, string)) continue;
                                this.failReason_ = this.failReason_ + "KeyInfo X509SubjectName (" + string + ") does not match SubjectDN (" + KeySelectorImpl.getSubjectDN((java.security.cert.X509Certificate)x509Certificate) + ") of KeyInfo X509Certificate. Any X509IssuerSerial, X509SKI, " + "and X509SubjectName elements that appear MUST refer to the " + "certificate or certificates containing the validation key.";
                            }
                        }
                        catch (RFC2253NameParserException rFC2253NameParserException) {
                            this.failReason_ = this.failReason_ + "Error parsing SubjectDN of certificate in KeyInfo. ";
                        }
                    }
                    if (x509IssuerSerialArray != null && x509IssuerSerialArray.length > 0) {
                        try {
                            boolean bl2 = true;
                            for (int i3 = 0; i3 < x509IssuerSerialArray.length; ++i3) {
                                X509IssuerSerial x509IssuerSerial = x509IssuerSerialArray[i3];
                                if (!(bl2 &= this.matchIssuerDN(x509Certificate, x509IssuerSerial))) {
                                    this.failReason_ = this.failReason_ + "KeyInfo X509IssuerName does not match IssuerDN of KeyInfo X509Certificate. ";
                                }
                                bl &= bl2;
                                boolean bl3 = true;
                                if (bl3 &= this.matchIssuerSN((java.security.cert.X509Certificate)x509Certificate, x509IssuerSerial)) continue;
                                this.failReason_ = this.failReason_ + "KeyInfo X509SerialNumber does not match serial number of KeyInfo X509Certificate. ";
                                bl = false;
                                break;
                            }
                        }
                        catch (RFC2253NameParserException rFC2253NameParserException) {
                            this.failReason_ = this.failReason_ + "Error parsing IssuerDN of certificate in KeyInfo. ";
                        }
                    }
                    if (!bl) continue;
                    this.failReason_ = null;
                    return new X509KeySelectorResultImpl((Key)serializable, list, arrayList);
                }
            } else {
                this.failReason_ = this.failReason_ + "No certificate included in X509Data. ";
            }
        } else {
            this.failReason_ = this.failReason_ + "No X509Data included in KeyInfo. ";
        }
        return null;
    }

    protected boolean matchIssuerSN(java.security.cert.X509Certificate x509Certificate, X509IssuerSerial x509IssuerSerial) {
        return x509IssuerSerial.getSerialNumber().equals(x509Certificate.getSerialNumber());
    }

    protected static String getSubjectDN(java.security.cert.X509Certificate x509Certificate) throws RFC2253NameParserException {
        return ((Name)x509Certificate.getSubjectDN()).getRFC2253String();
    }

    protected static boolean matchSubjectDN(java.security.cert.X509Certificate x509Certificate, String string) throws RFC2253NameParserException {
        return string.equals(KeySelectorImpl.getSubjectDN(x509Certificate));
    }

    protected boolean matchIssuerDN(X509Certificate x509Certificate, X509IssuerSerial x509IssuerSerial) throws RFC2253NameParserException {
        String string = x509IssuerSerial.getIssuerName();
        String string2 = ((Name)x509Certificate.getIssuerDN()).getRFC2253String();
        return string.equals(string2);
    }

    protected KeySelectorResult select(KeyValue keyValue, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        if (keyValue != null && (purpose == KeySelector.Purpose.VERIFY || purpose == KeySelector.Purpose.ENCRYPT)) {
            PublicKey publicKey;
            try {
                publicKey = keyValue.getPublicKey();
            }
            catch (KeyException keyException) {
                throw new KeySelectorException("Failed to get public key from KeyValue. " + keyException.getMessage(), keyException);
            }
            try {
                KeyFactory keyFactory = this.getKeyFactoryInstance(algorithmMethod, this.keySelectorPurpose2DelegationPurpose(purpose));
                Key key = keyFactory.translateKey(publicKey);
                return new KeySelectorResultImpl(key);
            }
            catch (InvalidKeyException invalidKeyException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    protected KeySelectorResult select(java.security.cert.X509Certificate x509Certificate, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        if (purpose != KeySelector.Purpose.VERIFY && purpose != KeySelector.Purpose.ENCRYPT) {
            return null;
        }
        if (x509Certificate != null) {
            PublicKey publicKey;
            try {
                KeyFactory keyFactory = this.getKeyFactoryInstance(algorithmMethod, this.keySelectorPurpose2DelegationPurpose(purpose));
                publicKey = (PublicKey)keyFactory.translateKey(x509Certificate.getPublicKey());
            }
            catch (InvalidKeyException invalidKeyException) {
                return null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
            return new X509KeySelectorResultImpl(publicKey, Collections.nCopies(1, x509Certificate), null);
        }
        return null;
    }

    protected KeySelectorResult select(KeyInfoHints keyInfoHints, KeySelectorResult[] keySelectorResultArray) {
        if (keySelectorResultArray.length == 0) {
            return null;
        }
        return keySelectorResultArray[0];
    }

    protected KeySelectorResult select(KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        return null;
    }

    public String getFailReason() {
        return this.failReason_;
    }

    protected KeyFactory getKeyFactoryInstance(AlgorithmMethod algorithmMethod, XSecProvider.Purpose purpose) throws NoSuchAlgorithmException {
        String string;
        KeyFactory keyFactory = null;
        if (algorithmMethod != null && (string = algorithmMethod.getAlgorithm()) != null) {
            Provider provider = XSecProvider.getDelegationProvider("KeyFactory." + string, purpose);
            if (provider != null) {
                try {
                    keyFactory = KeyFactory.getInstance(string, provider);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    try {
                        keyFactory = KeyFactory.getInstance(string, provider.getName());
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        throw new i(this, "Delegation for \"" + string + "\" for Provider \"" + provider.getName() + "\" in jdk 1.3 or earlier invalid. Provider has to be registered " + noSuchProviderException.getMessage(), noSuchProviderException);
                    }
                }
            } else if (keyFactory == null) {
                keyFactory = KeyFactory.getInstance(string);
            }
        }
        return keyFactory;
    }

    public static class KeyInfoHints
    implements KeyInfo {
        protected EncryptedKey encryptedKey_ = null;
        protected AgreementMethod agreementMethod_ = null;
        protected KeyValue keyValue_ = null;
        protected KeyName keyName_ = null;
        protected List x509Data_ = new ArrayList();
        protected java.security.cert.X509Certificate rawCert_ = null;
        private KeyInfo a;
        private List b = new ArrayList();

        public KeyInfoHints(KeyInfo keyInfo, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                return;
            }
            this.a = keyInfo;
            this.init(xMLCryptoContext);
        }

        protected void init(XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            Iterator iterator = this.getContent().iterator();
            while (iterator.hasNext()) {
                this.collectKeyInfo((XMLStructure)iterator.next(), xMLCryptoContext);
            }
        }

        protected KeyName getKeyName() {
            return this.keyName_;
        }

        protected void collectKeyInfo(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (xMLStructure instanceof EncryptedKey) {
                this.encryptedKey_ = (EncryptedKey)xMLStructure;
            } else if (xMLStructure instanceof AgreementMethod) {
                this.agreementMethod_ = (AgreementMethod)xMLStructure;
            } else if (xMLStructure instanceof KeyValue) {
                this.keyValue_ = (KeyValue)xMLStructure;
            } else if (xMLStructure instanceof KeyName) {
                this.keyName_ = (KeyName)xMLStructure;
            } else if (xMLStructure instanceof X509Data) {
                this.x509Data_.add(xMLStructure);
            } else if (xMLStructure instanceof RetrievalMethod) {
                this.dereferenceRetrievalMethod((RetrievalMethod)xMLStructure, xMLCryptoContext);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void dereferenceRetrievalMethod(RetrievalMethod retrievalMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            Document document;
            Object object;
            Object object2;
            Data data;
            this.checkDereferencedURIsForDosPrevention(retrievalMethod.getURI(), xMLCryptoContext);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(retrievalMethod.getType())) {
                Data data2;
                try {
                    data2 = retrievalMethod.dereference(xMLCryptoContext);
                }
                catch (URIReferenceException uRIReferenceException) {
                    throw new KeySelectorException("Failed to get certificate from RetrievalMethod, " + uRIReferenceException.getMessage(), uRIReferenceException);
                }
                if (!(data2 instanceof OctetStreamData)) {
                    throw new KeySelectorException("The RetrievalMethod is of Type='http://www.w3.org/2000/09/xmldsig#rawX509Certificate'. Therefore, the dereferenced data must be a valid certificate.");
                }
                InputStream inputStream = ((OctetStreamData)data2).getOctetStream();
                String string = "X.509";
                try {
                    CertificateFactory certificateFactory = null;
                    Provider provider = XSecProvider.getDelegationProvider("CertificateFactory." + string, null);
                    if (provider != null) {
                        try {
                            certificateFactory = CertificateFactory.getInstance(string, provider);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            try {
                                certificateFactory = CertificateFactory.getInstance(string, provider.getName());
                            }
                            catch (NoSuchProviderException noSuchProviderException) {
                                throw new j(this, "Delegation provider not registered, any more.", noSuchProviderException);
                            }
                        }
                    }
                    if (certificateFactory == null) {
                        certificateFactory = CertificateFactory.getInstance(string);
                    }
                    this.rawCert_ = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(inputStream);
                    return;
                }
                catch (CertificateException certificateException) {
                    throw new KeySelectorException("The RetrievalMethod is of Type='http://www.w3.org/2000/09/xmldsig#rawX509Certificate'. Therefore, the dereferenced data must be a valid certificate. " + certificateException.getMessage(), certificateException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new KeySelectorException("No provider found for '" + string + "'. " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
                }
            }
            try {
                data = retrievalMethod.dereference(xMLCryptoContext);
            }
            catch (URIReferenceException uRIReferenceException) {
                throw new KeySelectorException("Failed to dereference RetrievalMethod." + uRIReferenceException.getMessage(), uRIReferenceException);
            }
            if (data instanceof NodeSetData) {
                Node node;
                object2 = null;
                object = ((NodeSetData)data).iterator();
                while (object.hasNext() && object2 == null) {
                    node = (Node)object.next();
                    if (node.getNodeType() != 1) continue;
                    object2 = (Element)node;
                }
                if (object2 == null) throw new KeySelectorException("Dereferencing RetrievalMethod did not return an XML element.");
                try {
                    document = DOMUtils.newDocument(new Boolean(true), null, null);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new KeySelectorException("Failed to dereference RetrievalMethod." + parserConfigurationException.getMessage(), parserConfigurationException);
                }
                node = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                document.appendChild(node);
                node.appendChild(document.importNode((Node)object2, true));
            } else {
                try {
                    object2 = (OctetStreamData)data;
                    document = DOMUtils.parse(((OctetStreamData)object2).getOctetStream(), ((OctetStreamData)object2).getURI(), null, xMLCryptoContext);
                }
                catch (SAXException sAXException) {
                    throw new KeySelectorException("Failed to parse Document dereferenced from RetrievalMethod." + sAXException.getMessage(), sAXException);
                }
                catch (IOException iOException) {
                    throw new KeySelectorException("Failed to parse Document dereferenced from RetrievalMethod." + iOException.getMessage(), iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new KeySelectorException("Failed to dereference RetrievalMethod." + parserConfigurationException.getMessage(), parserConfigurationException);
                }
                object2 = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                object = document.getDocumentElement();
                document.replaceChild((Node)object, (Node)object2);
                object2.appendChild((Node)object);
            }
            try {
                object2 = (KeyInfo)((Object)iaik.xml.crypto.dom.DOMStructure.getInstance(document.getDocumentElement(), (DOMCryptoContext)xMLCryptoContext));
            }
            catch (MarshalException marshalException) {
                throw new KeySelectorException("Failed to unmarshal KeyInfo type from dereferenced RetrievalMethod." + marshalException.getMessage(), marshalException);
            }
            catch (ClassCastException classCastException) {
                throw new KeySelectorException("Failed to unmarshal KeyInfo type from dereferenced RetrievalMethod." + classCastException.getMessage(), classCastException);
            }
            object = object2.getContent();
            if (object.isEmpty()) throw new KeySelectorException("Dereferencing RetrievalMethod did not return an KeyInfo element.");
            this.collectKeyInfo((XMLStructure)object.get(0), xMLCryptoContext);
        }

        protected void checkDereferencedURIsForDosPrevention(String string, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (this.b.contains(string)) {
                Iterator iterator = this.b.iterator();
                String string2 = "";
                while (iterator.hasNext()) {
                    string2 = string2 + iterator.next() + ", ";
                }
                string2 = string2 + string;
                throw new KeySelectorException("The URIs \"" + string2 + "\" are suspected to introduce " + "cyclic dereferencing of Retrieval methods");
            }
            this.b.add(string);
        }

        public List getContent() {
            return this.a.getContent();
        }

        public String getId() {
            return this.a.getId();
        }

        public boolean isFeatureSupported(String string) {
            return this.a.isFeatureSupported(string);
        }

        public void marshal(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
            this.a.marshal(xMLStructure, xMLCryptoContext);
        }
    }

    public static class X509KeySelectorResultImpl
    implements X509KeySelectorResult {
        protected Key key_;
        protected List certificates_;
        protected List crls_;

        public X509KeySelectorResultImpl(Key key, List list, List list2) {
            this.key_ = key;
            this.certificates_ = list;
            this.crls_ = list2;
        }

        public List getCertificates() {
            return this.certificates_ == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.certificates_);
        }

        public List getCRLs() {
            return this.crls_ == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.crls_);
        }

        public Key getKey() {
            return this.key_;
        }
    }

    public static class KeySelectorResultImpl
    implements KeySelectorResult {
        protected Key key_;

        public KeySelectorResultImpl() {
        }

        public KeySelectorResultImpl(Key key) {
            this.key_ = key;
        }

        public Key getKey() {
            return this.key_;
        }

        public void setKey(Key key) {
            this.key_ = key;
        }
    }
}

