/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.dom.DOMNodeSetData;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.Nodes;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import iaik.xml.filter.impl.dsig.SequenceTraverser;
import iaik.xml.filter.impl.dsig.Traverser;
import iaik.xml.filter.impl.dsig.XPathEvaluator;
import iaik.xml.filter.impl.dsig.XPathException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class URIDereferencerImpl
implements URIDereferencer {
    static Class a;

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        URI uRI;
        if (uRIReference == null) {
            throw new NullPointerException("Argument 'uriReference' can not be null.");
        }
        if (xMLCryptoContext == null) {
            throw new NullPointerException("Argument 'context' can not be null.");
        }
        if (!(uRIReference instanceof DOMURIReference) || !(xMLCryptoContext instanceof DOMCryptoContext)) {
            throw new IllegalArgumentException("This " + (a == null ? (a = URIDereferencerImpl.a("javax.xml.crypto.URIDereferencer")) : a).getName() + " implementation supports the DOM XML mechanism only.");
        }
        String string = uRIReference.getURI();
        if (string == null) {
            throw new URIReferenceException("Cannot resolve a URI of value 'null'.");
        }
        try {
            uRI = new URI(string);
        }
        catch (URIException uRIException) {
            throw new URIReferenceException("URI '" + uRIReference.getURI() + "' is not RFC 2396 compliant.", uRIException);
        }
        if (uRI.isEmpty() || uRI.isReference()) {
            Node node = ((DOMURIReference)uRIReference).getHere();
            return this.dereferenceInternalURI(uRI, node, xMLCryptoContext);
        }
        return this.dereferenceExternalURI(uRI, xMLCryptoContext);
    }

    protected Data dereferenceInternalURI(URI uRI, Node node, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        Object object;
        Document document = node != null ? DOMUtils.getOwnerDocument(node) : DOMUtils.getDocFromDOMCryptoContext((DOMCryptoContext)xMLCryptoContext);
        if (document == null) {
            throw new URIReferenceException("URI '" + uRI + "' is reference only, but neither the uriReference nor the context " + "contain a node to get the corresponding document from.");
        }
        if (uRI.isEmpty()) {
            Traverser traverser = new Traverser(document, false, true);
            return new DOMNodeSetData(traverser);
        }
        String string = uRI.getReferenceUnescaped();
        if (!URIDereferencerImpl.d(string)) {
            DOMCryptoContext dOMCryptoContext = (DOMCryptoContext)xMLCryptoContext;
            Element element = dOMCryptoContext.getElementById(string);
            if (element == null && (element = document.getElementById(string)) == null) {
                throw new URIReferenceException("Sub-resource error resolving shorthand xpointer, id '" + string + "' is not registered.");
            }
            Traverser traverser = new Traverser(element, false, true);
            return new DOMNodeSetData(traverser);
        }
        Hashtable hashtable = URIDereferencerImpl.c(string);
        Vector vector = URIDereferencerImpl.b(string);
        Enumeration enumeration = vector.elements();
        Iterator iterator = Nodes.EMPTY_ITERATOR;
        while (!iterator.hasNext() && enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if ("/".equals(object)) {
                return new DOMNodeSetData(new Traverser(document, true, true));
            }
            try {
                XPathEvaluator xPathEvaluator = XPathEvaluator.newXPathEvaluator((String)object, node, hashtable, (DOMCryptoContext)xMLCryptoContext);
                iterator = xPathEvaluator.evaluate(document);
            }
            catch (XPathException xPathException) {
                throw new URIReferenceException("Cannot evaluate URI reference XPointer '" + (String)object + "'." + xPathException.getMessage(), xPathException);
            }
        }
        object = new SequenceTraverser(iterator, true, true);
        return new DOMNodeSetData((Iterator)object);
    }

    protected Data dereferenceExternalURI(URI uRI, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        Object object;
        if (!uRI.isAbsolute()) {
            if (xMLCryptoContext.getBaseURI() == null) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "', base URI given in context is null.");
            }
            try {
                object = new URI(xMLCryptoContext.getBaseURI());
            }
            catch (URIException uRIException) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "', base URI '" + xMLCryptoContext.getBaseURI() + "' given in context is not RFC 2396 compliant.", uRIException);
            }
            if (!((URI)object).isAbsolute()) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "', base URI '" + xMLCryptoContext.getBaseURI() + "' given in context is not absolute according to RFC 2396.");
            }
            try {
                uRI = URI.absolutizeURI((URI)object, uRI);
            }
            catch (URIException uRIException) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "' with base URI '" + xMLCryptoContext.getBaseURI() + "' given in context.", uRIException);
            }
        }
        object = null;
        try {
            object = new URL(uRI.toString());
            URLConnection uRLConnection = ((URL)object).openConnection();
            return new OctetStreamData(uRLConnection.getInputStream(), uRI.toString(), uRLConnection.getContentType());
        }
        catch (MalformedURLException malformedURLException) {
            throw new URIReferenceException("URI '" + uRI.toString() + "' cannot be resolved. URL: " + object, malformedURLException);
        }
        catch (IOException iOException) {
            try {
                if (XSecProvider.getSysProperty("java.version").startsWith("1.2.2")) {
                    object = new URL(uRI.toUnescapedString());
                    URLConnection uRLConnection = ((URL)object).openConnection();
                    return new OctetStreamData(uRLConnection.getInputStream(), uRI.toString(), uRLConnection.getContentType());
                }
                object = new URL(((URL)object).toExternalForm());
                URLConnection uRLConnection = ((URL)object).openConnection();
                return new OctetStreamData(uRLConnection.getInputStream(), uRI.toString(), uRLConnection.getContentType());
            }
            catch (MalformedURLException malformedURLException) {
                throw new URIReferenceException("URI '" + uRI.toString() + "' cannot be resolved. URL: " + object, malformedURLException);
            }
            catch (IOException iOException2) {
                throw new URIReferenceException("URI '" + uRI.toString() + "' cannot be resolved. URL: " + object, iOException2);
            }
        }
    }

    private static int a(String string, int n2) throws URIReferenceException {
        int n3;
        int n4 = 1;
        char[] cArray = string.substring(n2).toCharArray();
        block4: for (n3 = 0; n3 < cArray.length && n4 > 0; ++n3) {
            switch (cArray[n3]) {
                case '(': {
                    int n5 = 0;
                    while (string.charAt(n2 + n3 - n5 - 1) == '^') {
                        ++n5;
                    }
                    if (n5 % 2 != 0) continue block4;
                    ++n4;
                    continue block4;
                }
                case ')': {
                    int n5 = 0;
                    while (string.charAt(n2 + n3 - n5 - 1) == '^') {
                        ++n5;
                    }
                    if (n5 % 2 != 0) continue block4;
                    --n4;
                    continue block4;
                }
            }
        }
        if (n4 == 0) {
            return n3 + n2 - 1;
        }
        throw new URIReferenceException("Cannot find closing brace in URI reference XPointer '" + string + "'.");
    }

    private static Vector b(String string) throws URIReferenceException {
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while ((n2 = string.indexOf("xpointer(", n2)) >= 0) {
            int n3 = n2 + "xpointer(".length();
            n2 = URIDereferencerImpl.a(string, n3) + 1;
            String string2 = string.substring(n3, n2 - 1);
            vector.add(string2);
        }
        return vector;
    }

    private static Hashtable c(String string) throws URIReferenceException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        int n2 = 0;
        while ((n2 = string.indexOf("xmlns(", n2)) >= 0) {
            int n3 = n2 + "xmlns(".length();
            String string2 = string.substring(n3, (n2 = URIDereferencerImpl.a(string, n3) + 1) - 1);
            int n4 = string2.indexOf(61);
            if (-1 == n4) {
                throw new URIReferenceException("Cannot find equals sign '=' in xmlns XPointer part '" + string2 + "'.");
            }
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4 + 1, string2.length());
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    public static boolean isSameDocumentFullXPointer(String string) throws URIReferenceException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URIException uRIException) {
            throw new URIReferenceException("URI '" + string + "' is not RFC 2396 compliant.", uRIException);
        }
        return URIDereferencerImpl.d(uRI.getReferenceUnescaped());
    }

    private static boolean d(String string) {
        return string.startsWith("xpointer(") || string.startsWith("xmlns(");
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

