/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.keyinfo;

import java.math.BigInteger;
import java.security.KeyException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

public abstract class KeyInfoFactory {
    private Provider a;
    private String b;

    protected KeyInfoFactory() {
    }

    private static KeyInfoFactory a(String string, Provider object) throws XMLSignatureException {
        Object object2;
        Object object3;
        Provider[] providerArray;
        String string2 = null;
        if (object != null) {
            Provider[] providerArray2 = new Provider[1];
            providerArray = providerArray2;
            providerArray2[0] = object;
        } else {
            providerArray = Security.getProviders();
        }
        Provider[] providerArray3 = providerArray;
        for (int i2 = 0; i2 < providerArray3.length; ++i2) {
            object3 = providerArray3[i2];
            object2 = ((Provider)object3).getProperty("Alg.Alias.KeyInfoFactory." + string);
            String string3 = "KeyInfoFactory." + (String)(object2 != null ? object2 : string);
            String string4 = ((Provider)object3).getProperty(string3);
            if (string4 == null) continue;
            string2 = string4;
            object = object3;
            break;
        }
        if (string2 == null) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.");
        }
        try {
            object3 = object.getClass().getClassLoader();
            Class<?> clazz = object3 != null ? ((ClassLoader)object3).loadClass(string2) : Class.forName(string2);
            object2 = (KeyInfoFactory)clazz.newInstance();
            ((KeyInfoFactory)object2).b = string;
            ((KeyInfoFactory)object2).a = object;
            return object2;
        }
        catch (ClassCastException classCastException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + "KeyInfoFactory" + " " + "(provider: " + ((Provider)object).getName() + ")" + " is not a " + "KeyInfoFactory" + ".", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + "KeyInfoFactory" + " " + "(provider: " + ((Provider)object).getName() + ")" + " cannot be found.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + "KeyInfoFactory" + " " + "(provider: " + ((Provider)object).getName() + ")" + " cannot be instantiated.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + "KeyInfoFactory" + " " + "(provider: " + ((Provider)object).getName() + ")" + " cannot be accessed.", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + "KeyInfoFactory" + " " + "(provider: " + ((Provider)object).getName() + ")" + " cannot be accessed.", securityException);
        }
    }

    public static KeyInfoFactory getInstance(String string) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        try {
            return KeyInfoFactory.a(string, null);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static KeyInfoFactory getInstance(String string, Provider provider) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        try {
            return KeyInfoFactory.a(string, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static KeyInfoFactory getInstance(String string, String string2) throws NoSuchProviderException {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string2);
        }
        try {
            return KeyInfoFactory.a(string, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static KeyInfoFactory getInstance() {
        return KeyInfoFactory.getInstance("DOM");
    }

    public final String getMechanismType() {
        return this.b;
    }

    public final Provider getProvider() {
        return this.a;
    }

    public abstract KeyInfo newKeyInfo(List var1);

    public abstract KeyInfo newKeyInfo(List var1, String var2);

    public abstract KeyName newKeyName(String var1);

    public abstract KeyValue newKeyValue(PublicKey var1) throws KeyException;

    public abstract PGPData newPGPData(byte[] var1);

    public abstract PGPData newPGPData(byte[] var1, byte[] var2, List var3);

    public abstract PGPData newPGPData(byte[] var1, List var2);

    public abstract RetrievalMethod newRetrievalMethod(String var1);

    public abstract RetrievalMethod newRetrievalMethod(String var1, String var2, List var3);

    public abstract X509Data newX509Data(List var1);

    public abstract X509IssuerSerial newX509IssuerSerial(String var1, BigInteger var2);

    public abstract boolean isFeatureSupported(String var1);

    public abstract URIDereferencer getURIDereferencer();

    public abstract KeyInfo unmarshalKeyInfo(XMLStructure var1) throws MarshalException;
}

