/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerInputStream;
import iaik.asn1.NULL;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.utils.CryptoUtils;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;

public class AlgorithmID
implements ASN1Type,
Cloneable {
    private static boolean o = true;
    protected static final Hashtable implementations = new Hashtable(100);
    protected static final Hashtable algorithms = new Hashtable(100);
    protected static final Hashtable algorithmParameterSpecs = new Hashtable();
    private static Hashtable p = new Hashtable();
    public static final AlgorithmID rsa = new AlgorithmID("2.5.8.1.1", "RSA", "RSA", null, o);
    public static final AlgorithmID elGamal = new AlgorithmID("1.3.14.7.2.1.1", "ElGamal", "ElGamal", a == null ? (a = AlgorithmID.class$("iaik.security.elgamal.ElGamalParameterSpec")) : a);
    public static final AlgorithmID rc2_CBC = new AlgorithmID("1.2.840.113549.3.2", "RC2-CBC", "RC2/CBC/PKCS5Padding", b == null ? (b = AlgorithmID.class$("javax.crypto.spec.RC2ParameterSpec")) : b, o);
    public static final AlgorithmID arcfour;
    public static final AlgorithmID rc4;
    public static final AlgorithmID des_EDE3_CBC;
    public static final AlgorithmID des_CBC;
    public static final AlgorithmID idea_CBC;
    public static final AlgorithmID aes128_CBC;
    public static final AlgorithmID aes192_CBC;
    public static final AlgorithmID aes256_CBC;
    public static final AlgorithmID camellia128_CBC;
    public static final AlgorithmID camellia192_CBC;
    public static final AlgorithmID camellia256_CBC;
    public static final AlgorithmID cast5_CBC;
    public static final AlgorithmID rc5_CBC;
    public static final AlgorithmID aes128_CCM;
    public static final AlgorithmID aes192_CCM;
    public static final AlgorithmID aes256_CCM;
    public static final AlgorithmID aes128_GCM;
    public static final AlgorithmID aes192_GCM;
    public static final AlgorithmID aes256_GCM;
    public static final AlgorithmID dhKeyAgreement;
    public static final AlgorithmID esdhKeyAgreement;
    public static final AlgorithmID esdh;
    public static final AlgorithmID ssdhKeyAgreement;
    public static final AlgorithmID rsaEncryption;
    public static final AlgorithmID md2WithRSAEncryption;
    public static final AlgorithmID md4WithRSAEncryption;
    public static final AlgorithmID md5WithRSAEncryption;
    public static final AlgorithmID sha1WithRSAEncryption_;
    public static final AlgorithmID sha1WithRSAEncryption;
    public static final AlgorithmID sha224WithRSAEncryption;
    public static final AlgorithmID sha256WithRSAEncryption;
    public static final AlgorithmID sha384WithRSAEncryption;
    public static final AlgorithmID sha512WithRSAEncryption;
    public static final AlgorithmID dsa_;
    public static final AlgorithmID dsa;
    public static final AlgorithmID dsa_With_SHA1;
    public static final AlgorithmID dsaWithSHA;
    public static final AlgorithmID dsaWithSHA1;
    public static final AlgorithmID dsaWithSHA1_;
    public static final AlgorithmID dsaWithSHA224;
    public static final AlgorithmID dsaWithSHA256;
    public static final AlgorithmID ecdsa;
    public static final AlgorithmID ecPublicKey;
    public static final AlgorithmID ecDH;
    public static AlgorithmID dhSinglePass_stdDH_sha1kdf_scheme;
    public static AlgorithmID dhSinglePass_cofactorDH_sha1kdf_scheme;
    public static AlgorithmID dhSinglePass_stdDH_sha256kdf_scheme;
    public static AlgorithmID dhSinglePass_stdDH_sha384kdf_scheme;
    public static final AlgorithmID gost3410;
    public static final AlgorithmID ecdsa_With_SHA1;
    public static final AlgorithmID ecdsa_With_SHA224;
    public static final AlgorithmID ecdsa_With_SHA256;
    public static final AlgorithmID ecdsa_With_SHA384;
    public static final AlgorithmID ecdsa_With_SHA512;
    public static final AlgorithmID ecdsa_plain_With_SHA1;
    public static final AlgorithmID ecdsa_plain_With_SHA224;
    public static final AlgorithmID ecdsa_plain_With_SHA256;
    public static final AlgorithmID ecdsa_plain_With_SHA384;
    public static final AlgorithmID ecdsa_plain_With_SHA512;
    public static final AlgorithmID ecdsa_plain_With_RIPEMD160;
    public static final AlgorithmID rsaSignatureWithRipemd160;
    public static final AlgorithmID rsaSignatureWithRipemd128;
    public static final AlgorithmID rsaSignatureWithRipemd256;
    public static final AlgorithmID sigS_ISO9796_2Withrsa;
    public static final AlgorithmID sigS_ISO9796_2Withsha1;
    public static final AlgorithmID sigS_ISO9796_2Withripemd160;
    public static final AlgorithmID sigS_ISO9796_2rndWithrsa;
    public static final AlgorithmID sigS_ISO9796_2rndWithsha1;
    public static final AlgorithmID sigS_ISO9796_2rndWithripemd160;
    public static final AlgorithmID mgf1;
    public static final AlgorithmID pbeWithMD5AndDES_CBC;
    public static final AlgorithmID pbeWithSHAAnd128BitRC4;
    public static final AlgorithmID pbeWithSHAAnd40BitRC4;
    public static final AlgorithmID pbeWithSHAAnd3_KeyTripleDES_CBC;
    public static final AlgorithmID pbeWithSHAAnd2_KeyTripleDES_CBC;
    public static final AlgorithmID pbeWithSHAAnd128BitRC2_CBC;
    public static final AlgorithmID pbeWithSHAAnd40BitRC2_CBC;
    public static final AlgorithmID pbkdf2;
    public static final AlgorithmID pbes2;
    public static final AlgorithmID pSpecified;
    public static final AlgorithmID md2;
    public static final AlgorithmID md4;
    public static final AlgorithmID md5;
    public static final AlgorithmID sha;
    public static final AlgorithmID sha1;
    public static final AlgorithmID gost3411;
    public static final AlgorithmID sha256;
    public static final AlgorithmID sha224;
    public static final AlgorithmID sha384;
    public static final AlgorithmID sha512;
    public static final AlgorithmID sha512_224;
    public static final AlgorithmID sha512_256;
    public static final AlgorithmID sha3_224;
    public static final AlgorithmID sha3_256;
    public static final AlgorithmID sha3_384;
    public static final AlgorithmID sha3_512;
    public static final AlgorithmID shake128;
    public static final AlgorithmID shake256;
    public static final AlgorithmID ripeMd160_ISO;
    public static final AlgorithmID ripeMd128_ISO;
    public static final AlgorithmID ripeMd160;
    public static final AlgorithmID ripeMd128;
    public static final AlgorithmID ripeMd256;
    public static final AlgorithmID whirlpool;
    public static final AlgorithmID hMAC_GOST;
    public static final AlgorithmID hMAC_MD5;
    public static final AlgorithmID hMAC_SHA1_;
    public static final AlgorithmID hMAC_SHA1;
    public static final AlgorithmID hMAC_SHA224;
    public static final AlgorithmID hMAC_SHA256;
    public static final AlgorithmID hMAC_SHA384;
    public static final AlgorithmID hMAC_SHA512;
    public static final AlgorithmID hMAC_RIPEMD160;
    public static final AlgorithmID cms_3DES_wrap;
    public static final AlgorithmID cms_rc2_wrap;
    public static final AlgorithmID cms_idea_wrap;
    public static final AlgorithmID cms_cast5_wrap;
    public static final AlgorithmID cms_aes128_wrap;
    public static final AlgorithmID cms_aes192_wrap;
    public static final AlgorithmID cms_aes256_wrap;
    public static final AlgorithmID cms_camellia128_wrap;
    public static final AlgorithmID cms_camellia192_wrap;
    public static final AlgorithmID cms_camellia256_wrap;
    public static final AlgorithmID cms_HMACwith3DES_wrap;
    public static final AlgorithmID cms_HMACwithAES_wrap;
    public static final AlgorithmID pwri_kek;
    public static final AlgorithmID zlib_compress;
    public static final AlgorithmID rsaesOAEP;
    public static final AlgorithmID rsassaPss;
    private ObjectID q = null;
    private ASN1 r = null;
    private boolean s = o;
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;
    static Class h;
    static Class i;
    static Class j;
    static Class k;
    static Class l;
    static Class m;
    static Class n;

    public static void setDefaultEncodeAbsentParametersAsNull(boolean bl) {
        o = bl;
    }

    public static boolean getDoNotIncludeParameters(AlgorithmID algorithmID) {
        return p.get(algorithmID) != null;
    }

    public static void setDoNotIncludeParameters(AlgorithmID algorithmID) {
        p.put(algorithmID, algorithmID);
    }

    public static void setDoIncludeParameters(AlgorithmID algorithmID) {
        p.remove(algorithmID);
    }

    public static boolean changeObjectID(AlgorithmID algorithmID, ObjectID objectID) {
        try {
            String string = (String)implementations.get(algorithmID.q);
            algorithmID.q = objectID;
            implementations.put(objectID, string);
            algorithms.put(string, algorithmID);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean changeOIDString(AlgorithmID algorithmID, String string) {
        try {
            String string2 = algorithmID.q.getID();
            String string3 = algorithmID.q.getName();
            String string4 = algorithmID.q.getShortName();
            String string5 = (String)implementations.get(algorithmID.q);
            ObjectID objectID = null;
            objectID = string3.equals(string2) ? (string4.equals(string2) ? new ObjectID(string) : new ObjectID(string, "", string4)) : (string4.equals(string2) ? new ObjectID(string, string3) : new ObjectID(string, string3, string4));
            algorithmID.q = objectID;
            implementations.put(objectID, string5);
            algorithms.put(string5, algorithmID);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void register(String string, String string2, String string3) {
        new AlgorithmID(string, string2, string3);
    }

    public static AlgorithmID getAlgorithmID(String string) {
        AlgorithmID algorithmID = (AlgorithmID)algorithms.get(string);
        return algorithmID == null ? null : (AlgorithmID)algorithmID.clone();
    }

    public static String[] getImplementationNames(AlgorithmID algorithmID) {
        Vector<String> vector = new Vector<String>();
        String string = null;
        try {
            string = algorithmID.getImplementationName();
            vector.add(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        Enumeration enumeration = algorithms.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!algorithmID.equals(algorithms.get(string)) || vector.contains(string)) continue;
            vector.add(string);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AlgorithmID() {
    }

    public AlgorithmID(String string, String string2) {
        this();
        this.q = new ObjectID(string, string2);
    }

    public AlgorithmID(String string, String string2, String string3) {
        this();
        this.q = new ObjectID(string, string2);
        if (string3 != null) {
            implementations.put(this.q, string3);
            algorithms.put(string3, this);
        }
    }

    public AlgorithmID(String string, String string2, String string3, Class clazz) {
        this(string, string2, string3, clazz, o);
    }

    public AlgorithmID(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3);
        this.s = bl;
    }

    public AlgorithmID(String string, String string2, String string3, Class clazz, boolean bl) {
        this(string, string2, string3, clazz, bl, true);
    }

    private AlgorithmID(String string, String string2, String string3, Class clazz, boolean bl, boolean bl2) {
        this();
        if (clazz != null && !(n == null ? (n = AlgorithmID.class$("java.security.spec.AlgorithmParameterSpec")) : n).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("algorithmParameterSpec (" + clazz.getName() + ") does not implement AlgorithmParameterSpec!");
        }
        this.q = new ObjectID(string, string2, null, false);
        if (string3 != null) {
            implementations.put(this.q, string3);
            if (bl2) {
                algorithms.put(string3, this);
            }
        }
        if (clazz != null) {
            algorithmParameterSpecs.put(this, clazz);
        }
        this.s = bl;
    }

    public AlgorithmID(String string, String string2, String[] stringArray, boolean bl) {
        this(string, string2, stringArray, null, bl);
    }

    public AlgorithmID(String string, String string2, String[] stringArray, Class clazz) {
        this(string, string2, stringArray, clazz, o);
    }

    public AlgorithmID(String string, String string2, String[] stringArray, Class clazz, boolean bl) {
        this();
        if (clazz != null && !(n == null ? (n = AlgorithmID.class$("java.security.spec.AlgorithmParameterSpec")) : n).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("algorithmParameterSpec (" + clazz.getName() + ") does not implement AlgorithmParameterSpec!");
        }
        this.q = new ObjectID(string, string2, null, false);
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string3 = stringArray[i2];
                if (string3 == null) continue;
                if (i2 == 0) {
                    implementations.put(this.q, string3);
                }
                algorithms.put(string3, this);
            }
        }
        if (clazz != null) {
            algorithmParameterSpecs.put(this, clazz);
        }
        this.s = bl;
    }

    public AlgorithmID(ObjectID objectID) {
        this();
        this.q = objectID;
        this.r = null;
    }

    public AlgorithmID(ObjectID objectID, ASN1Object aSN1Object) {
        this();
        this.q = objectID;
        if (aSN1Object != null) {
            try {
                this.r = new ASN1(aSN1Object);
            }
            catch (CodingException codingException) {
                // empty catch block
            }
        }
    }

    public AlgorithmID(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public AlgorithmID(DerInputStream derInputStream) throws IOException {
        this();
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.q = derInputStream2.readObjectID();
        try {
            if (derInputStream2.nextTag() != -1) {
                this.r = new ASN1(derInputStream2);
            } else {
                this.s = false;
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding algorithm parameter.");
        }
    }

    public void encodeAbsentParametersAsNull(boolean bl) {
        this.s = bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("AlgorithmID must be SEQUENCE!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1 || n2 > 2) {
            throw new CodingException("Invalid number of components (" + n2 + ") in algorithm id!");
        }
        try {
            this.q = (ObjectID)aSN1Object.getComponentAt(0);
            if (aSN1Object.countComponents() == 2) {
                this.r = new ASN1(aSN1Object.getComponentAt(1));
            } else {
                this.s = false;
            }
        }
        catch (Exception exception) {
            throw new CodingException("Error parsing algorithmID: " + exception.toString());
        }
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.s);
    }

    public ASN1Object toASN1Object(boolean bl) {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.q);
        if (this.r != null) {
            sEQUENCE.addComponent(this.r.toASN1Object());
        } else if (bl) {
            NULL nULL = new NULL();
            try {
                this.r = new ASN1(nULL);
            }
            catch (CodingException codingException) {
                // empty catch block
            }
            sEQUENCE.addComponent(nULL);
        }
        return sEQUENCE;
    }

    public String getImplementationName() throws NoSuchAlgorithmException {
        String string = (String)implementations.get(this.q);
        if (string == null) {
            throw new NoSuchAlgorithmException("No implementation for: " + this.getName());
        }
        return string;
    }

    public Object getInstance() throws NoSuchAlgorithmException {
        return this.getInstance(null);
    }

    public Object getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? this.getMessageDigestInstance() : this.getMessageDigestInstance(string);
        }
        catch (Exception exception) {
            try {
                return string == null ? this.getSignatureInstance() : this.getSignatureInstance(string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? this.getCipherInstance() : this.getCipherInstance(string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? this.getKeyAgreementInstance() : this.getKeyAgreementInstance(string);
                    }
                    catch (Exception exception4) {
                        try {
                            return string == null ? this.getKeyFactoryInstance() : this.getKeyFactoryInstance(string);
                        }
                        catch (Exception exception5) {
                            try {
                                return string == null ? this.getMacInstance() : this.getMacInstance(string);
                            }
                            catch (Exception exception6) {
                                throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                            }
                        }
                    }
                }
            }
        }
    }

    public Cipher getCipherInstance() throws NoSuchAlgorithmException {
        return this.getCipherInstance(null);
    }

    public Cipher getCipherInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? Cipher.getInstance(this.getImplementationName()) : Cipher.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? Cipher.getInstance(this.q.getID()) : Cipher.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? Cipher.getInstance(this.q.getName()) : Cipher.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                }
            }
        }
    }

    public Signature getSignatureInstance() throws NoSuchAlgorithmException {
        return this.getSignatureInstance(null);
    }

    public Signature getSignatureInstance(String string) throws NoSuchAlgorithmException {
        Signature signature = null;
        try {
            signature = string == null ? Signature.getInstance(this.getImplementationName()) : Signature.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (signature == null) {
            try {
                signature = string == null ? Signature.getInstance(this.q.getID()) : Signature.getInstance(this.q.getID(), string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (signature == null) {
            try {
                signature = string == null ? Signature.getInstance(this.q.getName()) : Signature.getInstance(this.q.getName(), string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (signature != null) {
            if (this.hasParameters()) {
                try {
                    AlgorithmParameterSpec algorithmParameterSpec = this.getAlgorithmParameterSpec(string);
                    if (algorithmParameterSpec != null) {
                        signature.setParameter(algorithmParameterSpec);
                    }
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new NoSuchAlgorithmException("Error converting parameters: " + invalidAlgorithmParameterException);
                }
            }
            return signature;
        }
        throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        return this.getMessageDigestInstance(null);
    }

    public MessageDigest getMessageDigestInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? MessageDigest.getInstance(this.getImplementationName()) : MessageDigest.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? MessageDigest.getInstance(this.q.getID()) : MessageDigest.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? MessageDigest.getInstance(this.q.getName()) : MessageDigest.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                }
            }
        }
    }

    public Mac getMacInstance() throws NoSuchAlgorithmException {
        return this.getMacInstance(null);
    }

    public Mac getMacInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? Mac.getInstance(this.getImplementationName()) : Mac.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? Mac.getInstance(this.q.getID()) : Mac.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? Mac.getInstance(this.q.getName()) : Mac.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                }
            }
        }
    }

    public KeyAgreement getKeyAgreementInstance() throws NoSuchAlgorithmException {
        return this.getKeyAgreementInstance(null);
    }

    public KeyAgreement getKeyAgreementInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyAgreement.getInstance(this.getImplementationName()) : KeyAgreement.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyAgreement.getInstance(this.q.getID()) : KeyAgreement.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyAgreement.getInstance(this.q.getName()) : KeyAgreement.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                }
            }
        }
    }

    public KeyFactory getKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getKeyFactoryInstance(null);
    }

    public KeyFactory getKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyFactory.getInstance(this.getImplementationName()) : KeyFactory.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyFactory.getInstance(this.q.getID()) : KeyFactory.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyFactory.getInstance(this.q.getName()) : KeyFactory.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                }
            }
        }
    }

    public KeyPairGenerator getKeyPairGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyPairGeneratorInstance(null);
    }

    public KeyPairGenerator getKeyPairGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyPairGenerator.getInstance(this.getImplementationName()) : KeyPairGenerator.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyPairGenerator.getInstance(this.q.getID()) : KeyPairGenerator.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyPairGenerator.getInstance(this.q.getName()) : KeyPairGenerator.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                }
            }
        }
    }

    public KeyGenerator getKeyGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyGeneratorInstance(null);
    }

    public KeyGenerator getKeyGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyGenerator.getInstance(this.getRawImplementationName()) : KeyGenerator.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyGenerator.getInstance(this.getImplementationName()) : KeyGenerator.getInstance(this.getImplementationName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyGenerator.getInstance(this.q.getID()) : KeyGenerator.getInstance(this.q.getID(), string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? KeyGenerator.getInstance(this.q.getName()) : KeyGenerator.getInstance(this.q.getName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                    }
                }
            }
        }
    }

    public SecretKeyFactory getSecretKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getSecretKeyFactoryInstance(null);
    }

    public SecretKeyFactory getSecretKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? SecretKeyFactory.getInstance(this.getRawImplementationName()) : SecretKeyFactory.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? SecretKeyFactory.getInstance(this.q.getID()) : SecretKeyFactory.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? SecretKeyFactory.getInstance(this.q.getName()) : SecretKeyFactory.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? SecretKeyFactory.getInstance(this.getImplementationName()) : SecretKeyFactory.getInstance(this.getImplementationName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                    }
                }
            }
        }
    }

    private AlgorithmParameters a(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? AlgorithmParameters.getInstance(this.getImplementationName()) : AlgorithmParameters.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? AlgorithmParameters.getInstance(this.getRawImplementationName()) : AlgorithmParameters.getInstance(this.getRawImplementationName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? AlgorithmParameters.getInstance(this.q.getID()) : AlgorithmParameters.getInstance(this.q.getID(), string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? AlgorithmParameters.getInstance(this.q.getName()) : AlgorithmParameters.getInstance(this.q.getName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                    }
                }
            }
        }
    }

    public MaskGenerationAlgorithm getMaskGenerationAlgorithmInstance() throws NoSuchAlgorithmException {
        return this.getMaskGenerationAlgorithmInstance(null);
    }

    public MaskGenerationAlgorithm getMaskGenerationAlgorithmInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? MaskGenerationAlgorithm.getInstance(this.getImplementationName()) : MaskGenerationAlgorithm.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? MaskGenerationAlgorithm.getInstance(this.q.getID()) : MaskGenerationAlgorithm.getInstance(this.q.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? MaskGenerationAlgorithm.getInstance(this.q.getName()) : MaskGenerationAlgorithm.getInstance(this.q.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.q.getName());
                }
            }
        }
    }

    public String getRawImplementationName() throws NoSuchAlgorithmException {
        String string = this.getImplementationName();
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public Object clone() {
        AlgorithmID algorithmID = null;
        try {
            algorithmID = (AlgorithmID)super.clone();
            if (this.q != null) {
                algorithmID.q = (ObjectID)this.q.clone();
            }
            if (this.r != null) {
                algorithmID.r = (ASN1)this.r.clone();
            }
            algorithmID.s = this.s;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return algorithmID;
    }

    public ObjectID getAlgorithm() {
        return this.q;
    }

    public ASN1Object getParameter() {
        ASN1Object aSN1Object = null;
        if (this.r != null) {
            aSN1Object = this.r.toASN1Object();
        }
        return aSN1Object;
    }

    public boolean hasParameters() {
        ASN1Object aSN1Object;
        boolean bl = false;
        if (this.r != null && !(aSN1Object = this.r.toASN1Object()).isA(ASN.NULL)) {
            bl = true;
        }
        return bl;
    }

    public AlgorithmParameters getAlgorithmParameters(String string) throws NoSuchAlgorithmException {
        return this.getAlgorithmParameters(string, null);
    }

    public AlgorithmParameters getAlgorithmParameters(String string, String string2) throws NoSuchAlgorithmException {
        try {
            if (this.r == null || this.r.toASN1Object().isA(ASN.NULL)) {
                throw new NoSuchAlgorithmException("No algorithm parameters.");
            }
            AlgorithmParameters algorithmParameters = null;
            algorithmParameters = string != null ? (string2 == null ? AlgorithmParameters.getInstance(string) : AlgorithmParameters.getInstance(string, string2)) : this.a(string2);
            algorithmParameters.init(this.r.toByteArray());
            return algorithmParameters;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("No such provider: " + string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public AlgorithmParameters getAlgorithmParameters() throws NoSuchAlgorithmException {
        if (this.r == null || this.r.toASN1Object().isA(ASN.NULL)) {
            return null;
        }
        return this.getAlgorithmParameters(null, null);
    }

    public void setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        if (algorithmParameters == null) {
            this.r = null;
        } else {
            try {
                this.r = new ASN1(algorithmParameters.getEncoded());
            }
            catch (CodingException codingException) {
                throw new RuntimeException(codingException.toString());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.setAlgorithmParameterSpec(algorithmParameterSpec, null);
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec, String string) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.r = null;
        } else {
            try {
                AlgorithmParameters algorithmParameters = this.a(string);
                algorithmParameters.init(algorithmParameterSpec);
                this.setAlgorithmParameters(algorithmParameters);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.toString());
            }
        }
    }

    public void setParameter(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            this.r = null;
        } else {
            try {
                this.r = new ASN1(aSN1Object);
            }
            catch (CodingException codingException) {
                // empty catch block
            }
        }
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() throws InvalidAlgorithmParameterException {
        return this.getAlgorithmParameterSpec(null);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(String string) throws InvalidAlgorithmParameterException {
        Class clazz = (Class)algorithmParameterSpecs.get(this);
        return this.getAlgorithmParameterSpec(clazz, string);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(Class clazz, String string) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (clazz != null && this.hasParameters()) {
            if (!(n == null ? (n = AlgorithmID.class$("java.security.spec.AlgorithmParameterSpec")) : n).isAssignableFrom(clazz)) {
                throw new InvalidAlgorithmParameterException("parameterSpecClass (" + clazz.getName() + ") does not implement AlgorithmParameterSpec!");
            }
            try {
                AlgorithmParameters algorithmParameters = this.getAlgorithmParameters(this.getImplementationName(), string);
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(clazz);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("No AlgorithmParameters implementation available: " + invalidParameterSpecException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("No AlgorithmParameters implementation available: " + noSuchAlgorithmException);
            }
        }
        return algorithmParameterSpec;
    }

    public String getName() {
        return this.q.getName();
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean bl) {
        boolean bl2 = false;
        if (this == object) {
            bl2 = true;
        } else if (!(object instanceof AlgorithmID)) {
            bl2 = false;
        } else {
            AlgorithmID algorithmID = (AlgorithmID)object;
            bl2 = this.q.equals(algorithmID.q);
            if (bl2 && bl) {
                ASN1 aSN1;
                ASN1 aSN12 = this.r;
                if (aSN12 != null && aSN12.toASN1Object().isA(ASN.NULL)) {
                    aSN12 = null;
                }
                if ((aSN1 = algorithmID.r) != null && aSN1.toASN1Object().isA(ASN.NULL)) {
                    aSN1 = null;
                }
                bl2 = aSN12 != null && aSN1 != null ? CryptoUtils.equalsBlock(aSN12.toByteArray(), aSN1.toByteArray()) : aSN12 == null && aSN1 == null;
            }
        }
        return bl2;
    }

    public int hashCode() {
        return this.q.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.q.getNameAndID() + " ");
        if (this.r != null && !this.r.toASN1Object().isA(ASN.NULL)) {
            stringBuffer.append(" with parameter");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        rc4 = arcfour = new AlgorithmID("1.2.840.113549.3.4", "ARCFOUR", "ARCFOUR/ECB/NoPadding", null, o);
        des_EDE3_CBC = new AlgorithmID("1.2.840.113549.3.7", "DES-EDE3-CBC", "DESede/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        des_CBC = new AlgorithmID("1.3.14.3.2.7", "DES-CBC", "DES/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        idea_CBC = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.2", "IDEA-CBC", "IDEA/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        aes128_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.2", "AES128-CBC", new String[]{"AES128/CBC/PKCS5Padding", "AES/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        aes192_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.22", "AES192-CBC", "AES192/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        aes256_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.42", "AES256-CBC", "AES256/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        camellia128_CBC = new AlgorithmID("1.2.392.200011.61.1.1.1.2", "Camellia128-CBC", new String[]{"Camellia128/CBC/PKCS5Padding", "Camellia/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        camellia192_CBC = new AlgorithmID("1.2.392.200011.61.1.1.1.3", "Camellia192-CBC", "Camellia192/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        camellia256_CBC = new AlgorithmID("1.2.392.200011.61.1.1.1.4", "Camellia256-CBC", "Camellia256/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, o);
        cast5_CBC = new AlgorithmID("1.2.840.113533.7.66.10", "CAST5-CBC", "CAST5/CBC/PKCS5Padding", d == null ? (d = AlgorithmID.class$("iaik.security.cipher.CAST128ParameterSpec")) : d, o);
        rc5_CBC = new AlgorithmID("1.2.840.113549.3.8", "RC5-CBC", "RC5/CBC/PKCS5Padding", e == null ? (e = AlgorithmID.class$("javax.crypto.spec.RC5ParameterSpec")) : e, o);
        aes128_CCM = new AlgorithmID("2.16.840.1.101.3.4.1.7", "AES128-CCM", new String[]{"AES128/CCM/NoPadding", "AES/CCM/NoPadding"}, f == null ? (f = AlgorithmID.class$("iaik.security.cipher.CCMParameterSpec")) : f, o);
        aes192_CCM = new AlgorithmID("2.16.840.1.101.3.4.1.27", "AES192-CCM", "AES192/CCM/NoPadding", f == null ? (f = AlgorithmID.class$("iaik.security.cipher.CCMParameterSpec")) : f, o);
        aes256_CCM = new AlgorithmID("2.16.840.1.101.3.4.1.47", "AES256-CCM", "AES256/CCM/NoPadding", f == null ? (f = AlgorithmID.class$("iaik.security.cipher.CCMParameterSpec")) : f, o);
        aes128_GCM = new AlgorithmID("2.16.840.1.101.3.4.1.6", "AES128-GCM", new String[]{"AES128/GCM/NoPadding", "AES/GCM/NoPadding"}, g == null ? (g = AlgorithmID.class$("iaik.security.cipher.GCMParameterSpec")) : g, o);
        aes192_GCM = new AlgorithmID("2.16.840.1.101.3.4.1.26", "AES192-GCM", "AES192/GCM/NoPadding", g == null ? (g = AlgorithmID.class$("iaik.security.cipher.GCMParameterSpec")) : g, o);
        aes256_GCM = new AlgorithmID("2.16.840.1.101.3.4.1.46", "AES256-GCM", "AES256/GCM/NoPadding", g == null ? (g = AlgorithmID.class$("iaik.security.cipher.GCMParameterSpec")) : g, o);
        dhKeyAgreement = new AlgorithmID("1.2.840.113549.1.3.1", "DH Key Agreement", new String[]{"DH", "DiffieHellmann"}, null, o);
        esdhKeyAgreement = new AlgorithmID("1.2.840.113549.1.9.16.3.5", "ESDH Key Agreement", "ESDH", null, o);
        esdh = new AlgorithmID("1.2.840.10046.2.1", "ESDH", "ESDH", null, o);
        ssdhKeyAgreement = new AlgorithmID("1.2.840.113549.1.9.16.3.10", "SSDH Key Agreement", "SSDH", null, o);
        rsaEncryption = new AlgorithmID("1.2.840.113549.1.1.1", "rsaEncryption", "RSA", null, true);
        md2WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.2", "md2WithRSAEncryption", new String[]{"MD2/RSA", "MD2withRSA"}, null, true);
        md4WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.3", "md4WithRSAEncryption", (String)null, null, true);
        md5WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.4", "md5WithRSAEncryption", new String[]{"MD5/RSA", "MD5withRSA"}, null, true);
        sha1WithRSAEncryption_ = new AlgorithmID("1.3.14.3.2.29", "sha1WithRSAEncryption", "SHA1/RSA", null, true, false);
        sha1WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.5", "sha1WithRSAEncryption", new String[]{"SHA1/RSA", "SHA-1/RSA", "SHA/RSA", "SHA1withRSA"}, null, true);
        sha224WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.14", "sha224WithRSAEncryption", new String[]{"SHA224/RSA", "SHA-224/RSA", "SHA224withRSA"}, null, true);
        sha256WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.11", "sha256WithRSAEncryption", new String[]{"SHA256/RSA", "SHA-256/RSA", "SHA256withRSA"}, null, true);
        sha384WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.12", "sha384WithRSAEncryption", new String[]{"SHA384/RSA", "SHA-384/RSA", "SHA384withRSA"}, null, true);
        sha512WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.13", "sha512WithRSAEncryption", new String[]{"SHA512/RSA", "SHA-512/RSA", "SHA512withRSA"}, null, true);
        dsa_ = new AlgorithmID("1.3.14.3.2.12", "DSA", "DSA", h == null ? (h = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : h, o, false);
        dsa = new AlgorithmID("1.2.840.10040.4.1", "DSA", "DSA", h == null ? (h = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : h, o);
        dsa_With_SHA1 = new AlgorithmID("1.3.14.3.2.13", "dsaWithSHA1", "SHA-1/DSA", h == null ? (h = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : h, false, false);
        dsaWithSHA1 = dsaWithSHA = new AlgorithmID("1.2.840.10040.4.3", "dsaWithSHA", new String[]{"SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "SHA1withDSA"}, h == null ? (h = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : h, false);
        dsaWithSHA1_ = new AlgorithmID("1.3.14.3.2.27", "dsaWithSHA1", "SHA-1/DSA", h == null ? (h = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : h, false, false);
        dsaWithSHA224 = new AlgorithmID("2.16.840.1.101.3.4.3.1", "dsaWithSHA224", new String[]{"SHA224withDSA", "SHA-224/DSA", "SHA224/DSA"}, h == null ? (h = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : h, false);
        dsaWithSHA256 = new AlgorithmID("2.16.840.1.101.3.4.3.2", "dsaWithSHA256", new String[]{"SHA256withDSA", "SHA-256/DSA", "SHA256/DSA"}, h == null ? (h = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : h, false);
        ecPublicKey = ecdsa = new AlgorithmID("1.2.840.10045.2.1", "ECPublicKey", "ECDSA", null, o);
        ecDH = new AlgorithmID("1.3.132.1.12", "ecDH", "ECDH", null, o);
        dhSinglePass_stdDH_sha1kdf_scheme = new AlgorithmID("1.3.133.16.840.63.0.2", "STD-ECDH", "ECDH");
        dhSinglePass_cofactorDH_sha1kdf_scheme = new AlgorithmID("1.3.133.16.840.63.0.3", "COFACTOR-ECDH", "ECDHwithCofactor");
        dhSinglePass_stdDH_sha256kdf_scheme = new AlgorithmID("1.3.132.1.11.1", "STD-ECDH", "ECDH");
        dhSinglePass_stdDH_sha384kdf_scheme = new AlgorithmID("1.3.132.1.11.2", "STD-ECDH", "ECDH");
        gost3410 = new AlgorithmID("1.2.643.2.2.19", "gostR3410-2001", "GOST3410", null, false);
        ecdsa_With_SHA1 = new AlgorithmID("1.2.840.10045.4.1", "ecdsaWithSHA1", new String[]{"SHA1withECDSA", "SHA1/ECDSA", "SHA-1/ECDSA"}, null, false);
        ecdsa_With_SHA224 = new AlgorithmID("1.2.840.10045.4.3.1", "ecdsaWithSHA224", new String[]{"SHA224withECDSA", "SHA224/ECDSA", "SHA-224/ECDSA"}, null, false);
        ecdsa_With_SHA256 = new AlgorithmID("1.2.840.10045.4.3.2", "ecdsaWithSHA256", new String[]{"SHA256withECDSA", "SHA256/ECDSA", "SHA-256/ECDSA"}, null, false);
        ecdsa_With_SHA384 = new AlgorithmID("1.2.840.10045.4.3.3", "ecdsaWithSHA384", new String[]{"SHA384withECDSA", "SHA384/ECDSA", "SHA-384/ECDSA"}, null, false);
        ecdsa_With_SHA512 = new AlgorithmID("1.2.840.10045.4.3.4", "ecdsaWithSHA512", new String[]{"SHA512withECDSA", "SHA512/ECDSA", "SHA-512/ECDSA"}, null, false);
        ecdsa_plain_With_SHA1 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.1", "ecdsaPlainWithSHA1", "SHA1withECDSAPlain", null, false);
        ecdsa_plain_With_SHA224 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.2", "ecdsaPlainWithSHA224", "SHA224withECDSAPlain", null, false);
        ecdsa_plain_With_SHA256 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.3", "ecdsaPlainWithSHA256", "SHA256withECDSAPlain", null, false);
        ecdsa_plain_With_SHA384 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.4", "ecdsaPlainWithSHA384", "SHA384withECDSAPlain", null, false);
        ecdsa_plain_With_SHA512 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.5", "ecdsaPlainWithSHA512", "SHA512withECDSAPlain", null, false);
        ecdsa_plain_With_RIPEMD160 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.6", "ecdsaPlainWithRIPEMD160", "RIPEMD160withECDSAPlain", null, false);
        rsaSignatureWithRipemd160 = new AlgorithmID("1.3.36.3.3.1.2", "rsaSignatureWithRipemd160", "RIPEMD160/RSA", null, o);
        rsaSignatureWithRipemd128 = new AlgorithmID("1.3.36.3.3.1.3", "rsaSignatureWithRipemd128", "RIPEMD128/RSA", null, o);
        rsaSignatureWithRipemd256 = new AlgorithmID("1.3.36.3.3.1.4", "rsaSignatureWithRipemd256", "RIPEMD256/RSA", null, o);
        sigS_ISO9796_2Withrsa = new AlgorithmID("1.3.36.3.4.2.2", "RSA-ISO9796-2-2-3", "RSA-ISO9796-2-2-3", null, o);
        sigS_ISO9796_2Withsha1 = new AlgorithmID("1.3.36.3.4.2.2.1", "SHAandMGF1/RSA-ISO9796-2-2-3", "SHAandMGF1/RSA-ISO9796-2-2-3", null, o);
        sigS_ISO9796_2Withripemd160 = new AlgorithmID("1.3.36.3.4.2.2.2", "RSA-ISO9796_2Withripemd160", "RIPEMD160andMGF1/RSA-ISO9796-2-2-3", null, o);
        sigS_ISO9796_2rndWithrsa = new AlgorithmID("1.3.36.3.4.2.3", "RSA-ISO9796-2-2-3", "RSA-ISO9796-2-2-3", null, o);
        sigS_ISO9796_2rndWithsha1 = new AlgorithmID("1.3.36.3.4.2.3.1", "SHAandMGF1/RSA-ISO9796-2-2-3", "SHAandMGF1/RSA-ISO9796-2-2-3", null, o);
        sigS_ISO9796_2rndWithripemd160 = new AlgorithmID("1.3.36.3.4.2.3.2", "RSA-ISO9796_2Withripemd160", "RIPEMD160andMGF1/RSA-ISO9796-2-2-3", null, o);
        mgf1 = new AlgorithmID("1.2.840.113549.1.1.8", "MGF1", "MGF1", null, o);
        pbeWithMD5AndDES_CBC = new AlgorithmID("1.2.840.113549.1.5.3", "PbeWithMD5AndDES-CBC", new String[]{"PbeWithMD5AndDES_CBC", "PBEWithMD5AndDES"}, i == null ? (i = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : i, o);
        pbeWithSHAAnd128BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.1", "PbeWithSHAAnd128BitRC4", (String)null, i == null ? (i = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : i, o);
        pbeWithSHAAnd40BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.2", "PbeWithSHAAnd40BitRC4", (String)null, i == null ? (i = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : i, o);
        pbeWithSHAAnd3_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.3", "PbeWithSHAAnd3-KeyTripleDES-CBC", "PbeWithSHAAnd3_KeyTripleDES_CBC", i == null ? (i = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : i, o);
        pbeWithSHAAnd2_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.4", "PbeWithSHAAnd2-KeyTripleDES-CBC", (String)null, i == null ? (i = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : i, o);
        pbeWithSHAAnd128BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.5", "PbeWithSHAAnd128BitRC2-CBC", (String)null, i == null ? (i = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : i, o);
        pbeWithSHAAnd40BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.6", "PbeWithSHAAnd40BitRC2-CBC", "PbeWithSHAAnd40BitRC2_CBC", i == null ? (i = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : i, o);
        pbkdf2 = new AlgorithmID("1.2.840.113549.1.5.12", "PBKDF2", "PBKDF2", j == null ? (j = AlgorithmID.class$("iaik.pkcs.pkcs5.PBKDF2ParameterSpec")) : j, o);
        pbes2 = new AlgorithmID("1.2.840.113549.1.5.13", "PBES2", "PBES2", k == null ? (k = AlgorithmID.class$("iaik.pkcs.pkcs5.PBES2ParameterSpec")) : k, o);
        pSpecified = new AlgorithmID("1.2.840.113549.1.1.9", "pSpecified", "pSpecified", null, o);
        md2 = new AlgorithmID("1.2.840.113549.2.2", "MD2", "MD2", null, o);
        md4 = new AlgorithmID("1.2.840.113549.2.4", "MD4", (String)null, null, o);
        md5 = new AlgorithmID("1.2.840.113549.2.5", "MD5", "MD5", null, o);
        sha1 = sha = new AlgorithmID("1.3.14.3.2.26", "SHA1", new String[]{"SHA1", "SHA-1", "SHA"}, null, o);
        gost3411 = new AlgorithmID("1.2.643.2.2.9", "GOST-R-34.11-94", "GOST3411", null, o);
        sha256 = new AlgorithmID("2.16.840.1.101.3.4.2.1", "SHA256", new String[]{"SHA256", "SHA-256"}, null, o);
        sha224 = new AlgorithmID("2.16.840.1.101.3.4.2.4", "SHA224", new String[]{"SHA224", "SHA-224"}, null, o);
        sha384 = new AlgorithmID("2.16.840.1.101.3.4.2.2", "SHA384", new String[]{"SHA384", "SHA-384"}, null, o);
        sha512 = new AlgorithmID("2.16.840.1.101.3.4.2.3", "SHA512", new String[]{"SHA512", "SHA-512"}, null, o);
        sha512_224 = new AlgorithmID("2.16.840.1.101.3.4.2.5", "SHA512/224", "SHA512/224", null, o);
        sha512_256 = new AlgorithmID("2.16.840.1.101.3.4.2.6", "SHA512/256", "SHA512/256", null, o);
        sha3_224 = new AlgorithmID("2.16.840.1.101.3.4.2.7", "SHA3-224", new String[]{"SHA3-224"}, null, o);
        sha3_256 = new AlgorithmID("2.16.840.1.101.3.4.2.8", "SHA3-256", new String[]{"SHA3-256"}, null, o);
        sha3_384 = new AlgorithmID("2.16.840.1.101.3.4.2.9", "SHA3-384", new String[]{"SHA3-384"}, null, o);
        sha3_512 = new AlgorithmID("2.16.840.1.101.3.4.2.10", "SHA3-512", new String[]{"SHA3-512"}, null, o);
        shake128 = new AlgorithmID("2.16.840.1.101.3.4.2.11", "SHAKE128", new String[]{"SHAKE128", "SHAKE-128"}, null, o);
        shake256 = new AlgorithmID("2.16.840.1.101.3.4.2.12", "SHAKE256", new String[]{"SHAKE256", "SHAKE-256"}, null, o);
        ripeMd160_ISO = new AlgorithmID("1.0.10118.3.0.49", "RipeMd160", "RIPEMD160", null, o, false);
        ripeMd128_ISO = new AlgorithmID("1.0.10118.3.0.50", "RipeMd128", "RIPEMD128", null, o, false);
        ripeMd160 = new AlgorithmID("1.3.36.3.2.1", "RipeMd160", new String[]{"RIPEMD160", "RIPEMD-160"}, null, o);
        ripeMd128 = new AlgorithmID("1.3.36.3.2.2", "RipeMd128", new String[]{"RIPEMD128", "RIPEMD-128"}, null, o);
        ripeMd256 = new AlgorithmID("1.3.36.3.2.3", "RipeMd256", new String[]{"RIPEMD256", "RIPEMD-256"}, null, o);
        whirlpool = new AlgorithmID("1.0.10118.3.0.55", "Whirlpool", "Whirlpool", null, o);
        hMAC_GOST = new AlgorithmID("1.2.643.2.2.10", "HMAC_GOSTR3411", new String[]{"HMAC/GOST", "HmacGOST"}, null, o);
        hMAC_MD5 = new AlgorithmID("1.3.6.1.5.5.8.1.1", "hMAC-MD5", new String[]{"HMAC/MD5", "HmacMD5"}, null, o);
        hMAC_SHA1_ = new AlgorithmID("1.2.840.113549.2.7", "hMAC-SHA1", "HMAC/SHA1", null, o);
        hMAC_SHA1 = new AlgorithmID("1.3.6.1.5.5.8.1.2", "hMAC-SHA1", new String[]{"HMAC/SHA1", "HMAC/SHA-1", "HmacSHA1"}, null, o);
        hMAC_SHA224 = new AlgorithmID("1.2.840.113549.2.8", "hMAC-SHA224", new String[]{"HMAC/SHA224", "HMAC/SHA-224", "HmacSHA224"}, null, o);
        hMAC_SHA256 = new AlgorithmID("1.2.840.113549.2.9", "hMAC-SHA256", new String[]{"HMAC/SHA256", "HMAC/SHA-256", "HmacSHA256"}, null, o);
        hMAC_SHA384 = new AlgorithmID("1.2.840.113549.2.10", "hMAC-SHA384", new String[]{"HMAC/SHA384", "HMAC/SHA-384", "HmacSHA384"}, null, o);
        hMAC_SHA512 = new AlgorithmID("1.2.840.113549.2.11", "hMAC-SHA512", new String[]{"HMAC/SHA512", "HMAC/SHA-512", "HmacSHA512"}, null, o);
        hMAC_RIPEMD160 = new AlgorithmID("1.3.6.1.5.5.8.1.4", "hMAC-RIPEMD160", new String[]{"HMAC/RIPEMD160", "HmacRIPEMD160"}, null, o);
        cms_3DES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.6", "CMS-3DES-Wrap", new String[]{"3DESWrap3DES", "DESedeWrapDESede", "DESedeWrap"}, null, o);
        cms_rc2_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.7", "CMS-RC2-Wrap", "RC2WrapRC2", null, o);
        cms_idea_wrap = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.6", "CMS-IDEA-Wrap", "IDEAWrapIDEA", null, o);
        cms_cast5_wrap = new AlgorithmID("1.2.840.113533.7.66.15", "CMS-CAST128-Wrap", "CAST128WrapCAST128", null, o);
        cms_aes128_wrap = new AlgorithmID("2.16.840.1.101.3.4.1.5", "CMS-AES128-Wrap", new String[]{"AESWrapAES", "AESWrap"}, null, o);
        cms_aes192_wrap = new AlgorithmID("2.16.840.1.101.3.4.1.25", "CMS-AES192-Wrap", new String[]{"AES192WrapAES192", "AES192Wrap"}, null, o);
        cms_aes256_wrap = new AlgorithmID("2.16.840.1.101.3.4.1.45", "CMS-AES256-Wrap", new String[]{"AES256WrapAES256", "AES256Wrap"}, null, o);
        cms_camellia128_wrap = new AlgorithmID("1.2.392.200011.61.1.1.3.2", "CMS-Camellia128-Wrap", new String[]{"CamelliaWrapCamellia", "CamelliaWrap"}, null, false);
        cms_camellia192_wrap = new AlgorithmID("1.2.392.200011.61.1.1.3.3", "CMS-Camellia192-Wrap", new String[]{"Camellia192WrapCamellia192", "Camellia192Wrap"}, null, false);
        cms_camellia256_wrap = new AlgorithmID("1.2.392.200011.61.1.1.3.4", "CMS-Camellia256-Wrap", new String[]{"Camellia256WrapCamellia256", "Camellia256Wrap"}, null, false);
        cms_HMACwith3DES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.11", "CMS-HMACwith3DES-Wrap", "3DESWrapHMAC", null, true);
        cms_HMACwithAES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.12", "CMS-HMACwithAES-Wrap", "AESWrapHMAC", null, true);
        pwri_kek = new AlgorithmID("1.2.840.113549.1.9.16.3.9", "PWRI-KEK", "PWRI-KEK", null, o);
        zlib_compress = new AlgorithmID("1.2.840.113549.1.9.16.3.8", "ZLIB-COMPRESS", "ZLIB-COMPRESS", null, o);
        rsaesOAEP = new AlgorithmID("1.2.840.113549.1.1.7", "RSAES-OAEP", "RSA/ECB/OAEP", l == null ? (l = AlgorithmID.class$("iaik.pkcs.pkcs1.RSAOaepParameterSpec")) : l, o);
        rsassaPss = new AlgorithmID("1.2.840.113549.1.1.10", "RSASSA-PSS", "RSASSA-PSS", m == null ? (m = AlgorithmID.class$("iaik.pkcs.pkcs1.RSAPssParameterSpec")) : m, o);
        p.put(dsa_With_SHA1, dsa_With_SHA1);
        p.put(dsaWithSHA, dsaWithSHA);
        p.put(dsaWithSHA1, dsaWithSHA1);
        p.put(dsa, dsa);
        p.put(dsa_, dsa_);
        p.put(ecdsa_With_SHA1, ecdsa_With_SHA1);
        p.put(ecdsa, ecdsa);
    }
}

