/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NetscapeCertList {
    private X509Certificate[] b = null;
    static Class a;

    public NetscapeCertList() {
    }

    public NetscapeCertList(InputStream inputStream) throws IOException, PKCSParsingException {
        try {
            this.a(inputStream);
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.getMessage());
        }
    }

    public X509Certificate[] getCertificateList() {
        return this.b;
    }

    public void setCertificateList(X509Certificate[] x509CertificateArray) {
        this.b = x509CertificateArray;
    }

    private void a(InputStream inputStream) throws IOException, CodingException {
        ASN1Object aSN1Object = null;
        byte[] byArray = Util.readStream(inputStream);
        ASN1 aSN1 = new ASN1(byArray);
        aSN1Object = aSN1.getComponentAt(0);
        if (!(aSN1Object instanceof ObjectID)) {
            throw new CodingException("Invalid Netscape cert sequence. First component has to be an object identifier!");
        }
        if (!((ObjectID)aSN1Object).equals(ObjectID.netscapeCertSequence)) {
            throw new CodingException("Invalid Netscape cert sequence. Wrong object identifier!");
        }
        aSN1Object = aSN1.getComponentAt(1).getComponentAt(0);
        this.b = (X509Certificate[])ASN.parseSequenceOf(aSN1Object, a == null ? (a = NetscapeCertList.class$("iaik.x509.X509Certificate")) : a);
    }

    private ASN1Object a() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent(ObjectID.netscapeCertSequence);
        ASN1Object aSN1Object = ASN.createSequenceOf(this.b);
        CON_SPEC cON_SPEC = new CON_SPEC(0, aSN1Object);
        sEQUENCE.addComponent(cON_SPEC);
        return sEQUENCE;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo(this.a(), outputStream);
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    public byte[] toByteArray() throws PKCSException {
        try {
            return DerCoder.encode(this.a());
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: netscapeCertSequence  {\n");
        if (this.b == null) {
            stringBuffer.append("No certificates!\n}");
        } else {
            stringBuffer.append(this.b.length + " certificates\n}");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

