/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.PKCS1AlgorithmParameterSpec;

public class RSAOaepPSourceParameterSpec
extends PKCS1AlgorithmParameterSpec {
    public static final AlgorithmID DEFAULT_PSOURCE_ALGORITHM = (AlgorithmID)AlgorithmID.pSpecified.clone();
    protected AlgorithmID pSourceAlgorithm_;

    public static RSAOaepPSourceParameterSpec getDefault() {
        RSAOaepPSourceParameterSpec rSAOaepPSourceParameterSpec = new RSAOaepPSourceParameterSpec();
        rSAOaepPSourceParameterSpec.pSourceAlgorithm_ = (AlgorithmID)AlgorithmID.pSpecified.clone();
        rSAOaepPSourceParameterSpec.pSourceAlgorithm_.setParameter(new OCTET_STRING());
        return rSAOaepPSourceParameterSpec;
    }

    private static AlgorithmID a() {
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.pSpecified.clone();
        algorithmID.setParameter(new OCTET_STRING());
        return algorithmID;
    }

    public RSAOaepPSourceParameterSpec() {
        this.pSourceAlgorithm_ = RSAOaepPSourceParameterSpec.a();
    }

    public RSAOaepPSourceParameterSpec(AlgorithmID algorithmID) {
        if (algorithmID == null) {
            throw new IllegalArgumentException("PSourceAlgorithm must not be null.");
        }
        this.pSourceAlgorithm_ = algorithmID;
        this.getLabel();
    }

    public AlgorithmID getPSourceAlgorithm() {
        return this.pSourceAlgorithm_;
    }

    public byte[] getLabel() {
        ASN1Object aSN1Object;
        byte[] byArray = null;
        if (this.pSourceAlgorithm_ != null && (aSN1Object = this.pSourceAlgorithm_.getParameter()) != null) {
            if (aSN1Object.isA(ASN.OCTET_STRING)) {
                OCTET_STRING oCTET_STRING = (OCTET_STRING)this.pSourceAlgorithm_.getParameter();
                if (oCTET_STRING != null) {
                    byArray = (byte[])((byte[])oCTET_STRING.getValue()).clone();
                }
            } else if (!aSN1Object.isA(ASN.NULL)) {
                throw new IllegalArgumentException("Invalid PSource parameters! Expected ASN.1 OCTET_STRING!");
            }
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public void setLabel(byte[] byArray) {
        if (byArray != null) {
            if (this.pSourceAlgorithm_ == null) {
                throw new NullPointerException("PSourceAlgorithm not set!");
            }
            this.pSourceAlgorithm_.setParameter(new OCTET_STRING((byte[])byArray.clone()));
        }
    }

    public int hashCode() {
        return this.pSourceAlgorithm_.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAOaepPSourceParameterSpec) {
            RSAOaepPSourceParameterSpec rSAOaepPSourceParameterSpec = (RSAOaepPSourceParameterSpec)object;
            bl = this.pSourceAlgorithm_.equals(rSAOaepPSourceParameterSpec.pSourceAlgorithm_, true);
        }
        return bl;
    }

    public String toString() {
        return "PSourceAlgorithm: " + this.pSourceAlgorithm_;
    }

    static {
        DEFAULT_PSOURCE_ALGORITHM.setParameter(new OCTET_STRING());
    }
}

