/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.PKCS1AlgorithmParameters;
import iaik.pkcs.pkcs1.RSAOaepPSourceParameterSpec;
import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAOaepParameters
extends PKCS1AlgorithmParameters {
    private static boolean a;
    private RSAOaepParameterSpec b;

    public static void setEncodeDefaultValues(boolean bl) {
        a = bl;
    }

    public static boolean getEncodeDefaultValues() {
        return a;
    }

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(this.toASN1Object());
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = super.toASN1Object();
        if (aSN1Object == null) {
            boolean bl;
            ASN1Object aSN1Object2;
            if (this.b == null) {
                throw new NullPointerException("Cannot encode null params!");
            }
            AlgorithmID algorithmID = this.b.getHashAlgorithm();
            AlgorithmID algorithmID2 = this.b.getMaskGenAlgorithm();
            AlgorithmID algorithmID3 = this.b.getPSourceAlgorithm();
            Boolean bl2 = this.b.getEncodeDefaultValues();
            boolean bl3 = bl2 != null ? bl2 : a;
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (algorithmID != null && (bl3 || !algorithmID.equals(RSAOaepParameterSpec.DEFAULT_HASH_ALGORITHM))) {
                sEQUENCE.addComponent(new CON_SPEC(0, algorithmID.toASN1Object()));
            }
            if (algorithmID2 != null) {
                ASN1Object aSN1Object3 = null;
                aSN1Object2 = algorithmID2.getParameter();
                if (aSN1Object2 != null && aSN1Object2.isA(ASN.SEQUENCE)) {
                    try {
                        aSN1Object3 = aSN1Object2.getComponentAt(0);
                    }
                    catch (CodingException codingException) {
                        // empty catch block
                    }
                }
                if (bl3 || !algorithmID2.equals(RSAOaepParameterSpec.DEFAULT_MASK_GEN_ALGORITHM) || !RSAOaepParameterSpec.DEFAULT_HASH_ALGORITHM.getAlgorithm().equals(aSN1Object3)) {
                    sEQUENCE.addComponent(new CON_SPEC(1, algorithmID2.toASN1Object()));
                }
            }
            if (!(algorithmID3 == null || !bl3 && algorithmID3.equals(RSAOaepPSourceParameterSpec.DEFAULT_PSOURCE_ALGORITHM) && RSAOaepPSourceParameterSpec.DEFAULT_PSOURCE_ALGORITHM.getParameter().equals(algorithmID3.getParameter()))) {
                sEQUENCE.addComponent(new CON_SPEC(2, algorithmID3.toASN1Object()));
            }
            if (algorithmID3 != null && !(bl = bl3)) {
                if (algorithmID3.equals(RSAOaepPSourceParameterSpec.DEFAULT_PSOURCE_ALGORITHM)) {
                    byte[] byArray;
                    aSN1Object2 = algorithmID3.getParameter();
                    if (aSN1Object2 != null && aSN1Object2.isA(ASN.OCTET_STRING) && (byArray = (byte[])aSN1Object2.getValue()).length > 0) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    sEQUENCE.addComponent(new CON_SPEC(2, algorithmID3.toASN1Object()));
                }
            }
            aSN1Object = sEQUENCE;
        }
        return aSN1Object;
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        RSAOaepParameterSpec rSAOaepParameterSpec = null;
        if (this.b != null) {
            if (!this.b.getClass().isAssignableFrom(clazz)) {
                try {
                    Class<?> clazz2 = Class.forName("iaik.pkcs.pkcs1.PKCS1AlgorithmParameterSpec");
                    if (!clazz.isAssignableFrom(clazz2)) {
                        throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
                }
            }
            rSAOaepParameterSpec = (RSAOaepParameterSpec)this.b.clone();
        }
        return rSAOaepParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        super.engineInit(algorithmParameterSpec);
        this.b = null;
        if (!(algorithmParameterSpec instanceof RSAOaepParameterSpec)) {
            throw new InvalidParameterSpecException("Parameter must be a RSAOaepParameterSpec.");
        }
        this.b = (RSAOaepParameterSpec)((RSAOaepParameterSpec)algorithmParameterSpec).clone();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        super.engineInit(byArray);
        try {
            this.decode(DerCoder.decode(byArray));
        }
        catch (CodingException codingException) {
            throw new IOException("Parsing error: " + codingException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = null;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid OAEP parameter encoding. Expected ASN.1 SEQUENCE!");
        }
        AlgorithmID algorithmID = null;
        AlgorithmID algorithmID2 = null;
        AlgorithmID algorithmID3 = null;
        block7: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
            int n2 = cON_SPEC.getAsnType().getTag();
            switch (n2) {
                case 0: {
                    algorithmID = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    continue block7;
                }
                case 1: {
                    algorithmID2 = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    continue block7;
                }
                case 2: {
                    algorithmID3 = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    continue block7;
                }
                default: {
                    throw new CodingException("Invalid tagged (" + n2 + ") in OAEP parameter component number " + i2 + ".");
                }
            }
        }
        if (algorithmID == null) {
            algorithmID = RSAOaepParameterSpec.DEFAULT_HASH_ALGORITHM;
        }
        if (algorithmID2 == null) {
            algorithmID2 = RSAOaepParameterSpec.DEFAULT_MASK_GEN_ALGORITHM;
        }
        if (algorithmID3 == null) {
            algorithmID3 = RSAOaepPSourceParameterSpec.DEFAULT_PSOURCE_ALGORITHM;
        }
        try {
            this.b = new RSAOaepParameterSpec(algorithmID, algorithmID2, algorithmID3);
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        if (this.b == null) {
            return "";
        }
        return this.b.toString();
    }
}

