/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.PKCS1AlgorithmParameters;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAPssParameters
extends PKCS1AlgorithmParameters {
    private static boolean a;
    private RSAPssParameterSpec b;

    public static void setEncodeDefaultValues(boolean bl) {
        a = bl;
    }

    public static boolean getEncodeDefaultValues() {
        return a;
    }

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(this.toASN1Object());
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = super.toASN1Object();
        if (aSN1Object == null) {
            if (this.b == null) {
                throw new NullPointerException("Cannot encode null params!");
            }
            AlgorithmID algorithmID = this.b.getHashAlgorithm();
            AlgorithmID algorithmID2 = this.b.getMaskGenAlgorithm();
            int n2 = this.b.getSaltLength();
            int n3 = this.b.getTrailerField();
            Boolean bl = this.b.getEncodeDefaultValues();
            boolean bl2 = bl != null ? bl : a;
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (algorithmID != null && (bl2 || !algorithmID.equals(RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM))) {
                sEQUENCE.addComponent(new CON_SPEC(0, algorithmID.toASN1Object()));
            }
            if (algorithmID2 != null) {
                ASN1Object aSN1Object2 = null;
                ASN1Object aSN1Object3 = algorithmID2.getParameter();
                if (aSN1Object3 != null && aSN1Object3.isA(ASN.SEQUENCE)) {
                    try {
                        aSN1Object2 = aSN1Object3.getComponentAt(0);
                    }
                    catch (CodingException codingException) {
                        // empty catch block
                    }
                }
                if (bl2 || !algorithmID2.equals(RSAPssParameterSpec.DEFAULT_MASK_GEN_ALGORITHM) || !RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM.getAlgorithm().equals(aSN1Object2)) {
                    sEQUENCE.addComponent(new CON_SPEC(1, algorithmID2.toASN1Object()));
                }
            }
            if (n2 != -1 && (bl2 || n2 != 20)) {
                sEQUENCE.addComponent(new CON_SPEC(2, new INTEGER(n2)));
            }
            if (n3 != -1 && (bl2 || n3 != RSAPssParameterSpec.DEFAULT_TRAILER_FIELD)) {
                sEQUENCE.addComponent(new CON_SPEC(3, new INTEGER(n3)));
            }
            aSN1Object = sEQUENCE;
        }
        return aSN1Object;
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!this.b.getClass().isAssignableFrom(clazz)) {
            try {
                Class<?> clazz2 = Class.forName("iaik.pkcs.pkcs1.PKCS1AlgorithmParameterSpec");
                if (!clazz.isAssignableFrom(clazz2)) {
                    throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
            }
        }
        return (RSAPssParameterSpec)this.b.clone();
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        super.engineInit(algorithmParameterSpec);
        this.b = null;
        if (!(algorithmParameterSpec instanceof RSAPssParameterSpec)) {
            throw new InvalidParameterSpecException("Parameter must be a RSAPssParameterSpec.");
        }
        this.b = (RSAPssParameterSpec)((RSAPssParameterSpec)algorithmParameterSpec).clone();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        super.engineInit(byArray);
        try {
            this.decode(DerCoder.decode(byArray));
        }
        catch (CodingException codingException) {
            throw new IOException("Parsing error: " + codingException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = null;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid PSS parameter encoding. Expected ASN.1 SEQUENCE!");
        }
        AlgorithmID algorithmID = null;
        AlgorithmID algorithmID2 = null;
        int n2 = 20;
        int n3 = RSAPssParameterSpec.DEFAULT_TRAILER_FIELD;
        block6: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
            int n4 = cON_SPEC.getAsnType().getTag();
            switch (n4) {
                case 0: {
                    algorithmID = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    continue block6;
                }
                case 1: {
                    algorithmID2 = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    continue block6;
                }
                case 2: {
                    n2 = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
                    continue block6;
                }
                case 3: {
                    n3 = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
                    continue block6;
                }
                default: {
                    throw new CodingException("Invalid tagged (" + n4 + ") in PSS parameter component number " + i2 + ".");
                }
            }
        }
        if (algorithmID == null) {
            algorithmID = RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM;
        }
        if (algorithmID2 == null) {
            algorithmID2 = RSAPssParameterSpec.DEFAULT_MASK_GEN_ALGORITHM;
        }
        this.b = new RSAPssParameterSpec(algorithmID, algorithmID2, n2);
        this.b.setTrailerField(n3);
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        if (this.b == null) {
            return "";
        }
        return this.b.toString();
    }
}

