/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import java.security.InvalidKeyException;
import java.security.PrivateKey;

public class KeyBag
extends SafeBag {
    PrivateKey c;

    protected KeyBag() {
        this.e = ObjectID.pkcs12_keyBag;
    }

    public KeyBag(PrivateKey privateKey) {
        this.c = privateKey;
        this.e = ObjectID.pkcs12_keyBag;
    }

    public KeyBag(PrivateKey privateKey, String string, byte[] byArray) {
        super(string, byArray);
        this.c = privateKey;
        this.e = ObjectID.pkcs12_keyBag;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.c = PrivateKeyInfo.getPrivateKey(aSN1Object);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException("Error creating private key: " + invalidKeyException.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        return DerCoder.decode(this.c.getEncoded());
    }

    public PrivateKey getPrivateKey() {
        return this.c;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PrivateKey algorithm: " + this.c.getAlgorithm() + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

