/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.b;
import iaik.utils.TracedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContentInfo {
    private static b j = new b();
    ObjectID a;
    Content b;
    byte[] c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;
    static Class h;
    static Class i;

    public static Content create(ObjectID objectID) throws PKCSException {
        try {
            return (Content)j.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            throw new PKCSException("No PKCS#7 type registered for the given object ID!");
        }
    }

    public static Content create(ObjectID objectID, ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            Content content = ContentInfo.create(objectID);
            content.decode(aSN1Object);
            return content;
        }
        catch (PKCSException pKCSException) {
            throw new PKCSParsingException(pKCSException.getMessage());
        }
    }

    public static void register(ObjectID objectID, Class clazz) {
        j.register((Object)objectID, clazz);
    }

    private ContentInfo() {
    }

    public ContentInfo(Content content) {
        this.a = content.getContentType();
        this.b = content;
    }

    public ContentInfo(ObjectID objectID) {
        this.a = objectID;
        this.b = null;
    }

    public ContentInfo(ASN1Object aSN1Object) throws PKCSParsingException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(DerCoder.encode(aSN1Object));
        try {
            this.decode(new DerInputStream(byteArrayInputStream));
        }
        catch (IOException iOException) {
            throw new PKCSParsingException("Error parsing ContentInfo: " + iOException.getMessage());
        }
    }

    public ContentInfo(InputStream inputStream) throws IOException, PKCSParsingException {
        if (inputStream instanceof DerInputStream) {
            this.decode((DerInputStream)inputStream);
        } else {
            this.decode(new DerInputStream(inputStream));
        }
    }

    protected void decode(DerInputStream derInputStream) throws IOException, PKCSParsingException {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.a = derInputStream2.readObjectID();
        if (derInputStream2.nextTag() == -1) {
            this.b = null;
            return;
        }
        DerInputStream derInputStream3 = derInputStream2.readContextSpecific();
        try {
            this.b = ContentInfo.create(this.a);
        }
        catch (PKCSException pKCSException) {
            throw new PKCSParsingException(pKCSException.getMessage());
        }
        TracedInputStream tracedInputStream = new TracedInputStream(derInputStream3);
        this.b.decode(tracedInputStream);
        this.c = tracedInputStream.getTracedData();
        derInputStream3.readEOC();
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.a == null) {
            throw new PKCSException("Cannot create ASN.1 object. At least the content type must be set!");
        }
        boolean bl = true;
        bl = this.b == null ? false : this.b.getBlockSize() > 0;
        SEQUENCE sEQUENCE = new SEQUENCE(bl);
        sEQUENCE.addComponent(this.a);
        if (this.b != null) {
            CON_SPEC cON_SPEC = new CON_SPEC(0, this.b.toASN1Object());
            cON_SPEC.setIndefiniteLength(bl);
            sEQUENCE.addComponent(cON_SPEC);
        }
        return sEQUENCE;
    }

    public byte[] toByteArray() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public byte[] getEncoded() throws PKCSException {
        return this.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException, PKCSException {
        DerCoder.encodeTo(this.toASN1Object(), outputStream);
    }

    public boolean hasContent() {
        return this.b != null;
    }

    public Content getContent() {
        return this.b;
    }

    public InputStream getContentInputStream() {
        if (this.c == null) {
            return null;
        }
        return new ByteArrayInputStream(this.c);
    }

    public ObjectID getContentType() {
        return this.a;
    }

    public void setContent(Content content) {
        this.a = content.getContentType();
        this.b = content;
    }

    public void destroyCriticalData() {
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.a.getName() + " {\n");
        if (this.b == null) {
            stringBuffer.append("No content!\n");
        } else {
            stringBuffer.append(this.b.toString(bl) + "\n}");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ContentInfo.register(ObjectID.pkcs7_data, d == null ? (d = ContentInfo.class$("iaik.pkcs.pkcs7.Data")) : d);
        ContentInfo.register(ObjectID.pkcs7_digestedData, e == null ? (e = ContentInfo.class$("iaik.pkcs.pkcs7.DigestedData")) : e);
        ContentInfo.register(ObjectID.pkcs7_signedData, f == null ? (f = ContentInfo.class$("iaik.pkcs.pkcs7.SignedData")) : f);
        ContentInfo.register(ObjectID.pkcs7_envelopedData, g == null ? (g = ContentInfo.class$("iaik.pkcs.pkcs7.EnvelopedData")) : g);
        ContentInfo.register(ObjectID.pkcs7_signedAndEnvelopedData, h == null ? (h = ContentInfo.class$("iaik.pkcs.pkcs7.SignedAndEnvelopedData")) : h);
        ContentInfo.register(ObjectID.pkcs7_encryptedData, i == null ? (i = ContentInfo.class$("iaik.pkcs.pkcs7.EncryptedData")) : i);
    }
}

