/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.DigestedDataStream;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class DigestedData
extends DigestedDataStream
implements Content {
    private ContentInfo g;
    byte[] a;

    protected DigestedData() {
        this.block_size = -1;
    }

    public DigestedData(byte[] byArray, AlgorithmID algorithmID, int n2) throws PKCSException {
        this();
        if (algorithmID == null) {
            throw new PKCSException("No digestAlgorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new PKCSException("Illegal mode specification: " + n2 + "!");
        }
        this.content_type = ObjectID.pkcs7_data;
        this.mode = n2;
        this.a = byArray;
        this.g = n2 == 1 ? new ContentInfo(new Data(byArray)) : new ContentInfo(this.content_type);
        this.c = (AlgorithmID)algorithmID.clone();
        try {
            this.setupMessageDigest(this.c, false);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.getMessage());
        }
    }

    public DigestedData(Content content, AlgorithmID algorithmID, byte[] byArray) throws PKCSException {
        this();
        this.g = new ContentInfo(content);
        this.content_type = this.g.getContentType();
        if (this.content_type.equals(ObjectID.pkcs7_data)) {
            this.a = ((Data)content).getData();
        }
        this.c = algorithmID;
        this.e = byArray;
    }

    public DigestedData(ObjectID objectID, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.mode = 2;
        this.content_type = objectID;
        this.g = new ContentInfo(objectID);
        this.c = algorithmID;
        this.e = byArray;
    }

    public DigestedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    public DigestedData(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public DigestedData(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this.a = byArray;
        this.mode = 2;
        this.content_type = ObjectID.pkcs7_data;
        this.c = algorithmID;
        this.setupMessageDigest(algorithmID, true);
    }

    protected void setupMessageDigest(AlgorithmID algorithmID, boolean bl) throws NoSuchAlgorithmException {
        this.d = algorithmID.getMessageDigestInstance();
        if (this.a == null) {
            throw new NoSuchAlgorithmException("No content to digest!");
        }
        this.d.update(this.a);
        if (bl) {
            this.f = this.d.digest();
        } else {
            this.e = this.d.digest();
        }
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.b = derInputStream.readInteger().intValue();
        this.c = new AlgorithmID(derInputStream);
        this.g = new ContentInfo(derInputStream);
        this.content_type = this.g.getContentType();
        if (!this.g.hasContent()) {
            this.mode = 2;
        } else {
            if (this.content_type.equals(ObjectID.pkcs7_data)) {
                this.a = ((Data)this.g.getContent()).getData();
            }
            try {
                this.setupMessageDigest(this.c, true);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PKCSParsingException(noSuchAlgorithmException.getMessage());
            }
        }
        this.e = derInputStream.readOctetStringByteArray();
    }

    public Object getContentInfo() {
        return this.g;
    }

    public InputStream getInputStream() {
        if (this.a == null) {
            return null;
        }
        return new ByteArrayInputStream(this.a);
    }

    public byte[] getContent() {
        return this.a;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        Content content;
        if (this.c == null) {
            throw new PKCSException("No digest algorithm set!");
        }
        if (this.g == null) {
            throw new PKCSException("No content info set!");
        }
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if ((content = this.g.getContent()) != null) {
            content.setBlockSize(n2);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent(new INTEGER(this.b));
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(this.g.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.e));
        return sEQUENCE;
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.b + "\n");
        if (this.c != null) {
            stringBuffer.append("digestAlgorithm: " + this.c.getName());
        }
        stringBuffer.append("ContentInfo: " + this.g);
        stringBuffer.append("\n");
        stringBuffer.append("digest: " + Util.toString(this.e));
        return stringBuffer.toString();
    }
}

