/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptedContentInfo
extends EncryptedContentInfoStream {
    byte[] a;
    boolean b;
    int c = 0;

    protected EncryptedContentInfo() {
        this.i = -1;
    }

    public EncryptedContentInfo(ObjectID objectID, byte[] byArray) {
        this();
        this.a = byArray;
        this.d = objectID;
        this.h = 1;
    }

    public EncryptedContentInfo(ObjectID objectID, AlgorithmID algorithmID) {
        this();
        this.d = objectID;
        this.e = algorithmID;
        this.b = false;
    }

    public EncryptedContentInfo(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
        this.b = true;
    }

    public EncryptedContentInfo(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        this.b = true;
        if (aSN1Object == null) {
            throw new PKCSParsingException("Cannot decode a null object!");
        }
        try {
            byte[] byArray = DerCoder.encode(aSN1Object);
            if (byArray == null) {
                throw new PKCSParsingException("Error parsing ASN.1 object!");
            }
            this.decode(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    protected void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        this.b = true;
        super.decode(inputStream);
        if (this.f != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Util.copyStream(this.f, byteArrayOutputStream, null);
            this.a = byteArrayOutputStream.toByteArray();
        }
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        super.setupCipher(algorithmID, key, algorithmParameterSpec);
        if (this.g != null && this.a != null) {
            try {
                byte[] byArray = this.c == 1 ? this.g.doFinal(DerCoder.encode(new OCTET_STRING(this.a))) : this.g.doFinal(this.a);
                this.a = byArray;
            }
            catch (BadPaddingException badPaddingException) {
                throw new InvalidAlgorithmParameterException("Padding error at content encryption: " + badPaddingException.getMessage());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new InvalidAlgorithmParameterException("Illegal block size for content encryption: " + illegalBlockSizeException.getMessage());
            }
        }
    }

    public void setupCipher(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        super.setupCipher(key, algorithmParameterSpec);
        if (this.a != null) {
            byte[] byArray = this.a;
            try {
                this.a = this.g.doFinal(byArray);
                if (this.c == 1) {
                    OCTET_STRING oCTET_STRING = (OCTET_STRING)DerCoder.decode(this.a);
                    this.a = (byte[])oCTET_STRING.getValue();
                }
            }
            catch (BadPaddingException badPaddingException) {
                throw new InvalidAlgorithmParameterException("Padding error: " + badPaddingException.toString());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new InvalidAlgorithmParameterException("Illegal blocksize: " + illegalBlockSizeException.toString());
            }
            catch (CodingException codingException) {
                throw new InvalidAlgorithmParameterException("Error decoding PKCS#7v1.6 decrypted content: " + codingException.getMessage());
            }
        }
    }

    public void setVersion(int n2) {
        if (n2 == 1) {
            this.c = 1;
        } else if (n2 != 0) {
            throw new IllegalArgumentException("Invalid version number: " + n2);
        }
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.e == null) {
            throw new PKCSException("contentEncryptionAlgorithm field not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(this.i > 0);
        sEQUENCE.addComponent(this.d);
        sEQUENCE.addComponent(this.e.toASN1Object());
        if (this.a != null && this.a.length > 0) {
            OCTET_STRING oCTET_STRING = null;
            oCTET_STRING = this.i > 0 ? new OCTET_STRING(new ByteArrayInputStream(this.a), this.i) : new OCTET_STRING(this.a);
            CON_SPEC cON_SPEC = new CON_SPEC(0, oCTET_STRING, true);
            sEQUENCE.addComponent(cON_SPEC);
        }
        return sEQUENCE;
    }

    public byte[] getContent() {
        return this.a;
    }

    public InputStream getInputStream() {
        byte[] byArray = this.getContent();
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public boolean hasContent() {
        return this.a != null;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }
}

