/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.SecretKey;

public class EnvelopedData
extends EnvelopedDataStream
implements Content {
    private EncryptedContentInfo c;
    static Class a;

    protected EnvelopedData() {
        this.block_size = -1;
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this();
        this.c = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        this.symmetric_key = this.c.setupCipher(algorithmID);
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        this();
        this.c = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        this.symmetric_key = this.c.setupCipher(algorithmID, n2);
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2, int n3) throws NoSuchAlgorithmException {
        this();
        this.c = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        if (n3 == 1) {
            this.version = 1;
            this.c.c = 1;
        } else if (n3 != 0) {
            throw new IllegalArgumentException("Invalid version number: " + n3);
        }
        this.symmetric_key = this.c.setupCipher(algorithmID, n2);
    }

    public EnvelopedData(RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo) {
        this();
        this.recipient_infos = Util.getVector(recipientInfoArray);
        this.c = encryptedContentInfo;
    }

    public EnvelopedData(RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo, int n2) {
        this();
        this.recipient_infos = Util.getVector(recipientInfoArray);
        this.c = encryptedContentInfo;
        if (n2 == 1) {
            this.version = 1;
            this.c.c = 1;
        } else if (n2 != 0) {
            throw new IllegalArgumentException("Invalid version number: " + n2);
        }
    }

    public EnvelopedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    public EnvelopedData(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.version = derInputStream.readInteger().intValue();
        try {
            this.recipient_infos = Util.getVector(ASN.parseSequenceOf(DerCoder.decode(derInputStream), a == null ? (a = EnvelopedData.class$("iaik.pkcs.pkcs7.RecipientInfo")) : a));
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException("Error parsing recipient infos!");
        }
        this.c = new EncryptedContentInfo();
        this.c.c = this.version;
        this.c.decode(derInputStream);
    }

    public void setupCipher(PrivateKey privateKey, int n2) throws PKCSException, NoSuchAlgorithmException, InvalidKeyException {
        RecipientInfo recipientInfo = (RecipientInfo)this.recipient_infos.elementAt(n2);
        SecretKey secretKey = recipientInfo.decryptKey(privateKey, this.c.getContentEncryptionAlgorithm().getRawImplementationName());
        this.c.setupCipher(secretKey);
    }

    public void setupCipher(Key key) throws PKCSException, NoSuchAlgorithmException, InvalidKeyException {
        this.c.setupCipher(key);
    }

    public InputStream getInputStream() {
        return this.c.getInputStream();
    }

    public byte[] getContent() {
        return this.c.getContent();
    }

    public Object getEncryptedContentInfo() {
        return this.c;
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        Object object;
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (this.recipient_infos == null) {
            throw new PKCSException("No recipients specified.");
        }
        if (this.symmetric_key != null) {
            object = this.recipient_infos.elements();
            while (object.hasMoreElements()) {
                ((RecipientInfo)object.nextElement()).encryptKey(this.symmetric_key);
            }
        }
        this.c.setBlockSize(n2);
        object = new SEQUENCE(n2 > 0);
        try {
            ((ConstructedType)object).addComponent(new INTEGER(this.version));
            if (this.version == 1) {
                ((ConstructedType)object).addComponent(ASN.createSequenceOf(this.recipient_infos));
            } else {
                ((ConstructedType)object).addComponent(ASN.createSetOf(this.recipient_infos));
            }
            ((ConstructedType)object).addComponent(this.c.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return object;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        if (bl) {
            for (int i2 = 0; i2 < this.recipient_infos.size(); ++i2) {
                stringBuffer.append("\nRecipientInfo " + (i2 + 1) + ":{\n");
                stringBuffer.append(((RecipientInfo)this.recipient_infos.elementAt(i2)).toString());
                stringBuffer.append("\n}");
            }
        } else {
            stringBuffer.append("RecipientInfos: " + this.recipient_infos.size() + "\n");
        }
        stringBuffer.append("\nEncryptedContentInfo: {\n");
        stringBuffer.append(this.c.toString() + "}");
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

