/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs8;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.random.SecRandom;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedPrivateKeyInfo
implements ASN1Type,
PrivateKey {
    private static final long serialVersionUID = -6227472653361186792L;
    private static final Vector d = new Vector();
    PrivateKey a;
    AlgorithmID b;
    ASN1 c;

    private static final AlgorithmParameterSpec a(AlgorithmID algorithmID, int n2, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = algorithmID.getAlgorithmParameterSpec();
        if (algorithmParameterSpec != null) {
            int n3;
            if (n2 > 0 && algorithmParameterSpec instanceof PBEParameterSpec && n2 != (n3 = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount())) {
                throw new InvalidAlgorithmParameterException("iterationCount (" + n2 + ") differs" + " from algorithm parameters iteration count (" + n3 + ")!");
            }
        } else {
            if (n2 < 0) {
                n2 = 2000;
            }
            byte[] byArray = new byte[algorithmID.equals(AlgorithmID.pbes2) ? 32 : 8];
            if (secureRandom == null) {
                secureRandom = SecRandom.getDefault();
            }
            secureRandom.nextBytes(byArray);
            algorithmParameterSpec = new PBEParameterSpec(byArray, n2);
        }
        return algorithmParameterSpec;
    }

    private static final Key a(char[] cArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = algorithmID.getSecretKeyFactoryInstance("IAIK");
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        return secretKey;
    }

    public EncryptedPrivateKeyInfo(PrivateKey privateKey) {
        this.a = privateKey;
    }

    public EncryptedPrivateKeyInfo(ASN1Object aSN1Object) throws InvalidKeyException {
        try {
            this.c = new ASN1(aSN1Object);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public EncryptedPrivateKeyInfo(InputStream inputStream) throws InvalidKeyException, IOException {
        try {
            this.c = new ASN1(inputStream);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public EncryptedPrivateKeyInfo(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.c = new ASN1(aSN1Object);
        try {
            this.a();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException(invalidKeyException.toString());
        }
    }

    private void a() throws InvalidKeyException {
        try {
            this.b = new AlgorithmID(this.c.getComponentAt(0));
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException(codingException.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.c == null) {
            throw new IOException("Private key not encrypted yet.");
        }
        objectOutputStream.write(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.c = new ASN1(objectInputStream);
            this.a();
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + invalidKeyException.toString());
        }
    }

    public void encrypt(char[] cArray, String string) throws NoSuchAlgorithmException {
        this.encrypt(cArray, string, SecRandom.getDefault());
    }

    public void encrypt(char[] cArray, String string, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        AlgorithmID algorithmID = AlgorithmID.getAlgorithmID(string);
        if (algorithmID == null && d.contains(string)) {
            algorithmID = AlgorithmID.pbes2;
        }
        if (algorithmID == null) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " not supported!");
        }
        this.a(cArray, algorithmID, string, secureRandom, null);
    }

    public void encrypt(String string, AlgorithmID algorithmID, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        this.encrypt(string.toCharArray(), algorithmID, secureRandom);
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        try {
            algorithmParameterSpec = EncryptedPrivateKeyInfo.a(algorithmID, -1, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("Invalid algorithm parameters: " + invalidAlgorithmParameterException.toString());
        }
        this.a(cArray, algorithmID, algorithmID.getImplementationName(), secureRandom, algorithmParameterSpec);
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, SecureRandom secureRandom, int n2) throws NoSuchAlgorithmException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("iterationCount must not be negative!");
        }
        AlgorithmParameterSpec algorithmParameterSpec = null;
        try {
            algorithmParameterSpec = EncryptedPrivateKeyInfo.a(algorithmID, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("Invalid algorithm parameters: " + invalidAlgorithmParameterException.toString());
        }
        this.a(cArray, algorithmID, algorithmID.getImplementationName(), secureRandom, algorithmParameterSpec);
    }

    private void a(char[] cArray, AlgorithmID algorithmID, String string, SecureRandom secureRandom, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException {
        if (this.a != null) {
            this.b = (AlgorithmID)algorithmID.clone();
            try {
                Cipher cipher = Cipher.getInstance(string);
                cipher.init(1, EncryptedPrivateKeyInfo.a(cArray, this.b), algorithmParameterSpec, secureRandom);
                byte[] byArray = cipher.doFinal(this.a.getEncoded());
                this.b.setAlgorithmParameters(cipher.getParameters());
                SEQUENCE sEQUENCE = null;
                sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent(this.b.toASN1Object());
                sEQUENCE.addComponent(new OCTET_STRING(byArray));
                this.c = new ASN1(sEQUENCE);
            }
            catch (Exception exception) {
                throw new InternalErrorException(exception);
            }
            this.a = null;
        } else if (this.c == null) {
            throw new NullPointerException("Nothing to encrypt. Private key not set!");
        }
    }

    public PrivateKey decrypt(String string) throws NoSuchAlgorithmException, GeneralSecurityException {
        return this.decrypt(string.toCharArray());
    }

    public PrivateKey decrypt(char[] cArray) throws NoSuchAlgorithmException, GeneralSecurityException {
        AlgorithmParameterSpec algorithmParameterSpec = this.b.getAlgorithmParameterSpec();
        Cipher cipher = this.b.getCipherInstance();
        try {
            cipher.init(2, EncryptedPrivateKeyInfo.a(cArray, this.b), algorithmParameterSpec);
            byte[] byArray = (byte[])this.c.getComponentAt(1).getValue();
            byte[] byArray2 = cipher.doFinal(byArray);
            this.a = PrivateKeyInfo.getPrivateKey(byArray2);
            return this.a;
        }
        catch (Exception exception) {
            throw new GeneralSecurityException(this, "Error decrypting private key: " + exception.toString(), exception){
                private static final long serialVersionUID = -712183313106196366L;
                private final Exception a;
                private final EncryptedPrivateKeyInfo b;
                {
                    this.b = encryptedPrivateKeyInfo;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    public PrivateKey getPrivateKeyInfo() {
        return this.a;
    }

    public ASN1Object toASN1Object() {
        return this.c.toASN1Object();
    }

    public byte[] getEncoded() {
        return this.c.toByteArray();
    }

    public String getAlgorithm() {
        return "ENCRYPTED";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.c.writeTo(outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("Private key is encrypted with algorithm: " + this.b.getName());
        } else {
            stringBuffer.append(this.a.getAlgorithm() + " private key is not encrypted yet.");
        }
        return stringBuffer.toString();
    }

    static {
        d.add("PBES2");
        d.add("1.2.840.113549.1.5.13");
        d.add("PBES2WithHmacSHA1AndAES");
        d.add("PBES2WithHmacSHA1AndAES128");
        d.add("PBEWithHmacSHA1AndAES");
        d.add("PBEWithHmacSHA1AndAES128");
        d.add("PBES2WithHmacSHA256AndAES");
        d.add("PBES2WithHmacSHA256AndAES128");
        d.add("PBEWithHmacSHA256AndAES");
        d.add("PBEWithHmacSHA256AndAES128");
        d.add("PBES2WithHmacSHA384AndAES192");
        d.add("PBEWithHmacSHA384AndAES192");
        d.add("PBES2WithHmacSHA512AndAES256");
        d.add("PBEWithHmacSHA512AndAES256");
        d.add("PBES2WithHmacSHA1AndDESede");
        d.add("PBEWithHmacSHA1AndDESede");
        d.add("PBES2WithHmacSHA1AndTripleDES");
        d.add("PBEWithHmacSHA1AndTripleDES");
    }
}

