/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.CAST128ParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class CAST128Parameters
extends AlgorithmParametersSpi {
    int a;
    byte[] b;

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b != null && !this.a(this.b)) {
            sEQUENCE.addComponent(new OCTET_STRING(this.b));
        }
        sEQUENCE.addComponent(new INTEGER(this.a));
        return DerCoder.encode(sEQUENCE);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        CAST128ParameterSpec cAST128ParameterSpec = new CAST128ParameterSpec(this.a, this.b);
        if (!cAST128ParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return cAST128ParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof CAST128ParameterSpec) {
            CAST128ParameterSpec cAST128ParameterSpec = (CAST128ParameterSpec)algorithmParameterSpec;
            this.a = cAST128ParameterSpec.getKeyLength();
            this.b = cAST128ParameterSpec.getIV();
            if (this.b != null && this.b.length != 8) {
                throw new InvalidParameterSpecException("IV must be 8 octets long!");
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.b = ivParameterSpec.getIV();
            this.a = -1;
            if (this.b != null && this.b.length != 8) {
                throw new InvalidParameterSpecException("IV must be 8 octets long!");
            }
        } else {
            throw new InvalidParameterSpecException("Parameter must be a CAST128ParameterSpec.");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block8: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    ASN1Object aSN1Object2;
                    int n2 = 0;
                    int n3 = aSN1Object.countComponents();
                    if (n3 < 1 || n3 > 2) {
                        throw new IOException("Invalid number of components (" + n3 + ". Only 1 or 2 allowed!");
                    }
                    if (aSN1Object.countComponents() == 2) {
                        if (!(aSN1Object2 = aSN1Object.getComponentAt(n2++)).isA(ASN.OCTET_STRING)) {
                            throw new IOException("Invalid iv component type! Expected ASN.1 OCTET_STRING.");
                        }
                        this.b = (byte[])aSN1Object2.getValue();
                    }
                    if (!(aSN1Object2 = aSN1Object.getComponentAt(n2)).isA(ASN.INTEGER)) {
                        throw new IOException("Invalid keyLength component type! Expected ASN.1 INTEGER.");
                    }
                    this.a = ((BigInteger)aSN1Object.getComponentAt(n2).getValue()).intValue();
                    break block8;
                }
                if (aSN1Object.isA(ASN.OCTET_STRING)) {
                    this.a = -1;
                    this.b = (byte[])aSN1Object.getValue();
                    break block8;
                }
                throw new IOException("Cannot decode CAST params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("keyLength: " + this.a + "\n");
        stringBuffer.append("IV: ");
        if (this.b == null) {
            stringBuffer.append("00:00:00:00:00:00:00:00\n");
        } else {
            stringBuffer.append("IV: " + Util.toString(this.b) + "\n");
        }
        return stringBuffer.toString();
    }

    private boolean a(byte[] byArray) {
        if (byArray != null) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == 0) continue;
                return false;
            }
        }
        return true;
    }
}

