/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.security.cipher.RC2Parameters;
import iaik.security.cipher.RC2WrapParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RC2WrapParameters
extends RC2Parameters {
    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(new INTEGER(this.d));
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        int n2 = RC2WrapParameters.b(this.d);
        RC2WrapParameterSpec rC2WrapParameterSpec = new RC2WrapParameterSpec(n2);
        if (!rC2WrapParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return rC2WrapParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof RC2WrapParameterSpec)) {
            throw new InvalidParameterSpecException("Parameter must be RC2WrapParameterspec.");
        }
        RC2WrapParameterSpec rC2WrapParameterSpec = (RC2WrapParameterSpec)algorithmParameterSpec;
        this.d = RC2WrapParameters.a(rC2WrapParameterSpec.getEffectiveKeyBits());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            this.d = ((BigInteger)aSN1Object.getValue()).intValue();
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rc2ParameterVersion: " + this.d + "\n");
        return stringBuffer.toString();
    }
}

