/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import java.security.spec.AlgorithmParameterSpec;

public class SHA2withDSAGenParameterSpec
implements AlgorithmParameterSpec {
    private int a;
    private int b;
    private int c;

    public SHA2withDSAGenParameterSpec(int n2, int n3) throws IllegalArgumentException {
        switch (n2) {
            case 1024: {
                if (n3 == 160) break;
                throw new IllegalArgumentException("Invalid (L,N) pair: (" + n2 + "/" + n3 + ")");
            }
            case 2048: {
                if (n3 == 224 || n3 == 256) break;
                throw new IllegalArgumentException("Invalid (L,N) pair: (" + n2 + "/" + n3 + ")");
            }
            case 3072: {
                if (n3 == 256) break;
                throw new IllegalArgumentException("Invalid (L,N) pair: (" + n2 + "/" + n3 + ")");
            }
            default: {
                throw new IllegalArgumentException("Invalid (L,N) pair: (" + n2 + "/" + n3 + ")");
            }
        }
        this.a = n2;
        this.b = n3;
        this.c = -1;
    }

    public void setSeedlen(int n2) {
        if (n2 < this.b) {
            throw new IllegalArgumentException("Seedlen (" + n2 + ") must not be shorter than N (" + this.b + ")");
        }
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("Seedlen (" + n2 + ") must be multiple of 8!");
        }
        this.c = n2;
    }

    public int getL() {
        return this.a;
    }

    public int getN() {
        return this.b;
    }

    public int getSeedlen() {
        return this.c;
    }
}

