/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.elgamal;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.elgamal.ElGamalParameterSpec;
import iaik.security.elgamal.ElGamalPrivateKeySpec;
import iaik.security.elgamal.a;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public class ElGamalPrivateKey
extends PrivateKeyInfo
implements a {
    private static final long serialVersionUID = -7361449127322895958L;
    private transient ASN1 c;
    private BigInteger d;
    private transient ElGamalParameterSpec e;

    public ElGamalPrivateKey(BigInteger bigInteger, ElGamalParameterSpec elGamalParameterSpec) {
        this.d = bigInteger;
        this.e = elGamalParameterSpec;
        this.a();
    }

    public ElGamalPrivateKey(ElGamalPrivateKeySpec elGamalPrivateKeySpec) {
        this.d = elGamalPrivateKeySpec.getX();
        this.e = new ElGamalParameterSpec(elGamalPrivateKeySpec.getP(), elGamalPrivateKeySpec.getG());
        this.a();
    }

    public ElGamalPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public ElGamalPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public ElGamalPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.d = (BigInteger)this.c.toASN1Object().getValue();
            ASN1Object aSN1Object = this.private_key_algorithm.getParameter();
            BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            if (aSN1Object.countComponents() > 2) {
                int n2 = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue();
                this.e = new ElGamalParameterSpec(bigInteger, bigInteger2, n2);
            } else {
                this.e = new ElGamalParameterSpec(bigInteger, bigInteger2);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No ElGamal Private Key: " + exception.toString());
        }
    }

    private void a() {
        try {
            this.c = new ASN1(new INTEGER(this.d));
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.e.getP()));
            sEQUENCE.addComponent(new INTEGER(this.e.getG()));
            if (this.e.getL() > 0) {
                sEQUENCE.addComponent(new INTEGER(this.e.getL()));
            }
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.elGamal.clone();
            this.private_key_algorithm.setParameter(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPrivateKeyInfo();
    }

    public byte[] encode() {
        return this.c.toByteArray();
    }

    public BigInteger getX() {
        return this.d;
    }

    public ElGamalParameterSpec getParams() {
        return this.e;
    }

    public String getAlgorithm() {
        return "ElGamal";
    }

    public int hashCode() {
        return this.d.hashCode() ^ this.e.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ElGamal private key");
        stringBuffer.append(this.e == null ? ":\n" : " (" + this.e.getP().bitLength() + " bits):\n");
        stringBuffer.append("x: " + this.d.toString(16) + "\n");
        if (this.e != null) {
            stringBuffer.append("key parameters:\n" + this.e.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

