/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.ArrayEnumeration;
import iaik.utils.Util;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.ReasonCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class X509CRL
extends java.security.cert.X509CRL
implements ASN1Type {
    private ASN1 a;
    private int b = 1;
    private AlgorithmID c;
    private Name d;
    private ChoiceOfTime e;
    private ChoiceOfTime f;
    private byte[] g;
    private HashMap h;
    private X509Extensions i;
    private boolean j;
    private boolean k;
    private byte[] l;
    private int m = 2;
    private int n = 4;

    public X509CRL() {
        this.a();
        this.a = new ASN1();
        this.h = new HashMap(10);
    }

    public X509CRL(InputStream inputStream) throws IOException, CRLException {
        this();
        try {
            this.a = new ASN1(inputStream);
        }
        catch (CodingException codingException) {
            throw new CRLException(this, codingException.toString(), codingException){
                private static final long serialVersionUID = -534597188972819099L;
                private final CodingException a;
                private final X509CRL b;
                {
                    this.b = x509CRL;
                    this.a = codingException;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
        this.d();
    }

    public X509CRL(byte[] byArray) throws CRLException {
        this();
        try {
            this.a = new ASN1(byArray);
        }
        catch (CodingException codingException) {
            throw new CRLException(this, codingException.toString(), codingException){
                private static final long serialVersionUID = -8036880454220918343L;
                private final CodingException a;
                private final X509CRL b;
                {
                    this.b = x509CRL;
                    this.a = codingException;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
        this.d();
    }

    public X509CRL(ASN1Object aSN1Object) throws CRLException {
        this();
        try {
            this.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new CRLException(this, codingException.toString(), codingException){
                private static final long serialVersionUID = -474340416029275471L;
                private final CodingException a;
                private final X509CRL b;
                {
                    this.b = x509CRL;
                    this.a = codingException;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    private void a() {
        this.k = true;
        this.l = null;
        this.a = null;
    }

    private void b() {
        if (this.k) {
            throw new RuntimeException("Cannot perform operation, CRL has to be signed first");
        }
    }

    private void c() {
        this.k = false;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = new ASN1(aSN1Object);
        try {
            this.d();
        }
        catch (CRLException cRLException) {
            throw new CodingException(cRLException.toString());
        }
    }

    private void d() throws CRLException {
        int n2 = 0;
        try {
            ASN1Object aSN1Object = this.a.getComponentAt(0);
            AlgorithmID algorithmID = new AlgorithmID(this.a.getComponentAt(1));
            ASN1Object aSN1Object2 = this.a.getComponentAt(2);
            this.g = (byte[])((BIT_STRING)aSN1Object2).getValue();
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(n2);
            if (aSN1Object3.isA(ASN.INTEGER)) {
                BigInteger bigInteger = (BigInteger)aSN1Object3.getValue();
                this.b = bigInteger.intValue() + 1;
            }
            int n3 = ++n2;
            ++n2;
            this.c = new AlgorithmID(aSN1Object.getComponentAt(n3));
            if (!algorithmID.equals(this.c)) {
                throw new CRLException("CRL signature algorithm mismatch");
            }
            this.d = new Name(aSN1Object.getComponentAt(n2++));
            this.e = new ChoiceOfTime(aSN1Object.getComponentAt(n2++));
            while (n2 < aSN1Object.countComponents()) {
                if ((aSN1Object3 = aSN1Object.getComponentAt(n2++)).isA(ASN.SEQUENCE)) {
                    this.a(aSN1Object3);
                    continue;
                }
                if (aSN1Object3.isA(ASN.CON_SPEC)) {
                    if (aSN1Object3.getAsnType().getTag() == 0) {
                        this.i = new X509Extensions(this.m, this.n);
                        this.i.decode((ASN1Object)aSN1Object3.getValue());
                        continue;
                    }
                    throw new CRLException("Unknown CRL format.");
                }
                if (aSN1Object3.isA(ASN.UTCTime) || aSN1Object3.isA(ASN.GeneralizedTime)) {
                    this.f = new ChoiceOfTime(aSN1Object3);
                    continue;
                }
                throw new CRLException("Unknown CRL format.");
            }
            this.a.clearASN1Object();
            this.c();
        }
        catch (RuntimeException runtimeException) {
            throw new CRLException("CRL format error: " + runtimeException.toString());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException("CRL format error: " + x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new CRLException("CRL format error: " + codingException.toString());
        }
    }

    private void a(ASN1Object aSN1Object) throws CodingException, CRLException {
        int n2 = aSN1Object.countComponents();
        HashMap hashMap = new HashMap();
        this.h.put(this.d, hashMap);
        for (int i2 = 0; i2 < n2; ++i2) {
            RevokedCertificate revokedCertificate = new RevokedCertificate(aSN1Object.getComponentAt(i2));
            this.j |= revokedCertificate.hasUnsupportedCriticalExtension();
            Name name = X509CRL.a(revokedCertificate);
            if (name != null) {
                hashMap = this.a(name, true);
            }
            hashMap.put(revokedCertificate.getSerialNumber(), revokedCertificate);
        }
    }

    private static Name a(RevokedCertificate revokedCertificate) throws CRLException {
        try {
            CertificateIssuer certificateIssuer = (CertificateIssuer)revokedCertificate.getExtension(CertificateIssuer.oid);
            if (certificateIssuer == null) {
                return null;
            }
            GeneralNames generalNames = certificateIssuer.getIssuer();
            Enumeration enumeration = generalNames.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 4) continue;
                Name name = (Name)generalName.getName();
                return name;
            }
            throw new CRLException("Only certificate issuer extensions contains a directory name supported");
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            throw new CRLException(x509ExtensionInitException.toString());
        }
    }

    public boolean isIndirectCRL() {
        Iterator iterator = this.h.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap;
            Name name = (Name)iterator.next();
            if (name.equals(this.d) || (hashMap = (HashMap)this.h.get(name)).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private ASN1Object e() throws CRLException, X509ExtensionException {
        Iterator iterator;
        SEQUENCE sEQUENCE = new SEQUENCE();
        HashMap hashMap = this.a(this.d, false);
        if (hashMap != null) {
            iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                sEQUENCE.addComponent(((RevokedCertificate)iterator.next()).toASN1Object());
            }
        }
        Iterator iterator2 = this.h.keySet().iterator();
        while (iterator2.hasNext()) {
            HashMap hashMap2;
            Name name = (Name)iterator2.next();
            if (name.equals(this.d) || (hashMap2 = this.a(name, false)) == null) continue;
            boolean bl = true;
            iterator = hashMap2.values().iterator();
            while (iterator.hasNext()) {
                RevokedCertificate revokedCertificate = (RevokedCertificate)iterator.next();
                if (bl) {
                    bl = false;
                    if (!revokedCertificate.a(CertificateIssuer.oid)) {
                        GeneralNames generalNames = new GeneralNames(new GeneralName(4, name));
                        CertificateIssuer certificateIssuer = new CertificateIssuer(generalNames);
                        certificateIssuer.setCritical(true);
                        revokedCertificate.addExtension(certificateIssuer);
                    }
                } else {
                    revokedCertificate.removeExtension(CertificateIssuer.oid);
                }
                sEQUENCE.addComponent(revokedCertificate.toASN1Object());
            }
        }
        return sEQUENCE;
    }

    private ASN1Object f() throws CRLException {
        this.b = 1;
        SEQUENCE sEQUENCE = null;
        if (this.c == null) {
            throw new CRLException("Signature algorithm not set!");
        }
        if (this.d == null) {
            throw new CRLException("Issuer not set!");
        }
        if (this.e == null) {
            throw new CRLException("ThisUpdate not set!");
        }
        if (this.i != null) {
            this.b = 2;
        }
        try {
            sEQUENCE = new SEQUENCE();
            if (this.b > 1) {
                sEQUENCE.addComponent(new INTEGER(this.b - 1));
            }
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(this.e.toASN1Object());
            if (this.f != null) {
                sEQUENCE.addComponent(this.f.toASN1Object());
            }
            if (this.h.size() > 0) {
                sEQUENCE.addComponent(this.e());
            }
            if (this.i != null && this.i.countExtensions() > 0) {
                CON_SPEC cON_SPEC = new CON_SPEC(0, this.i.toASN1Object());
                sEQUENCE.addComponent(cON_SPEC);
            }
            return sEQUENCE;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CRLException(x509ExtensionException.toString());
        }
    }

    public void sign(PrivateKey privateKey) throws CRLException, InvalidKeyException, NoSuchAlgorithmException {
        this.sign(privateKey, null);
    }

    public void sign(PrivateKey privateKey, String string) throws CRLException, InvalidKeyException, NoSuchAlgorithmException {
        Object object;
        if (this.c == null) {
            throw new CRLException("Signature algorithm not set!");
        }
        BIT_STRING bIT_STRING = null;
        Signature signature = this.c.getSignatureInstance(string);
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.c) && !this.c.hasParameters() && (object = Util.getSignatureParameters(signature)) != null) {
                this.c.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.f();
        try {
            signature.update(DerCoder.encode((ASN1Object)object));
            this.g = signature.sign();
            bIT_STRING = new BIT_STRING(this.g);
        }
        catch (SignatureException signatureException) {
            throw new CRLException(signatureException.toString());
        }
        this.a();
        try {
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.a = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        this.c();
    }

    public void setSignature(byte[] byArray) throws CRLException {
        if (byArray == null) {
            throw new CRLException("Cannot sign crl. No signature value specified!");
        }
        this.g = byArray;
        ASN1Object aSN1Object = this.f();
        BIT_STRING bIT_STRING = new BIT_STRING(this.g);
        this.a();
        try {
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.a = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
        this.c();
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.b();
        if (this.c == null) {
            throw new NoSuchAlgorithmException("Cannot verify crl! No signature algorithm set.");
        }
        Signature signature = this.c.getSignatureInstance(string);
        try {
            byte[] byArray = this.a.getFirstObject();
            signature.initVerify(publicKey);
            signature.update(byArray);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        if (!signature.verify(this.g)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, (String)null);
    }

    private boolean b(RevokedCertificate revokedCertificate) {
        if (revokedCertificate == null) {
            return false;
        }
        try {
            ReasonCode reasonCode = (ReasonCode)revokedCertificate.getExtension(ReasonCode.oid);
            if (reasonCode != null && reasonCode.getReasonCode() == 8) {
                return false;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            // empty catch block
        }
        return true;
    }

    public boolean isRevoked(BigInteger bigInteger) {
        return this.b(this.containsCertificate(bigInteger));
    }

    public boolean isRevoked(Certificate certificate) {
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = Util.convertCertificate(certificate);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid certificate format: " + exception.toString());
        }
        return this.b(this.containsCertificate(x509Certificate));
    }

    public RevokedCertificate containsCertificate(X509Certificate x509Certificate) {
        return this.containsCertificate(x509Certificate.getIssuerDN(), x509Certificate.getSerialNumber());
    }

    public RevokedCertificate containsCertificate(Principal principal, BigInteger bigInteger) {
        HashMap hashMap = this.a(principal, false);
        if (hashMap == null) {
            return null;
        }
        return (RevokedCertificate)hashMap.get(bigInteger);
    }

    public RevokedCertificate containsCertificate(BigInteger bigInteger) {
        HashMap hashMap = this.a(this.d, false);
        if (hashMap == null) {
            return null;
        }
        return (RevokedCertificate)hashMap.get(bigInteger);
    }

    public ASN1Object toASN1Object() {
        this.b();
        return this.a.toASN1Object();
    }

    public byte[] toByteArray() {
        this.b();
        return this.a.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b();
        this.a.writeTo(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificate(X509Certificate x509Certificate, Date date) {
        HashMap hashMap = this.h;
        synchronized (hashMap) {
            HashMap hashMap2 = this.a(x509Certificate.getIssuerDN(), true);
            hashMap2.put(x509Certificate.getSerialNumber(), new RevokedCertificate(x509Certificate, date));
        }
        this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificate(RevokedCertificate revokedCertificate) {
        try {
            HashMap hashMap = this.h;
            synchronized (hashMap) {
                Name name = X509CRL.a(revokedCertificate);
                if (name == null && (name = this.d) == null) {
                    throw new NullPointerException("CRL issuer must be set before adding a revoked certificate");
                }
                HashMap hashMap2 = this.a(name, true);
                hashMap2.put(revokedCertificate.getSerialNumber(), revokedCertificate.clone());
            }
            this.a();
        }
        catch (CRLException cRLException) {
            throw new IllegalArgumentException(cRLException.toString());
        }
    }

    private HashMap a(Principal principal, boolean bl) {
        HashMap hashMap = (HashMap)this.h.get(principal);
        if (hashMap == null && bl) {
            hashMap = new HashMap();
            this.h.put(principal, hashMap);
        }
        return hashMap;
    }

    public Enumeration listCertificates() {
        Iterator iterator;
        Vector<Object> vector = new Vector<Object>(100);
        HashMap hashMap = this.a(this.d, false);
        if (hashMap != null) {
            iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
        }
        Vector<Object> vector2 = new Vector<Object>(20);
        Iterator iterator2 = this.h.keySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            HashMap hashMap2;
            Name name = (Name)iterator2.next();
            if (name.equals(this.d) || (hashMap2 = this.a(name, false)) == null) continue;
            boolean bl = true;
            vector2.removeAllElements();
            iterator = hashMap2.values().iterator();
            while (iterator.hasNext()) {
                object = (RevokedCertificate)iterator.next();
                try {
                    if (((RevokedCertificate)object).getExtension(CertificateIssuer.oid) == null && bl) {
                        vector2.addElement(object);
                        continue;
                    }
                    vector.addElement(object);
                    bl = false;
                }
                catch (X509ExtensionInitException x509ExtensionInitException) {
                    vector2.addElement(object);
                }
            }
            object = vector2.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
        }
        return vector.elements();
    }

    public boolean removeCertificate(X509Certificate x509Certificate) {
        return this.removeCertificate(x509Certificate.getIssuerDN(), x509Certificate.getSerialNumber());
    }

    public boolean removeCertificate(BigInteger bigInteger) {
        return this.removeCertificate(this.d, bigInteger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCertificate(Principal principal, BigInteger bigInteger) {
        boolean bl = false;
        HashMap hashMap = this.h;
        synchronized (hashMap) {
            HashMap hashMap2 = this.a(principal, false);
            if (hashMap2 != null && hashMap2.remove(bigInteger) != null) {
                if (hashMap2.isEmpty()) {
                    this.h.remove(principal);
                }
                this.a();
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCertificates() {
        HashMap hashMap = this.h;
        synchronized (hashMap) {
            this.h.clear();
        }
        this.a();
    }

    public int size() {
        int n2 = 0;
        Iterator iterator = this.h.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap = (HashMap)iterator.next();
            if (hashMap == null) continue;
            n2 += hashMap.size();
        }
        return n2;
    }

    public void setSignatureAlgorithm(AlgorithmID algorithmID) {
        if (algorithmID == null) {
            throw new NullPointerException("Cannot set null signature algorithm for this CRL!");
        }
        this.c = algorithmID;
    }

    public void setSignatureAlgorithm(ObjectID objectID) {
        this.setSignatureAlgorithm(new AlgorithmID(objectID));
    }

    public void setIssuerDN(Principal principal) throws IllegalArgumentException {
        try {
            this.d = (Name)principal;
            this.a();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Issuer is not an instance of name.");
        }
    }

    public void setThisUpdate(Date date) {
        this.e = new ChoiceOfTime(date, true, false);
        this.a();
    }

    public void setNextUpdate(Date date) {
        this.f = new ChoiceOfTime(date, true, false);
        this.a();
    }

    public byte[] getEncoded() throws CRLException {
        this.b();
        return this.toByteArray();
    }

    public int getVersion() {
        return this.b;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.c;
    }

    public Principal getIssuerDN() {
        return this.d;
    }

    public Enumeration getIssuerDNs() {
        Set set = this.h.keySet();
        Object[] objectArray = set.toArray();
        if (!set.contains(this.d)) {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = this.d;
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
            objectArray = objectArray2;
        }
        return new ArrayEnumeration(objectArray);
    }

    public Date getThisUpdate() {
        return this.e.getDate();
    }

    public Date getNextUpdate() {
        if (this.f == null) {
            return null;
        }
        return this.f.getDate();
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        return this.containsCertificate(bigInteger);
    }

    public Set getRevokedCertificates() {
        HashSet<RevokedCertificate> hashSet = new HashSet<RevokedCertificate>();
        CertificateIssuer certificateIssuer = null;
        Enumeration enumeration = this.listCertificates();
        while (enumeration.hasMoreElements()) {
            RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
            CertificateIssuer certificateIssuer2 = null;
            try {
                certificateIssuer2 = (CertificateIssuer)revokedCertificate.getExtension(CertificateIssuer.oid);
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                throw new RuntimeException("Error processing certificate issuer extension: " + x509ExtensionInitException.toString());
            }
            if (certificateIssuer2 != null) {
                certificateIssuer = certificateIssuer2;
            } else if (certificateIssuer != null) {
                revokedCertificate = (RevokedCertificate)revokedCertificate.clone();
                try {
                    revokedCertificate.addExtension(certificateIssuer);
                }
                catch (X509ExtensionException x509ExtensionException) {
                    throw new RuntimeException("Error processing certificate issuer extension: " + x509ExtensionException.toString());
                }
            }
            hashSet.add(revokedCertificate);
        }
        return hashSet;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            if (this.a != null && this.a.toByteArray() != null) {
                return this.a.getFirstObject();
            }
            return DerCoder.encode(this.f());
        }
        catch (CodingException codingException) {
            throw new CRLException(codingException.toString());
        }
    }

    public byte[] getSignature() {
        return this.g;
    }

    public String getSigAlgName() {
        String string = null;
        try {
            string = this.c == null ? null : this.c.getImplementationName();
        }
        catch (Exception exception) {
            string = this.c == null ? null : this.c.getName();
        }
        return string;
    }

    public String getSigAlgOID() {
        return this.c.getAlgorithm().getID();
    }

    public byte[] getSigAlgParams() {
        try {
            ASN1Object aSN1Object = this.c.getParameter();
            if (aSN1Object == null) {
                return null;
            }
            return new ASN1(aSN1Object).toByteArray();
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public Set getCriticalExtensionOIDs() {
        return this.i == null ? null : this.i.getCriticalExtensionOIDs();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.i == null ? null : this.i.getNonCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return this.i == null ? null : this.i.getExtensionValue(string);
    }

    public byte[] getRawExtensionValue(String string) {
        return this.i == null ? null : this.i.getRawExtensionValue(string);
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.i == null) {
            this.i = new X509Extensions(this.m, this.n);
        }
        this.i.addExtension(v3Extension);
        this.a();
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.i == null ? false : this.i.removeExtension(objectID);
        if (bl) {
            this.a();
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.i != null) {
            this.i.removeAllExtensions();
            this.a();
        }
    }

    public Enumeration listExtensions() {
        return this.i == null ? null : this.i.listExtensions();
    }

    public boolean hasExtensions() {
        return this.i == null ? false : this.i.hasExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.j) {
            return true;
        }
        return this.i == null ? false : this.i.hasUnsupportedCriticalExtension();
    }

    public int countExtensions() {
        return this.i == null ? 0 : this.i.countExtensions();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.i == null ? null : this.i.getExtension(objectID);
    }

    public byte[] getFingerprint() {
        this.b();
        return this.a.fingerprint();
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.b();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(this.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprintSHA() {
        if (this.l == null) {
            try {
                this.l = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.l;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        try {
            this.b();
        }
        catch (Exception exception) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509 version " + this.b + " CRL\n");
        stringBuffer.append("Signature Algorithm: " + this.c.getName() + "\n");
        stringBuffer.append("Issuer: " + this.d.toString() + "\n");
        stringBuffer.append("this update: " + this.e.toString() + "\n");
        if (this.f != null) {
            stringBuffer.append("next update: " + this.f.toString() + "\n");
        }
        if (this.i != null) {
            if (bl) {
                stringBuffer.append(this.i);
            } else {
                stringBuffer.append("Extensions: " + this.i.countExtensions() + "\n");
            }
        }
        if (bl) {
            int n2 = 1;
            Enumeration enumeration = this.listCertificates();
            while (enumeration.hasMoreElements()) {
                RevokedCertificate revokedCertificate = (RevokedCertificate)enumeration.nextElement();
                stringBuffer.append(n2 + ": " + revokedCertificate.toString(bl) + "\n");
                ++n2;
            }
        } else {
            Iterator iterator = this.h.keySet().iterator();
            while (iterator.hasNext()) {
                Name name = (Name)iterator.next();
                HashMap hashMap = (HashMap)this.h.get(name);
                stringBuffer.append(name.toString() + ": " + hashMap.size() + " revoked certificates\n");
            }
        }
        return stringBuffer.toString();
    }

    static {
        Util.toString(null, -1, 1);
    }
}

