/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.x509.attr.TargetCert;
import iaik.x509.attr.TargetChecker;
import iaik.x509.attr.TargetException;
import iaik.x509.attr.TargetGroup;
import iaik.x509.attr.TargetName;
import iaik.x509.attr.a;

public abstract class Target
implements ASN1Type {
    public static final int TARGET_NAME = 0;
    public static final int TARGET_GROUP = 1;
    public static final int TARGET_CERT = 2;
    private static volatile TargetChecker a;

    static TargetChecker a() {
        TargetChecker targetChecker = a;
        if (targetChecker == null) {
            a = targetChecker = new a();
        }
        return targetChecker;
    }

    public static synchronized void setTargetChecker(TargetChecker targetChecker) {
        a = targetChecker;
    }

    public static Target parseTarget(ASN1Object aSN1Object) throws CodingException {
        Target target = null;
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse Target from null ASN.1 object!");
        }
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType() + "). Expected CON_SPEC!");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        int n2 = cON_SPEC.getAsnType().getTag();
        switch (n2) {
            case 0: {
                target = new TargetName();
                target.decodeUnTaggedASN1Object((ASN1Object)cON_SPEC.getValue());
                break;
            }
            case 1: {
                target = new TargetGroup();
                target.decodeUnTaggedASN1Object((ASN1Object)cON_SPEC.getValue());
                break;
            }
            case 2: {
                target = new TargetCert();
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                target.decodeUnTaggedASN1Object((ASN1Object)cON_SPEC.getValue());
                break;
            }
            default: {
                throw new CodingException("Invalid Target type: " + n2);
            }
        }
        return target;
    }

    protected Target() {
    }

    protected Target(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public abstract int getType();

    protected abstract String getTypeAsString();

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.getType();
    }

    public boolean isTargetFor(Object object) throws TargetException {
        return Target.a().isTargetFor(this, object);
    }

    public abstract void decodeUnTaggedASN1Object(ASN1Object var1) throws CodingException;

    public abstract ASN1Object toUnTaggedASN1Object() throws CodingException;

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getTag() + "). Expected CON_SPEC.");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        int n2 = cON_SPEC.getAsnType().getTag();
        if (n2 != this.getType()) {
            throw new CodingException("Invalid Target type (" + n2 + "). Expected " + this.getTypeAsString() + " (" + this.getType() + ").");
        }
        if (n2 == 2) {
            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
        }
        this.decodeUnTaggedASN1Object((ASN1Object)cON_SPEC.getValue());
    }

    public ASN1Object toASN1Object() throws CodingException {
        ASN1Object aSN1Object = this.toUnTaggedASN1Object();
        int n2 = this.getType();
        boolean bl = n2 == 2;
        return new CON_SPEC(n2, aSN1Object, bl);
    }

    public String toString() {
        return this.getTypeAsString();
    }
}

