/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.x509.extensions.qualified.structures.QCStatementInfo;

public class SemanticsInformation
extends QCStatementInfo {
    public static final ObjectID statementID = new ObjectID("1.3.6.1.5.5.7.11.1", "SemanticsInformation", null, false);
    ObjectID a;
    GeneralName[] b;

    public SemanticsInformation() {
    }

    public SemanticsInformation(ObjectID objectID, GeneralName[] generalNameArray) throws IllegalArgumentException {
        if (objectID == null && (generalNameArray == null || generalNameArray.length == 0)) {
            throw new IllegalArgumentException("Both semanticIdentifier and nameRegistrationAuthorities are not allowed to be null!");
        }
        this.a = objectID;
        this.b = generalNameArray;
    }

    public ObjectID getStatementID() {
        return statementID;
    }

    public ObjectID getSemanticsIdentifier() {
        return this.a;
    }

    public GeneralName[] getNameRegistrationAuthorities() {
        return this.b;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n2 = aSN1Object.countComponents();
        if (n2 < 1 || n2 > 2) {
            throw new CodingException("Invalid number of components (" + n2 + ") in this SemanticsInformation!");
        }
        int n3 = 0;
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n3);
        if (aSN1Object2.isA(ASN.ObjectID)) {
            this.a = (ObjectID)aSN1Object2;
            if (n2 == 2) {
                ++n3;
            } else {
                return;
            }
        }
        aSN1Object2 = aSN1Object.getComponentAt(n3);
        n2 = aSN1Object2.countComponents();
        if (n3 == 0 && n2 == 0) {
            throw new CodingException("Invalid empty SemanticsInformation object.");
        }
        this.b = new GeneralName[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.b[i2] = new GeneralName(aSN1Object2.getComponentAt(i2));
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.a == null && (this.b == null || this.b.length == 0)) {
            throw new CodingException("Cannot create ASN.1 object. Both semanticIdentifier and nameRegistrationAuthorities are not allowed to be null!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(this.a);
        }
        if (this.b != null) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                sEQUENCE2.addComponent(this.b[i2].toASN1Object());
            }
            sEQUENCE.addComponent(sEQUENCE2);
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("SemanticsIdentifier: " + this.a.getName() + "\n");
        }
        if (this.b != null) {
            stringBuffer.append("NameRegsitrationAuthorities:\n");
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                stringBuffer.append(this.b[i2] + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

