/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;
import java.util.Date;

public class CrlID
extends V3Extension {
    public static final ObjectID oid = ObjectID.ocspExt_CrlID;
    private String a;
    private BigInteger b;
    private ChoiceOfTime c;

    public void setCrlUrl(String string) {
        this.a = string;
    }

    public String getCrlUrl() {
        return this.a;
    }

    public void setCrlNum(int n2) {
        this.b = n2 == -1 ? null : BigInteger.valueOf(n2);
    }

    public void setCrlNumber(BigInteger bigInteger) {
        this.b = bigInteger;
    }

    public int getCrlNum() {
        return this.b == null ? -1 : this.b.intValue();
    }

    public BigInteger getCrlNumber() {
        return this.b;
    }

    public void setCrlTime(Date date) {
        this.c = date == null ? null : new ChoiceOfTime(date, ASN.GeneralizedTime);
    }

    public Date getCrlTime() {
        return this.c == null ? null : this.c.getDate();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            block7: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
                ASN1Object aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                int n2 = cON_SPEC.getAsnType().getTag();
                switch (n2) {
                    case 0: {
                        this.a = (String)aSN1Object2.getValue();
                        continue block7;
                    }
                    case 1: {
                        this.b = (BigInteger)aSN1Object2.getValue();
                        continue block7;
                    }
                    case 2: {
                        this.c = new ChoiceOfTime(aSN1Object2);
                        continue block7;
                    }
                    default: {
                        throw new X509ExtensionException("Invalid tag in CrlID encoding: " + n2);
                    }
                }
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, new IA5String(this.a)));
        }
        if (this.b != null) {
            sEQUENCE.addComponent(new CON_SPEC(1, new INTEGER(this.b)));
        }
        if (this.c != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, this.c.toASN1Object()));
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("crlUrl: " + this.a);
        }
        if (this.b != null) {
            stringBuffer.append("\ncrlNum: " + this.b.toString());
        }
        if (this.c != null) {
            stringBuffer.append("\ncrlTime: " + this.c);
        }
        return stringBuffer.toString();
    }
}

