/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.AESSecretKey;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.CAST128SecretKey;
import iaik.pkcs.pkcs11.objects.CAST3SecretKey;
import iaik.pkcs.pkcs11.objects.CASTSecretKey;
import iaik.pkcs.pkcs11.objects.DES2SecretKey;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.DESSecretKey;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericSecretKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.IDEASecretKey;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RC2SecretKey;
import iaik.pkcs.pkcs11.objects.RC4SecretKey;
import iaik.pkcs.pkcs11.objects.RC5SecretKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.X942DHPrivateKey;
import iaik.pkcs.pkcs11.objects.X942DHPublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.KeyHandler;
import iaik.pkcs.pkcs11.provider.c;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DHParameterSpec;

public class DefaultKeyHandler
extends KeyHandler {
    private static final byte[] o = new byte[]{-16, 96, -49, -94, 63, 101, -102, 18, 62, -106, 112, 61, 83, 105, -74, 97, 18, 6, -76, -25, 34, -125, -122, -105, 23, -55, -3, 123, 63, -98, 46, 84, -114, -5, 24, 50, -12, 12, 83, -36, 8, -86, -2, -107, -103, -3, -81, 76, 57, 21, 101, 43, 2, 19, -111, -127, -58, 35, -107, 70, -73, -90, -39, -43};
    private static final byte[] p = new byte[]{15, 64, 8, 104, -4, 110, -4, 18, 96, -7, 67, 83, -22, -53, 73, -29, 20, 1, 4, 58, 24, 18, -112, -79, 15, 46, -105, -128, -18, 116, -116, -102, 0, 33, -4, 89, 95, 93, 13, -16, 5, -104, 31, -36, -85, -24, -65, -120, 116, 23, -64, 108, 31, 91, -90, -104, -114, -10, -73, -109, 100, -73, -115, 5};
    private static final byte[] q = new byte[]{-21, -72, 13, 18, 0, 59, 110, -65, 46, 18, 112, 82, -74, 105, -27, 109, 115, 70, 42, 21, -32, 92, 109, 46, -2, 60, 103, 22, -48, -8, -19, 78, 53, -64, -62, 37, -26, -37, 116, -16, 95, -78, -30, -61, 10, 75, -126, -15, -86, -49, 9, -7, 2, -89, 6, 87, -72, 72, 47, -48, 100, -86, -72, -9, -6, -118, -111, -117, -89, 9, -49, -33, 46, -52, -92, 29, -84, -104, -31, 16, -38, 125, 12, 40, -25, 0, -67, 73, 126, 1, -101, 22, -57, 113, 59, -13};
    private static final byte[] r = new byte[]{55, 97, -4, 22, -70, 100, -6, 34, -90, 57, -102, 36, -75, -35, 100, -40, 20, 57, 0, 14, 52, -4, -39, -119, 22, 51, -58, 10, -73, -104, -102, 121, 21, -91, 65, -33, -37, 27, 45, 35, 93, 74, -104, -121, 26, 83, -88, 116, 23, -93, -70, -116, -82, 95, 26, 10, 112, -71, 23, -10, -96, 21, -62, 101, -40, -113, -55, -88, -34, 3, 79, 83, -44, 97, -103, -66, -104, 97, -66, -68, 0, 102, 31, -41, -57, 89, -43, 99, -127, 108, 6, -124, -93, 81, 31, -64};
    private static final byte[] s = new byte[]{-86, -62, 47, 83, 18, -118, 18, 67, -88, 34, 84, -59, 33, 121, -48, -69, 25, -17, 103, -118, 50, -45, 87, 67, 33, 75, -114, -126, 18, -74, 76, -88, 89, -121, -41, 30, 101, 112, 34, -43, 66, 17, -55, 56, -16, -75, 40, 95, -101, -53, 11, 91, -110, 72, -109, 52, 72, -58, 118, -116, -43, 3, 98, 105, -52, 12, -11, -15, 11, -111, -104, 79, 105, -76, -118, -40, 47, -102, 117, -97, -75, 103, -9, -89, -9, 79, 10, 96, -38, -83, -115, -60, 40, 93, 26, 54, 81, 54, 58, -59, 127, -69, 99, -46, -26, -59, -81, -21, -15, 112, 51, -55, -64, -88, -8, 31, -80, -92, -15, -8, 103, 78, -112, 105, 123, -13, -25, 103};
    private static final byte[] t = new byte[]{102, 80, -68, -58, -75, -14, -72, -127, -71, -65, 88, -122, 20, 64, -43, 35, -111, 32, 111, 73, 109, -24, -50, 11, 6, -128, -113, -96, 61, -49, 96, -127, -36, 63, -96, -87, 91, -98, -94, -65, -18, 68, -52, -9, -101, -102, -118, -108, 106, 27, -43, 54, -48, 41, 112, -128, 54, -59, -47, -14, -56, -86, -118, 48, 100, 77, 2, 19, -123, -111, -103, 77, -90, -52, 59, -112, -123, -117, -33, 115, 66, -97, -42, -102, -28, -104, 25, 103, -39, 10, 77, 110, -34, 28, -54, 110, 2, 117, 22, -116, -107, 69, -86, -84, 111, -90, -77, 20, 39, -23, 97, -65, -92, -79, 80, 9, -28, -119, 20, -2, -48, -96, -90, -119, -50, 106, 47, -111};
    private static final byte[] u = new byte[]{-37, 102, 2, -42, -109, 117, -21, 67, -115, 11, -49, 126, 113, -103, 22, 95, -21, 40, 103, 76, 21, -53, -95, -112, 76, -89, -127, 120, -1, 9, 44, 121, -46, 115, -85, -102, -8, 13, 126, -42, 88, -26, 61, 44, 98, -42, 27, 13, 65, 58, -99, 49, 55, -72, -52, -33, -94, -9, 59, -74, -46, -105, -87, -76, 62, -38, -125, 16, -105, -85, 124, 98, -57, -56, 123, -14, -24, 50, -94, 57, 24, -37, -118, 6, -17, -87, 87, 59, -121, 99, 68, -32, 51, 58, 52, 11, -3, 43, 27, 31, 38, 127, 3, 119, 120, -52, 107, 100, 83, 27, 30, 122, -43, 10, -18, 37, -2, -110, 16, 85, 60, 101, -42, 85, 112, -44, 89, -81, 62, 15, -67, -15, -114, -84, 113, 90, -95, 110, 82, -103, 5, 93, -24, 27, -123, -93, 5, 77, 78, 29, 122, 62, -16, 120, -18, -30, -69, 104, -54, 23, 1, 37, 6, 127, 51, -23, -46, 82, 115, 32, -111, -63, -112, 122, 98, -58, 65, -6, 96, 71, 65, -52, 53, 60, -74, 28, -6, 33, 96, 82, -44, 18, -123, 12, 104, -29, 27, 116, -8, -24, 96, 79, -56, -39, -71, 7, -29, -102, -23, 96, -92, 23, 25, -124, -57, -17, -105, 103, -100, 122, -85, 118, -83, 4, 55, 121, -88, -38, -126, -6, 42, 117, -7, 126, -57, -54, -1, -116, 78, 114, 108, -67, 36, 65, 85, -90, 3, -91, -16, 52, -66, 123, 20, -111, 99, 71};
    private static final byte[] v = new byte[]{-117, 86, 122, -83, -22, 101, -41, -52, 21, 62, -122, -80, -111, 60, -113, -91, -109, 46, -113, -99, -62, -99, 15, -120, -2, 37, -86, 12, 93, -116, -63, 5, 115, 35, -28, 100, 113, -93, -14, 71, -65, -93, 119, -26, -62, 86, -43, 26, 55, -33, 57, 93, 66, -67, -75, -54, -77, 34, 24, -62, -36, 5, -120, 41, 108, -22, 75, -95, -38, -61, 85, 86, -122, 122, 120, -71, -36, -82, 85, 14, -107, -46, -35, -43, -29, 23, -95, 59, -80, 33, 36, 37, 80, 44, 56, 31, -53, -6, -113, -31, -75, -84, 63, 26, 106, 11, -48, 60, 10, -117, -61, 16, -103, -30, 44, -19, -110, 71, 127, -106, -1, 56, -82, -54, 28, 84, 65, 99, -34, 97, 118, 125, 36, 59, 51, 99, -78, -1, 20, 21, 77, -80, 54, -91, -99, 76, -110, -19, 120, 82, -115, 41, 54, 103, -21, 38, 94, 96, 89, -45, -78, 119, 73, -61, -10, 73, 56, 13, 97, -104, -107, -98, 15, 107, 117, 45, 46, 51, 54, -34, -29, 9, -84, 32, 86, -9, -61, -99, 125, 45, -94, -123, 78, -84, 34, -38, -89, 84, -80, -18, 81, -36, -66, -122, -107, -98, -44, -30, 52, 103, -83, 107, -116, -3, -42, 50, 78, 126, -125, -44, 72, -3, 39, -40, 37, -37, 76, -43, 0, 46, 103, 10, -8, 45, -46, -60, -44, 53, 52, -111, 113, -30, -6, 76, -9, 1, -64, 3, 47, -66, 89, -42, -30, -85, 0, -21};
    private static final byte[] w = new byte[]{126, 19, 102, -15, -94, -46, 109, -107, -39, -27, -116, 104, -127, 117, -11, -86, 102, -38, -9, 42, 61, -40, 20, 89, 99, -16, 46, -39, -69, -110, 87, -122, -113, -73, -39, -124, -63, 86, 122, 72, 43, -119, 84, 87, -88, 38, -111, 19, 36, 78, -56, -101, 9, -126, 71, -61, 38, 118, 109, -3, 8, -126, -50, 65};
    private static final byte[] x = new byte[]{-67, 46, 57, -115, 64, -123, -71, -120, 116, 123, -101, -7, 22, 89, -121, 106, 42, -72, -19, -48, -114, 97, 29, 112, -88, -19, -46, 72, -115, 7, -35, 7, 63, 105, 10, 9, -31, -13, -61, -95, -5, -33, -83, -49, -97, 67, -118, 103, -6, 78, 4, -112, 13, -4, 75, 1, -50, -66, 115, 66, -24, 4, 61, -21};
    private static final byte[] y = new byte[]{13, -114, -61, 92, -65, -63, 114, -32, -128, 39, -76, 45, -110, 32, -1, 78, -107, -54, 47, 75, -19, -22, -28, 31, 85, 18, 62, 41, 99, 0, 79, 83, -19, -27, -88, 24, -41, -17};
    private static final byte[] z = new byte[]{-119, -61, -126, -41, 13, 34, 26, 27, 42, 102, 81, 41, -74, 53, 11, -23, 99, 91, -10, -65, 22, 106, -26, -35, -102, 46, -37, -7, 9, 6, -6, 68, -19, -60, 120, -106, 85, -41, 98, -34, -38, 94, -61, 101, -128, -3, -59, -36, -74, 6, -21, -86, -124, 22, 20, -111, -87, -59, 82, 45, 46, 95, -7, -72, -48, 110, -71, 93, 114, 32, 2, -9, -86, 22, 12, 98, -87, -102, -18, 3, 107, -34, 103, -46, 69, -119, -35, 110, -115, 17, -29, -88, 90, 83, 107, 83};
    private static final byte[] A = new byte[]{-24, -70, 122, -95, -76, 114, 87, 26, -66, -77, -63, 104, 110, -70, 84, 75, -43, 70, -118, -40, 41, 96, 107, 13, -117, -86, 24, 1, 113, 25, 46, -8, 111, 18, 68, -12, -5, 83, -2, -23, 19, -90, -39, -81, -125, 94, -119, -91, 28, -116, 39, 59, 55, 50, -124, 110, -112, 10, -89, -69, -116, 71, 47, -76, -111, -80, 101, -58, -25, 54, 46, 36, -71, 8, 20, -41, 22, 9, -18, -84, 102, -11, 20, -82, 73, 63, 5, -71, 102, -114, -51, -44, 15, 123, 79, -69};
    private static final byte[] B = new byte[]{14, -102, -25, 93, -42, 68, 39, -17, -27, 34, -88, 46, 115, -62, -28, 62, 3, 60, 83, -32, -69, -50, -98, -54, -115, -8, 88, 55, -58, -117, 17, 49, -42, 76, -97, -25, -93, 49};
    private static final byte[] C = new byte[]{124, -108, 123, 56, -47, 64, 17, -18, -58, -106, -40, 14, -115, 114, 44, -76, 58, 108, -82, 53, 109, 32, 106, 58, -29, 67, 45, 98, 55, -28, -125, -43, -93, 127, -108, -125, 103, 86, 108, 28, -38, -82, -80, -9, -100, -120, 111, 38, -59, 10, 116, 69, 107, 64, -52, 59, 97, 90, 90, -120, 59, 44, -124, 31, 71, 27, 5, -25, 115, 66, 49, -108, -2, 77, 59, 118, -76, 58, 5, 88, -97, -117, 60, -15, 77, -33, -110, -114, 17, 34, -107, 28, -32, 121, 109, 37, -81, -67, 94, -106, 75, -86, -43, -45, -64, -85, 33, -45, 97, -90, -39, 33, 62, 115, -120, 9, 8, -11, 82, -68, -88, -115, 29, -36, -9, 35, -72, 90};
    private static final byte[] D = new byte[]{-27, -21, -122, 101, 122, -77, 95, 11, -58, 29, -16, -114, -2, -5, -12, -15, -126, 77, 94, -21, -74, 72, 59, 78, -96, 67, -48, 31, -34, -53, -114, -4, -121, -83, 82, 16, -126, 79, 84, 30, -107, -51, 33, 54, -65, -51, 84, 105, -3, -126, -9, 116, 117, -124, -96, 20, 113, 100, -105, -102, 4, 103, -53, 48, 10, -73, -51, 6, 127, 121, 9, -117, -111, -36, -111, -42, -104, 29, -41, 23, -13, -58, -45, 7, 73, -70, 82, 60, 116, -127, -125, 29, -116, -26, 51, -29, 8, 59, -92, 39, -102, -30, -27, 17, 46, 66, 38, -49, -97, 19, -19, -100, -17, -78, -79, 3, 38, -100, 32, -40, -79, 77, 108, 28, -40, -46, -51, -13};
    private static final byte[] E = new byte[]{10, 70, -69, -105, -95, 52, 74, 90, -86, -41, 34, 86, 86, 10, -100, 121, -95, -73, 30, -77, -61, 60, 102, 102, -100, -17, 27, -125, 11, -69, -85, 100, -41, 36, 63, -90, 119, -105};
    private static final byte[] F = new byte[]{-123, -75, 87, 86, -77, 98, 126, -69, 26, -9, 74, 98, -13, -54, 85, -36, -49, 108, -95, 41, 113, 8, 113, 65, 111, -4, 34, 113, -15, -27, 38, -1, 78, 26, 122, 56, 96, -123, -91, 103, 43, 104, -63, 81, -82, 92, 80, -87, -16, 60, -37, -38, 88, -117, 37, -94, -86, 99, 115, 57, -44, -38, -121, 64, -102, -84, -8, -59, 51, -56, -68, 89, 35, -52, -91, 100, 71, -18, 122, -89, 17, 108, -26, 117, -3, 76, 10, 67, -29, -44, 120, -59, -74, -85, -8, 17, -7, 9, 16, 88, 117, 96, -76, 40, 35, 34, 73, -86, 35, -122, -47, 83, 72, -81, 5, -77, -66, 32, -36, -12, 39, -90, 69, 32, -52, -104, -105, 17, 76, 24, -37, -99, -77, 11, 100, 90, -77, -123, -94, 100, -120, 4, -26, 126, 122, -70, -32, 122, -98, -91, -99, -123, 126, 14, -126, -47, 4, -86, -64, -82, -57, -40, 112, 87, 100, 50, 96, -110, 87, -106, 54, -94, 39, 120, 31, -109, -19, 126, 48, 71, 96, -65, -66, -94, 101, 35, -124, -113, -106, -78, -101, -86, 7, 109, -3, 73, -103, -13, -85, -112, 75, -17, -33, 99, -75, -71, 51, -34, -96, -2, 114, -95, -46, -67, -120, 51, 22, -112, 32, -105, -88, -108, -54, 10, -69, -4, 82, 25, 6, 65, -35, -70, -80, 78, -123, 122, -26, -5, -86, 69, -13, -24, -45, -101, 77, 84, 64, 108, -121, -101, -38, 104, 54, -69, -115, -19};
    private static final byte[] G = new byte[]{-74, 94, 41, -30, -68, 12, 71, -86, -72, 84, -79, -117, 18, 49, 66, -86, 10, -54, -50, -116, 53, 95, -121, 56, 97, 1, -95, -24, 66, -91, 90, 23, 5, -82, -40, -117, -127, 34, -90, -24, 44, 25, -44, -113, 49, -65, 111, 36, -9, 100, -12, -97, -98, -97, -3, -36, 45, 24, -75, -95, -27, 102, 115, -53, -79, 112, 78, 121, -19, -27, 91, -100, -18, 18, 32, 122, -42, 66, 24, -38, 42, 114, 39, 94, -86, -121, 23, 102, 107, -41, 52, -74, -16, 89, 66, -63, 27, -66, -87, 108, -51, 97, -114, 21, -96, -92, -7, 93, 125, 42, 126, 10, 59, 9, 21, 99, 78, -114, 61, 86, 68, 66, 69, -18, -33, 78, 58, 27, -116, 93, -82, 122, 104, 60, -57, -1, 50, 125, 109, 106, -68, 47, 42, 60, -29, 98, 118, -68, 8, 47, -46, 100, -79, -70, 80, -61, -23, -12, 59, 120, -94, 55, -40, -55, -10, 22, 73, -39, -28, 88, -52, -95, 37, -70, 24, 63, -39, 21, -3, 35, 74, 22, 99, -21, -117, -34, 100, 44, 107, -62, 87, -126, 83, -2, 21, 32, 28, 87, 19, 86, 27, 49, -77, 42, -35, 9, 118, 29, -77, -67, 78, -33, -118, -45, -48, -101, -64, -114, -122, 85, 125, 49, 73, -112, -119, -47, 83, 83, -11, -39, 56, -37, -84, -78, 59, 42, -17, 124, -71, -55, -51, 63, 48, 41, 17, -55, -69, 68, 78, 87, -97, -128, 74, -25, -93, -39};
    private static final byte[] H = new byte[]{13, -15, -3, -92, -83, 42, -36, -79, 37, 116, 36, 59, -29, -2, -78, -95, 32, -66, -78, -123, 72, -39, 87, 98, 19, 35, 118, -35, 62, 124, -14, -97, 49, -19, 100, 17, 99, -85};
    private static final byte[] I = new byte[]{-63, 108, -70, -45, 77, 71, 94, -59, 57, 102, -107, -42, -108, -68, -117, -60, 126, 89, -114, 35, -75, -87, -41, -59, -50, -56, 45, 101, -74, -126, 125, 68, -23, 83, 120, 72, 71, 48, -64, -65, -15, -12, -53, 86, -12, 124, 110, 81, 5, 75, -24, -110, 0, -13, 13, 67, -36, 79, -17, -106, 36, -44, 102, 91};
    private static final byte[] J = new byte[]{-73, -72, 16, -75, -116, 9, 52, -10, 66, -121, -113, 54, 11, -106, -41, -52, 38, -75, 62, 77};
    private static final byte[] K = new byte[]{76, 83, -57, 38, -67, -65, -69, -90, 84, -99, 126, 115, 25, 57, -58, -55, 58, -122, -102, 39, -59, -37, 23, -70, 60, -84, 88, -99, 123, 62, 0, 63, -89, 53, -14, -112, -49, -48, 122, 62, -15, 15, 53, 21, 95, 26, 46, -9, 3, 53, -81, 123, 106, 82, 17, -95, 16, 53, 24, -5, -92, 78, -105, 24};
    private static final byte[] L = new byte[]{-28, -3, -67, -20, 39, 58, -72, -122, 46, 39, 109, 95, -18, 103, 72, -78, 63, -52, 114, 101, -1, -58, 0, -51, 1, -32, 51, 104, -86, -75, 72, 114, -86, 108, -104, -12, -41, -106, -69, 125, -112, -52, -77, 106, 69, -11, 90, 5, -69, -96, 109, -35, -43, 61, 27, 65, 25, 96, -38, 9, 111, -84, 7, 95, 40, 51, -65, -113, 23, 59, -22, -106, -54, 83, 2, 106, 67, -79, 124, -100, 0, -3, 81, -74, -98, -92, 4, -64, -42, 9, 107, -86, 101, 75, -35, 43};
    private static final byte[] M = new byte[]{-125, -36, -107, -78, 5, 106, 105, -92, -29, -120, 23, 114, -77, 4, 106, 119, 2, 26, 125, 105};
    private static final byte[] N = new byte[]{98, -7, 116, 90, 6, -5, 15, -93, -87, 78, -74, -26, -40, -3, 78, -56, 28, -32, 75, 26, 102, -12, -62, -25, -32, -4, 43, 116, 81, 37, 41, -45, 56, 22, -62, -90, -65, -112, 58, 23, -24, 64, 102, 66, -22, 76, -14, -98, 127, -42, -47, 46, 22, 115, 79, 6, 83, 91, -5, -47, -90, 28, 54, -15, 40, -70, -12, 122, 30, 98, 13, -6, -36, -11, 108, 118, -28, -116, 71, -100, -62, 12, 43, -5, -77, 111, -86, -116, 54, -125, 78, -106, -56, 68, 32, -48};
    private static final byte[] O = new byte[]{-126, 125, -44, -100, -94, 5, 105, -124, -23, -125, 113, -79, 52, 13, 93, 113, -125, -110, -123, -78, 90, -54, -93, -126, -41, -84, 56, 110, -108, 64, -124, 63, 10, 70, 122, -88, 117, -88, -63, -54, 59, 112, -70, 106, -105, 7, 18, -10, -79, -103, -19, 62, -20, 83, 19, -13, -108, 10, 103, -69, -42, -97, 56, 114, 41, 97, -85, 2, 61, 23, -95, 51, 60, 82, 35, 93, -97, -73, -47, 14, -107, -29, -91, 94, -7, -80, 79, -57, -55, 32, -59, 114, -38, 122, -61, -43, 15, 36, 13, -69, -114, 84, -38, -98, -69, 112, 33, 17, -59, 53, -126, -27, 53, -123, 46, -97, 89, 57, 121, -77, 50, 80, -56, -122, -125, -106, 25, 23};
    private static final byte[] P = new byte[]{-6, 80, 121, -38, -6, 63, 58, -79, -24, 10, 109, -11, -67, 22, -14, 36, -40, -8, -41, 27};
    private static final byte[] Q = new byte[]{79, -67, -11, 46, 51, 4, -16, 81, -63, 124, -91, 92, -109, -127, -75, -63, 125, 76, 32, 80, 118, -123, 52, 80, -49, -39, -4, 114, -78, -31, -78, -79, 111, -96, 16, 72, -72, -1, 23, -25, -87, 10, -31, -32, 24, 5, 62, 52, -39, -43, 97, -33, 113, 76, -56, -36, -110, -79, 81, -75, -33, 102, 89, 112, 107, 94, 87, -61, 25, -94, -42, 88, 59, 125, 50, -46, -23, -31, -15, 102, 62, -86, -84, 70, 13, -51, 78, 103, 112, 54, -9, -7, -66, 11, 46, 22, -96, 93, 105, 93, 91, -127, 19, -87, 3, -53, 56, 99, 86, 26, -67, 54, 74, 93, 108, 21, 102, 23, -6, 16, -93, 32, -103, -31, -46, 52, 119, 19};
    private static final byte[] R = new byte[]{1, 0, 1};
    private boolean S;
    private Map T = Collections.synchronizedMap(new WeakHashMap(32));
    static Class c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;
    static Class h;
    static Class i;
    static Class j;
    static Class k;
    static Class l;
    static Class m;
    static Class n;

    public DefaultKeyHandler() {
        this.a();
    }

    protected void a() {
        String string = this.b.getProperty("AUTO_CONVERSION", "false");
        if (string != null) {
            this.S = Boolean.valueOf(string);
        }
    }

    public Key handleCipherKey(String string, int n, Key key) {
        if (this.S && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.a(iAIKPkcs11, string, key, n);
        }
        return key;
    }

    public Key handleMacKey(String string, Key key) {
        if (this.S && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.a(iAIKPkcs11, string, key);
        }
        return key;
    }

    public PrivateKey handleSignatureKey(String string, PrivateKey privateKey) {
        if (this.S && !(privateKey instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return privateKey;
            }
            return this.a(iAIKPkcs11, string, privateKey);
        }
        return privateKey;
    }

    public PublicKey handleVerificationKey(String string, PublicKey publicKey) {
        if (this.S && !(publicKey instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return publicKey;
            }
            return this.a(iAIKPkcs11, string, publicKey);
        }
        return publicKey;
    }

    public Key handleKeyAgreementKey(String string, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        if (this.S && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.b(iAIKPkcs11, string, key);
        }
        return key;
    }

    public Key handleKeyAgreementPhaseKey(String string, Key key) {
        if (this.S && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.c(iAIKPkcs11, string, key);
        }
        return key;
    }

    public KeySpec handleKeyFactoryGeneratePublic(String string, KeySpec keySpec) {
        if (this.S && !(keySpec instanceof PKCS11KeySpec)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return keySpec;
            }
            return this.a(iAIKPkcs11, string, keySpec);
        }
        return keySpec;
    }

    public KeySpec handleKeyFactoryGeneratePrivate(String string, KeySpec keySpec) {
        if (this.S && !(keySpec instanceof PKCS11KeySpec)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return keySpec;
            }
            return this.b(iAIKPkcs11, string, keySpec);
        }
        return keySpec;
    }

    public Key handleKeyFactoryTranslateKey(String string, Key key) {
        if (this.S && !(key instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return key;
            }
            return this.d(iAIKPkcs11, string, key);
        }
        return key;
    }

    public KeySpec handleSecretKeyFactoryGenerateSecret(String string, KeySpec keySpec) {
        if (this.S && !(keySpec instanceof PKCS11KeySpec)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return keySpec;
            }
            return this.c(iAIKPkcs11, string, keySpec);
        }
        return keySpec;
    }

    public javax.crypto.SecretKey handleSecretKeyFactoryTranslateKey(String string, javax.crypto.SecretKey secretKey) {
        if (this.S && !(secretKey instanceof IAIKPKCS11Key)) {
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
            if (iAIKPkcs11 == null) {
                return secretKey;
            }
            return this.a(iAIKPkcs11, string, secretKey);
        }
        return secretKey;
    }

    public KeyPair getKeyPairGeneratorTemplate(String string, int n) {
        KeyPair keyPair;
        boolean bl = true;
        if (string.equalsIgnoreCase("RSA") || string.equalsIgnoreCase("RSA/X9.31")) {
            keyPair = this.f(n);
        } else if (string.equalsIgnoreCase("DH")) {
            keyPair = this.a(n);
        } else if (string.equalsIgnoreCase("DH/X9.42")) {
            keyPair = this.b(n);
        } else if (string.equalsIgnoreCase("DSA")) {
            keyPair = this.c(n);
        } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
            keyPair = this.d(n);
        } else if (string.equalsIgnoreCase("KEA")) {
            keyPair = this.e(n);
        } else {
            throw new IAIKPkcs11Exception("Unknown algorithm: " + string);
        }
        this.a(keyPair, bl);
        return keyPair;
    }

    public KeyPair getKeyPairGeneratorTemplate(String string, AlgorithmParameterSpec algorithmParameterSpec) {
        KeyPair keyPair;
        boolean bl = true;
        if (string.equalsIgnoreCase("RSA") || string.equalsIgnoreCase("RSA/X9.31")) {
            keyPair = this.f(algorithmParameterSpec);
        } else if (string.equalsIgnoreCase("DH")) {
            keyPair = this.a(algorithmParameterSpec);
        } else if (string.equalsIgnoreCase("DH/X9.42")) {
            keyPair = this.b(algorithmParameterSpec);
        } else if (string.equalsIgnoreCase("DSA")) {
            keyPair = this.c(algorithmParameterSpec);
        } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
            keyPair = this.d(algorithmParameterSpec);
        } else if (string.equalsIgnoreCase("KEA")) {
            keyPair = this.e(algorithmParameterSpec);
        } else {
            throw new IAIKPkcs11Exception("Unknown algorithm: " + string);
        }
        this.a(keyPair, bl);
        return keyPair;
    }

    public SecretKey getKeyGeneratorTemplate(String string, int n) {
        AESSecretKey aESSecretKey;
        if (string.equalsIgnoreCase("AES")) {
            if (n != -1 && n != 128 && n != 192 && n != 256) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            AESSecretKey aESSecretKey2 = new AESSecretKey();
            int n2 = n == -1 ? 16 : (n + 7) / 8;
            aESSecretKey2.getValueLen().setLongValue(new Long(n2));
            aESSecretKey = aESSecretKey2;
        } else if (string.equalsIgnoreCase("CAST128")) {
            if (n != -1 && (n < 8 || n > 128 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            CAST128SecretKey cAST128SecretKey = new CAST128SecretKey();
            int n3 = n == -1 ? 16 : (n + 7) / 8;
            cAST128SecretKey.getValueLen().setLongValue(new Long(n3));
            aESSecretKey = cAST128SecretKey;
        } else if (string.equalsIgnoreCase("CAST3")) {
            if (n != -1 && (n < 8 || n > 64 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            CAST3SecretKey cAST3SecretKey = new CAST3SecretKey();
            int n4 = n == -1 ? 8 : (n + 7) / 8;
            cAST3SecretKey.getValueLen().setLongValue(new Long(n4));
            aESSecretKey = cAST3SecretKey;
        } else if (string.equalsIgnoreCase("CAST")) {
            if (n != -1 && (n < 8 || n > 64 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            CASTSecretKey cASTSecretKey = new CASTSecretKey();
            int n5 = n == -1 ? 8 : (n + 7) / 8;
            cASTSecretKey.getValueLen().setLongValue(new Long(n5));
            aESSecretKey = cASTSecretKey;
        } else if (string.equalsIgnoreCase("DES2")) {
            if (n != -1 && n != 112 && n != 128) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new DES2SecretKey();
        } else if (string.equalsIgnoreCase("DESede")) {
            if (n != -1 && n != 168 && n != 192) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new DES3SecretKey();
        } else if (string.equalsIgnoreCase("DES")) {
            if (n != -1 && n != 56 && n != 64) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new DESSecretKey();
        } else if (string.equalsIgnoreCase("GenericSecret")) {
            if (n != -1 && (n < 8 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            GenericSecretKey genericSecretKey = new GenericSecretKey();
            int n6 = n == -1 ? 16 : (n + 7) / 8;
            genericSecretKey.getValueLen().setLongValue(new Long(n6));
            aESSecretKey = genericSecretKey;
        } else if (string.equalsIgnoreCase("IDEA")) {
            if (n != -1 && n != 128) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            aESSecretKey = new IDEASecretKey();
        } else if (string.equalsIgnoreCase("RC2")) {
            if (n != -1 && (n < 8 || n > 1024 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            RC2SecretKey rC2SecretKey = new RC2SecretKey();
            int n7 = n == -1 ? 16 : (n + 7) / 8;
            rC2SecretKey.getValueLen().setLongValue(new Long(n7));
            aESSecretKey = rC2SecretKey;
        } else if (string.equalsIgnoreCase("RC4")) {
            if (n != -1 && (n < 8 || n > 2048 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            RC4SecretKey rC4SecretKey = new RC4SecretKey();
            int n8 = n == -1 ? 16 : (n + 7) / 8;
            rC4SecretKey.getValueLen().setLongValue(new Long(n8));
            aESSecretKey = rC4SecretKey;
        } else if (string.equalsIgnoreCase("RC5")) {
            if (n != -1 && (n < 0 || n > 2040 || n % 8 != 0)) {
                throw new InvalidParameterException("Invalid key size: " + n);
            }
            RC5SecretKey rC5SecretKey = new RC5SecretKey();
            int n9 = n == -1 ? 16 : (n + 7) / 8;
            rC5SecretKey.getValueLen().setLongValue(new Long(n9));
            aESSecretKey = rC5SecretKey;
        } else {
            throw new IAIKPkcs11Exception("Unknown algorithm: " + string);
        }
        aESSecretKey.getToken().setBooleanValue(Boolean.FALSE);
        aESSecretKey.getPrivate().setBooleanValue(Boolean.TRUE);
        aESSecretKey.getSensitive().setBooleanValue(Boolean.TRUE);
        return aESSecretKey;
    }

    public SecretKey getKeyGeneratorTemplate(String string, AlgorithmParameterSpec algorithmParameterSpec) {
        throw new InvalidAlgorithmParameterException("params must be null or instance of PKCS11KeyGenerationSpec");
    }

    public void setAutoConversion(boolean bl) {
        this.S = bl;
        this.b.put("AUTO_CONVERSION", true == bl ? "true" : "false");
    }

    public boolean isAutoConversion() {
        return this.S;
    }

    private IAIKPKCS11Key a(IAIKPkcs11 iAIKPkcs11, String string, Key key, int n) {
        IAIKPKCS11Key iAIKPKCS11Key = (IAIKPKCS11Key)this.T.get(new c(key));
        if (iAIKPKCS11Key != null) {
            return iAIKPKCS11Key;
        }
        try {
            BooleanAttribute booleanAttribute = null;
            if (n == 1) {
                booleanAttribute = new BooleanAttribute(Attribute.ENCRYPT);
                booleanAttribute.setBooleanValue(Boolean.TRUE);
            } else if (n == 2) {
                booleanAttribute = new BooleanAttribute(Attribute.DECRYPT);
                booleanAttribute.setBooleanValue(Boolean.TRUE);
            } else if (n == 3) {
                booleanAttribute = new BooleanAttribute(Attribute.WRAP);
                booleanAttribute.setBooleanValue(Boolean.TRUE);
            } else if (n == 4) {
                booleanAttribute = new BooleanAttribute(Attribute.UNWRAP);
                booleanAttribute.setBooleanValue(Boolean.TRUE);
            }
            if (null == booleanAttribute) {
                throw new InvalidKeySpecException("operationMode has to be Cipher.ENCRYPT_MODE, Cipher.DECRYPT_MODE, Cipher.WRAP_MODE, or Cipher.UNWRAP_MODE");
            }
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            if (key instanceof PublicKey) {
                this.b(genericTemplate);
                return this.a(iAIKPkcs11, (PublicKey)key, genericTemplate, key.getAlgorithm());
            }
            this.a(genericTemplate);
            if (key instanceof javax.crypto.SecretKey) {
                return this.a(iAIKPkcs11, (javax.crypto.SecretKey)key, genericTemplate, key.getAlgorithm());
            }
            if (key instanceof PrivateKey) {
                return this.a(iAIKPkcs11, (PrivateKey)key, genericTemplate, key.getAlgorithm());
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
        throw new InvalidKeyException("incompatible key class: " + key.getClass());
    }

    private IAIKPKCS11SecretKey a(IAIKPkcs11 iAIKPkcs11, String string, Key key) {
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)this.T.get(new c(key));
        if (iAIKPKCS11SecretKey != null) {
            return iAIKPKCS11SecretKey;
        }
        try {
            BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.SIGN);
            booleanAttribute.setBooleanValue(Boolean.TRUE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            this.a(genericTemplate);
            if (key instanceof javax.crypto.SecretKey) {
                return this.a(iAIKPkcs11, (javax.crypto.SecretKey)key, genericTemplate, "Generic");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
        throw new InvalidKeyException("incompatible key class: " + key.getClass());
    }

    private IAIKPKCS11PrivateKey a(IAIKPkcs11 iAIKPkcs11, String string, PrivateKey privateKey) {
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)this.T.get(new c(privateKey));
        if (iAIKPKCS11PrivateKey != null) {
            return iAIKPKCS11PrivateKey;
        }
        try {
            BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.SIGN);
            booleanAttribute.setBooleanValue(Boolean.TRUE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            this.a(genericTemplate);
            return this.a(iAIKPkcs11, privateKey, genericTemplate, privateKey.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11PublicKey a(IAIKPkcs11 iAIKPkcs11, String string, PublicKey publicKey) {
        IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)this.T.get(new c(publicKey));
        if (iAIKPKCS11PublicKey != null) {
            return iAIKPKCS11PublicKey;
        }
        try {
            BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.VERIFY);
            booleanAttribute.setBooleanValue(Boolean.TRUE);
            BooleanAttribute booleanAttribute2 = new BooleanAttribute(Attribute.TOKEN);
            booleanAttribute2.setBooleanValue(Boolean.FALSE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            genericTemplate.addAttribute((Attribute)booleanAttribute2);
            return this.a(iAIKPkcs11, publicKey, genericTemplate, publicKey.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11PrivateKey b(IAIKPkcs11 iAIKPkcs11, String string, Key key) {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Invalid key. Key must be a java.security.PrivateKey.");
        }
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)this.T.get(new c(key));
        if (iAIKPKCS11PrivateKey != null) {
            return iAIKPKCS11PrivateKey;
        }
        try {
            BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.DERIVE);
            booleanAttribute.setBooleanValue(Boolean.TRUE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            this.a(genericTemplate);
            return this.a(iAIKPkcs11, (PrivateKey)key, genericTemplate, key.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11PublicKey c(IAIKPkcs11 iAIKPkcs11, String string, Key key) {
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("Invalid key. Key must be a java.security.PublicKey");
        }
        IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)this.T.get(new c(key));
        if (iAIKPKCS11PublicKey != null) {
            return iAIKPKCS11PublicKey;
        }
        try {
            BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.DERIVE);
            booleanAttribute.setBooleanValue(Boolean.TRUE);
            BooleanAttribute booleanAttribute2 = new BooleanAttribute(Attribute.TOKEN);
            booleanAttribute2.setBooleanValue(Boolean.FALSE);
            GenericTemplate genericTemplate = new GenericTemplate();
            genericTemplate.addAttribute((Attribute)booleanAttribute);
            genericTemplate.addAttribute((Attribute)booleanAttribute2);
            return this.a(iAIKPkcs11, (PublicKey)key, genericTemplate, key.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private PKCS11KeySpec a(IAIKPkcs11 iAIKPkcs11, String string, KeySpec keySpec) {
        BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.TOKEN);
        booleanAttribute.setBooleanValue(Boolean.FALSE);
        GenericTemplate genericTemplate = new GenericTemplate();
        genericTemplate.addAttribute((Attribute)booleanAttribute);
        return (PKCS11KeySpec)new PKCS11KeySpec(keySpec, (Object)genericTemplate).setUseUserRole(false);
    }

    private PKCS11KeySpec b(IAIKPkcs11 iAIKPkcs11, String string, KeySpec keySpec) {
        GenericTemplate genericTemplate = new GenericTemplate();
        this.a(genericTemplate);
        return (PKCS11KeySpec)new PKCS11KeySpec(keySpec, (Object)genericTemplate).setUseUserRole(false);
    }

    private PKCS11KeySpec c(IAIKPkcs11 iAIKPkcs11, String string, KeySpec keySpec) {
        GenericTemplate genericTemplate = new GenericTemplate();
        this.a(genericTemplate);
        return (PKCS11KeySpec)new PKCS11KeySpec(keySpec, (Object)genericTemplate).setUseUserRole(false);
    }

    private IAIKPKCS11Key d(IAIKPkcs11 iAIKPkcs11, String string, Key key) {
        IAIKPKCS11Key iAIKPKCS11Key = (IAIKPKCS11Key)this.T.get(new c(key));
        if (iAIKPKCS11Key != null) {
            return iAIKPKCS11Key;
        }
        try {
            GenericTemplate genericTemplate = new GenericTemplate();
            if (key instanceof PrivateKey) {
                this.a(genericTemplate);
                return this.a(iAIKPkcs11, (PrivateKey)key, genericTemplate, key.getAlgorithm());
            }
            if (key instanceof PublicKey) {
                BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.TOKEN);
                booleanAttribute.setBooleanValue(Boolean.FALSE);
                genericTemplate.addAttribute((Attribute)booleanAttribute);
                return this.a(iAIKPkcs11, (PublicKey)key, genericTemplate, key.getAlgorithm());
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
        throw new InvalidKeyException("incompatible key class: " + key.getClass());
    }

    private IAIKPKCS11SecretKey a(IAIKPkcs11 iAIKPkcs11, String string, javax.crypto.SecretKey secretKey) {
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)this.T.get(new c(secretKey));
        if (iAIKPKCS11SecretKey != null) {
            return iAIKPKCS11SecretKey;
        }
        try {
            GenericTemplate genericTemplate = new GenericTemplate();
            this.a(genericTemplate);
            return this.a(iAIKPkcs11, secretKey, genericTemplate, secretKey.getAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IAIKPkcs11Exception("error converting key to PKCS#11 key: " + generalSecurityException);
        }
    }

    private IAIKPKCS11SecretKey a(IAIKPkcs11 iAIKPkcs11, javax.crypto.SecretKey secretKey, GenericTemplate genericTemplate, String string) {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(secretKey.getAlgorithm(), iAIKPkcs11.getName());
        Class clazz = this.b(string);
        KeySpec keySpec = secretKeyFactory.getKeySpec(secretKey, clazz);
        SecretKeyFactory secretKeyFactory2 = SecretKeyFactory.getInstance(string, iAIKPkcs11.getName());
        PKCS11KeySpec pKCS11KeySpec = (PKCS11KeySpec)new PKCS11KeySpec(keySpec, (Object)genericTemplate).setUseUserRole(false);
        IAIKPKCS11SecretKey iAIKPKCS11SecretKey = (IAIKPKCS11SecretKey)secretKeyFactory2.generateSecret(pKCS11KeySpec);
        this.T.put(new c(secretKey), iAIKPKCS11SecretKey);
        return iAIKPKCS11SecretKey;
    }

    private Class b(String string) {
        Class clazz = string.equalsIgnoreCase("DES") ? (d == null ? (d = DefaultKeyHandler.a("javax.crypto.spec.DESKeySpec")) : d) : (string.equalsIgnoreCase("DESede") ? (e == null ? (e = DefaultKeyHandler.a("javax.crypto.spec.DESedeKeySpec")) : e) : (f == null ? (f = DefaultKeyHandler.a("javax.crypto.spec.SecretKeySpec")) : f));
        return clazz;
    }

    private IAIKPKCS11PublicKey a(IAIKPkcs11 iAIKPkcs11, PublicKey publicKey, GenericTemplate genericTemplate, String string) {
        KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm(), iAIKPkcs11.getName());
        Class clazz = string.equalsIgnoreCase("RSA") ? (g == null ? (g = DefaultKeyHandler.a("java.security.spec.RSAPublicKeySpec")) : g) : (string.equalsIgnoreCase("DSA") ? (h == null ? (h = DefaultKeyHandler.a("java.security.spec.DSAPublicKeySpec")) : h) : (string.equalsIgnoreCase("DH") ? (i == null ? (i = DefaultKeyHandler.a("javax.crypto.spec.DHPublicKeySpec")) : i) : (j == null ? (j = DefaultKeyHandler.a("java.security.spec.X509EncodedKeySpec")) : j)));
        java.lang.Object t = keyFactory.getKeySpec(publicKey, clazz);
        KeyFactory keyFactory2 = KeyFactory.getInstance(publicKey.getAlgorithm(), iAIKPkcs11.getName());
        PKCS11KeySpec pKCS11KeySpec = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)t, (Object)genericTemplate).setUseUserRole(false);
        IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)keyFactory2.generatePublic(pKCS11KeySpec);
        this.T.put(new c(publicKey), iAIKPKCS11PublicKey);
        return iAIKPKCS11PublicKey;
    }

    private IAIKPKCS11PrivateKey a(IAIKPkcs11 iAIKPkcs11, PrivateKey privateKey, GenericTemplate genericTemplate, String string) {
        KeyFactory keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm(), iAIKPkcs11.getName());
        Class clazz = string.equalsIgnoreCase("RSA") ? (k == null ? (k = DefaultKeyHandler.a("java.security.spec.RSAPrivateCrtKeySpec")) : k) : (string.equalsIgnoreCase("DSA") ? (l == null ? (l = DefaultKeyHandler.a("java.security.spec.DSAPrivateKeySpec")) : l) : (string.equalsIgnoreCase("DH") ? (m == null ? (m = DefaultKeyHandler.a("javax.crypto.spec.DHPrivateKeySpec")) : m) : (n == null ? (n = DefaultKeyHandler.a("java.security.spec.PKCS8EncodedKeySpec")) : n)));
        java.lang.Object t = keyFactory.getKeySpec(privateKey, clazz);
        KeyFactory keyFactory2 = KeyFactory.getInstance(privateKey.getAlgorithm(), iAIKPkcs11.getName());
        PKCS11KeySpec pKCS11KeySpec = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)t, (Object)genericTemplate).setUseUserRole(false);
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)keyFactory2.generatePrivate(pKCS11KeySpec);
        this.T.put(new c(privateKey), iAIKPKCS11PrivateKey);
        return iAIKPKCS11PrivateKey;
    }

    private void a(GenericTemplate genericTemplate) {
        this.b(genericTemplate);
        BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.PRIVATE);
        booleanAttribute.setBooleanValue(Boolean.TRUE);
        genericTemplate.addAttribute((Attribute)booleanAttribute);
        BooleanAttribute booleanAttribute2 = new BooleanAttribute(Attribute.SENSITIVE);
        booleanAttribute2.setBooleanValue(Boolean.TRUE);
        genericTemplate.addAttribute((Attribute)booleanAttribute2);
    }

    private void b(GenericTemplate genericTemplate) {
        BooleanAttribute booleanAttribute = new BooleanAttribute(Attribute.TOKEN);
        booleanAttribute.setBooleanValue(Boolean.FALSE);
        genericTemplate.addAttribute((Attribute)booleanAttribute);
    }

    private void a(KeyPair keyPair, boolean bl) {
        iaik.pkcs.pkcs11.objects.PrivateKey privateKey = keyPair.getPrivateKey();
        privateKey.getToken().setBooleanValue(new Boolean(bl));
        privateKey.getPrivate().setBooleanValue(Boolean.TRUE);
        privateKey.getSensitive().setBooleanValue(Boolean.TRUE);
    }

    private KeyPair a(int n) {
        DHPrivateKey dHPrivateKey = new DHPrivateKey();
        dHPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
        DHPublicKey dHPublicKey = new DHPublicKey();
        if (n == -1) {
            n = 1024;
        }
        switch (n) {
            case 512: {
                dHPublicKey.getPrime().setByteArrayValue(o);
                dHPublicKey.getBase().setByteArrayValue(p);
                break;
            }
            case 768: {
                dHPublicKey.getPrime().setByteArrayValue(q);
                dHPublicKey.getBase().setByteArrayValue(r);
                break;
            }
            case 1024: {
                dHPublicKey.getPrime().setByteArrayValue(s);
                dHPublicKey.getBase().setByteArrayValue(t);
                break;
            }
            case 2048: {
                dHPublicKey.getPrime().setByteArrayValue(u);
                dHPublicKey.getBase().setByteArrayValue(v);
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported key size: " + n);
            }
        }
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)dHPrivateKey);
    }

    private KeyPair a(AlgorithmParameterSpec algorithmParameterSpec) {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + algorithmParameterSpec);
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        DHPrivateKey dHPrivateKey = new DHPrivateKey();
        dHPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
        dHPrivateKey.getValueBits().setLongValue(new Long(dHParameterSpec.getL()));
        DHPublicKey dHPublicKey = new DHPublicKey();
        byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)dHParameterSpec.getP());
        byte[] byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)dHParameterSpec.getG());
        dHPublicKey.getPrime().setByteArrayValue(byArray);
        dHPublicKey.getBase().setByteArrayValue(byArray2);
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)dHPrivateKey);
    }

    private KeyPair b(int n) {
        X942DHPrivateKey x942DHPrivateKey = new X942DHPrivateKey();
        x942DHPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
        X942DHPublicKey x942DHPublicKey = new X942DHPublicKey();
        if (n == -1) {
            n = 1024;
        }
        switch (n) {
            case 512: {
                x942DHPublicKey.getPrime().setByteArrayValue(x);
                x942DHPublicKey.getSubprime().setByteArrayValue(y);
                x942DHPublicKey.getBase().setByteArrayValue(w);
                break;
            }
            case 768: {
                x942DHPublicKey.getPrime().setByteArrayValue(A);
                x942DHPublicKey.getSubprime().setByteArrayValue(B);
                x942DHPublicKey.getBase().setByteArrayValue(z);
                break;
            }
            case 1024: {
                x942DHPublicKey.getPrime().setByteArrayValue(D);
                x942DHPublicKey.getSubprime().setByteArrayValue(E);
                x942DHPublicKey.getBase().setByteArrayValue(C);
                break;
            }
            case 2048: {
                x942DHPublicKey.getPrime().setByteArrayValue(G);
                x942DHPublicKey.getSubprime().setByteArrayValue(H);
                x942DHPublicKey.getBase().setByteArrayValue(F);
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported key size: " + n);
            }
        }
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)x942DHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)x942DHPrivateKey);
    }

    private KeyPair b(AlgorithmParameterSpec algorithmParameterSpec) {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + algorithmParameterSpec);
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        DHPrivateKey dHPrivateKey = new DHPrivateKey();
        dHPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
        X942DHPublicKey x942DHPublicKey = new X942DHPublicKey();
        byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getP());
        byte[] byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getQ());
        byte[] byArray3 = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getG());
        x942DHPublicKey.getPrime().setByteArrayValue(byArray);
        x942DHPublicKey.getSubprime().setByteArrayValue(byArray2);
        x942DHPublicKey.getBase().setByteArrayValue(byArray3);
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)x942DHPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)dHPrivateKey);
    }

    private KeyPair c(int n) {
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
        dSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
        DSAPublicKey dSAPublicKey = new DSAPublicKey();
        if (n == -1) {
            n = 1024;
        }
        switch (n) {
            case 512: {
                dSAPublicKey.getPrime().setByteArrayValue(I);
                dSAPublicKey.getSubprime().setByteArrayValue(J);
                dSAPublicKey.getBase().setByteArrayValue(K);
                break;
            }
            case 768: {
                dSAPublicKey.getPrime().setByteArrayValue(L);
                dSAPublicKey.getSubprime().setByteArrayValue(M);
                dSAPublicKey.getBase().setByteArrayValue(N);
                break;
            }
            case 1024: {
                dSAPublicKey.getPrime().setByteArrayValue(O);
                dSAPublicKey.getSubprime().setByteArrayValue(P);
                dSAPublicKey.getBase().setByteArrayValue(Q);
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported key size: " + n);
            }
        }
        dSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dSAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)dSAPrivateKey);
    }

    private KeyPair c(AlgorithmParameterSpec algorithmParameterSpec) {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + algorithmParameterSpec);
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
        dSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
        DSAPublicKey dSAPublicKey = new DSAPublicKey();
        byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getP());
        byte[] byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getQ());
        byte[] byArray3 = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getG());
        dSAPublicKey.getPrime().setByteArrayValue(byArray);
        dSAPublicKey.getSubprime().setByteArrayValue(byArray2);
        dSAPublicKey.getBase().setByteArrayValue(byArray3);
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)dSAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)dSAPrivateKey);
    }

    private KeyPair d(int n) {
        ObjectID objectID;
        ECDSAPrivateKey eCDSAPrivateKey = new ECDSAPrivateKey();
        eCDSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
        ECDSAPublicKey eCDSAPublicKey = new ECDSAPublicKey();
        if (n == -1) {
            n = 192;
        }
        switch (n) {
            case 163: {
                objectID = new ObjectID("1.2.840.10045.3.0.1");
                break;
            }
            case 176: {
                objectID = new ObjectID("1.2.840.10045.3.0.4");
                break;
            }
            case 191: {
                objectID = new ObjectID("1.2.840.10045.3.0.5");
                break;
            }
            case 192: {
                objectID = new ObjectID("1.2.840.10045.3.1.1");
                break;
            }
            case 208: {
                objectID = new ObjectID("1.2.840.10045.3.0.10");
                break;
            }
            case 224: {
                objectID = new ObjectID("1.3.132.0.33");
                break;
            }
            case 239: {
                objectID = new ObjectID("1.2.840.10045.3.1.4");
                break;
            }
            case 256: {
                objectID = new ObjectID("1.2.840.10045.3.1.7");
                break;
            }
            case 384: {
                objectID = new ObjectID("1.3.132.0.34");
                break;
            }
            case 521: {
                objectID = new ObjectID("1.3.132.0.35");
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported key size: " + n);
            }
        }
        eCDSAPublicKey.getEcdsaParams().setByteArrayValue(DerCoder.encode((ASN1Object)objectID));
        eCDSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)eCDSAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)eCDSAPrivateKey);
    }

    private KeyPair d(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new InvalidAlgorithmParameterException("This implementation does not support key-pair generation parameters.");
    }

    private KeyPair e(int n) {
        KEAPrivateKey kEAPrivateKey = new KEAPrivateKey();
        kEAPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
        KEAPublicKey kEAPublicKey = new KEAPublicKey();
        if (n == -1) {
            n = 1024;
        }
        switch (n) {
            case 512: {
                kEAPublicKey.getPrime().setByteArrayValue(I);
                kEAPublicKey.getSubprime().setByteArrayValue(J);
                kEAPublicKey.getBase().setByteArrayValue(K);
                break;
            }
            case 768: {
                kEAPublicKey.getPrime().setByteArrayValue(L);
                kEAPublicKey.getSubprime().setByteArrayValue(M);
                kEAPublicKey.getBase().setByteArrayValue(N);
                break;
            }
            case 1024: {
                kEAPublicKey.getPrime().setByteArrayValue(O);
                kEAPublicKey.getSubprime().setByteArrayValue(P);
                kEAPublicKey.getBase().setByteArrayValue(Q);
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported key size: " + n);
            }
        }
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)kEAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)kEAPrivateKey);
    }

    private KeyPair e(AlgorithmParameterSpec algorithmParameterSpec) {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + algorithmParameterSpec);
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        KEAPrivateKey kEAPrivateKey = new KEAPrivateKey();
        kEAPrivateKey.getDerive().setBooleanValue(Boolean.TRUE);
        KEAPublicKey kEAPublicKey = new KEAPublicKey();
        byte[] byArray = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getP());
        byte[] byArray2 = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getQ());
        byte[] byArray3 = Util.unsignedBigIntergerToByteArray((BigInteger)dSAParameterSpec.getG());
        kEAPublicKey.getPrime().setByteArrayValue(byArray);
        kEAPublicKey.getSubprime().setByteArrayValue(byArray2);
        kEAPublicKey.getBase().setByteArrayValue(byArray3);
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)kEAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)kEAPrivateKey);
    }

    private KeyPair f(int n) {
        if (n != -1 && n < 0) {
            throw new InvalidParameterException("Invalid key size: " + n);
        }
        int n2 = n == -1 ? 1024 : n;
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        RSAPublicKey rSAPublicKey = new RSAPublicKey();
        rSAPublicKey.getModulusBits().setLongValue(new Long(n2));
        rSAPublicKey.getPublicExponent().setByteArrayValue(R);
        return new KeyPair((iaik.pkcs.pkcs11.objects.PublicKey)rSAPublicKey, (iaik.pkcs.pkcs11.objects.PrivateKey)rSAPrivateKey);
    }

    private KeyPair f(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new InvalidAlgorithmParameterException("This implementation does not support key-pair generation parameters.");
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            URL uRL = (c == null ? (c = DefaultKeyHandler.a("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/default/DefaultKeyHandler.properties");
            InputStream inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            URL uRL2 = (c == null ? (c = DefaultKeyHandler.a("iaik.pkcs.pkcs11.provider.IAIKPkcs11")) : c).getClassLoader().getResource("iaik/pkcs/pkcs11/provider/DefaultKeyHandler.properties");
            if (uRL2 != null) {
                InputStream inputStream2 = uRL2.openStream();
                Properties properties2 = new Properties(properties);
                properties2.load(inputStream2);
                inputStream2.close();
                a = properties2;
            } else {
                a = properties;
            }
        }
        catch (IOException iOException) {
            IAIKPkcs11.errorStream_.println("Could not load DefaultKeyHandler configuration properties.");
            iOException.printStackTrace(IAIKPkcs11.errorStream_);
        }
    }
}

