/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DHPublicKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPublicKey;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.provider.ComparableByteArray;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.b;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11SecretKey;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public class TokenKeyStoreSpi
extends KeyStoreSpi
implements PKCS11EngineClass {
    public static final String KEY_STORE_TYPE = "TokenKeyStoreSpi";
    protected TokenManager a;
    protected Session b;
    protected Session c;
    protected HashSet d;
    protected Hashtable e;
    protected Hashtable f;
    protected Hashtable g;
    protected Hashtable h;
    protected Hashtable i;
    protected Hashtable j;
    protected boolean k;
    protected boolean l;
    protected TokenInfo m;
    protected byte[] n;
    protected String o;
    protected char[] p;
    static Class q;
    static Class r;
    static Class s;
    static Class t;
    static Class u;
    static Class v;
    static Class w;
    static Class x;
    static Class y;
    static Class z;
    static Class A;
    static Class B;

    private static final void b(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
        }
    }

    public TokenKeyStoreSpi() {
    }

    public TokenKeyStoreSpi(TokenManager tokenManager) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null");
        }
        this.a = tokenManager;
        this.g();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Enumeration engineAliases() {
        Set set;
        this.n();
        try {
            this.a();
            set = (Set)this.d.clone();
        }
        finally {
            this.e();
        }
        return Collections.enumeration(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean engineContainsAlias(String string) {
        this.n();
        try {
            this.a();
        }
        finally {
            this.e();
        }
        return this.d.contains(string);
    }

    public synchronized void engineDeleteEntry(String string) {
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.n();
        if (this.d.contains(string)) {
            try {
                this.d();
                if (this.h.containsKey(string)) {
                    this.a(string);
                }
                if (this.i.containsKey(string)) {
                    this.b(string);
                }
                if (this.j.containsKey(string)) {
                    this.c(string);
                }
                this.d.remove(string);
            }
            catch (TokenException tokenException) {
                throw new KeyStoreException(tokenException.toString());
            }
            finally {
                this.e();
            }
        } else {
            throw new KeyStoreException("No entry with alias \"" + string + "\".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.security.cert.Certificate engineGetCertificate(String string) {
        java.security.cert.Certificate certificate;
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.n();
        try {
            this.a();
            java.security.cert.Certificate[] certificateArray = (java.security.cert.Certificate[])this.f.get(string);
            certificate = certificateArray != null && certificateArray.length > 0 ? certificateArray[0] : (java.security.cert.Certificate)this.g.get(string);
        }
        finally {
            this.e();
        }
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String engineGetCertificateAlias(java.security.cert.Certificate certificate) {
        String string;
        block6: {
            if (certificate == null) {
                throw new NullPointerException("argument \"certificate\" must not be null");
            }
            this.n();
            string = null;
            try {
                java.lang.Object object;
                String string2;
                this.a();
                Enumeration enumeration = this.f.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = enumeration.nextElement().toString();
                    object = (java.security.cert.Certificate[])this.f.get(string2);
                    if (object == null || ((java.security.cert.Certificate[])object).length <= 0 || !certificate.equals(object[0])) continue;
                    string = string2;
                    break;
                }
                if (string != null) break block6;
                enumeration = this.g.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = enumeration.nextElement().toString();
                    object = (java.security.cert.Certificate)this.g.get(string2);
                    if (!certificate.equals(object)) continue;
                    string = string2;
                    break;
                }
            }
            finally {
                this.e();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.security.cert.Certificate[] engineGetCertificateChain(String string) {
        java.security.cert.Certificate[] certificateArray;
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        this.n();
        try {
            this.a();
            certificateArray = (java.security.cert.X509Certificate[])this.f.get(string);
            if (certificateArray == null) {
                certificateArray = new java.security.cert.X509Certificate[]{};
            }
        }
        finally {
            this.e();
        }
        return certificateArray;
    }

    public Date engineGetCreationDate(String string) {
        Date date = null;
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Key engineGetKey(String string, char[] cArray) {
        Key key;
        block7: {
            this.n();
            try {
                this.a();
                key = (Key)this.e.get(string);
                if (key != null) break block7;
                try {
                    if (this.a.isTokenPresent()) {
                        if (this.k()) {
                            this.b(false);
                        }
                        this.a();
                        key = (Key)this.e.get(string);
                    }
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception(tokenException.toString());
                }
            }
            finally {
                this.e();
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean engineIsCertificateEntry(String string) {
        this.n();
        try {
            this.a();
        }
        finally {
            this.e();
        }
        return this.g.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean engineIsKeyEntry(String string) {
        this.n();
        try {
            this.a();
        }
        finally {
            this.e();
        }
        return this.e.containsKey(string) || this.f.containsKey(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void engineLoad(InputStream inputStream, char[] cArray) {
        java.lang.Object object;
        if (inputStream != null) {
            object = this.a(inputStream);
            int n = IAIKPkcs11.getProviderInstanceNumber((String)object);
            if (n <= 0) throw new IAIKPkcs11Exception("The IAIKPkcs11 provider with the given name does not exist: " + (String)object);
            IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getProviderInstance(n);
            this.a = iAIKPkcs11.getTokenManager();
        } else if (this.a == null) {
            object = IAIKPkcs11.getCurrentProviderInstance();
            if (object == null) throw new UnsupportedOperationException("Cannot initialize key store. Could not find a IAIKPkcs11 provider.");
            this.a = ((IAIKPkcs11)object).getTokenManager();
        }
        if (cArray != null) {
            try {
                this.a.loginUser(cArray);
                this.p = cArray;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Failed to login the user with the provided PIN: " + (java.lang.Object)((java.lang.Object)tokenException));
            }
        }
        this.g();
    }

    public synchronized void engineSetCertificateEntry(String string, java.security.cert.Certificate certificate) {
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        if (certificate == null) {
            throw new NullPointerException("Argument \"certificate\" must not be null.");
        }
        this.n();
        try {
            Object object;
            this.d();
            if (this.g.containsKey(string)) {
                object = (Object)this.j.get(string);
                if (object != null) {
                    this.g.remove(string);
                    this.d.remove(string);
                    try {
                        this.c.destroyObject(object);
                    }
                    catch (TokenException tokenException) {
                        throw new KeyStoreException("Could not remove already existing certificate with this alias: " + tokenException.toString());
                    }
                } else {
                    this.j.remove(string);
                }
            }
            object = this.a(certificate, null, string.toCharArray());
            this.j.put(string, object);
            this.g.put(string, certificate);
            this.d.add(string);
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        finally {
            this.e();
        }
    }

    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, java.security.cert.Certificate[] certificateArray) {
        if (string == null) {
            throw new NullPointerException("Argument \"alias\" must not be null.");
        }
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        this.n();
        try {
            IAIKPKCS11Key iAIKPKCS11Key;
            iaik.pkcs.pkcs11.objects.Key key2;
            java.lang.Object object;
            java.lang.Object object2;
            java.lang.Object object3;
            java.lang.Object object4;
            Token token;
            java.lang.Object object5;
            java.lang.Object object6;
            X509Certificate x509Certificate;
            Object object7;
            this.d();
            this.a();
            X509Certificate[] x509CertificateArray = Util.convertCertificateChain((java.security.cert.Certificate[])certificateArray);
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                object7 = Util.arrangeCertificateChain((X509Certificate[])x509CertificateArray, (boolean)false);
                if (object7 != null && ((X509Certificate[])object7).length > 0) {
                    x509CertificateArray = object7;
                }
                x509Certificate = x509CertificateArray[0];
            } else {
                x509Certificate = null;
            }
            object7 = null;
            boolean bl = false;
            if (this.d.contains(string)) {
                if (this.e.containsKey(string)) {
                    object7 = (Object)this.h.get(string);
                    bl = true;
                }
                if (this.f.containsKey(string)) {
                    this.b(string);
                }
                if (this.g.containsKey(string)) {
                    this.c(string);
                }
            }
            if (key instanceof IAIKPKCS11Key) {
                object6 = (IAIKPKCS11Key)key;
                object5 = object6.getTokenManager().getToken();
                if (object5.equals((java.lang.Object)(token = this.a.getToken()))) {
                    byte[] byArray;
                    ByteArrayAttribute byteArrayAttribute;
                    java.lang.Object object8;
                    object4 = object6.getKeyObject();
                    object3 = new GenericTemplate();
                    object2 = object4.getLabel().getCharArrayValue();
                    object = string.toCharArray();
                    if (object2 == null || !Arrays.equals((char[])object2, (char[])object)) {
                        object8 = new CharArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.LABEL);
                        object8.setCharArrayValue((char[])object);
                        object3.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)object8);
                    }
                    if ((object8 = (java.lang.Object)object4.getId().getByteArrayValue()) == null) {
                        byteArrayAttribute = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
                        byArray = this.a((byte[])null);
                        byteArrayAttribute.setByteArrayValue(byArray);
                        object3.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)byteArrayAttribute);
                    } else {
                        byArray = null;
                    }
                    if (bl && object7 != null) {
                        if (object7.equals(object4)) {
                            if (object4.getToken().getBooleanValue().booleanValue()) {
                                if (object3.getSetAttributes().size() > 0) {
                                    this.c.setAttributeValues((Object)object4, (Object)object3);
                                    if (byArray != null) {
                                        object4.getId().setByteArrayValue(byArray);
                                    }
                                }
                                key2 = object4;
                            } else {
                                byteArrayAttribute = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                                byteArrayAttribute.setBooleanValue(Boolean.TRUE);
                                object3.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)byteArrayAttribute);
                                key2 = (iaik.pkcs.pkcs11.objects.Key)this.c.copyObject((Object)object4, (Object)object3);
                                this.c.destroyObject(object7);
                            }
                            if (key2 instanceof iaik.pkcs.pkcs11.objects.PrivateKey && byArray != null && (byteArrayAttribute = (iaik.pkcs.pkcs11.objects.PublicKey)this.a(key2)) != null && byteArrayAttribute.getId().getByteArrayValue() == null) {
                                GenericTemplate genericTemplate = new GenericTemplate();
                                ByteArrayAttribute byteArrayAttribute2 = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
                                byteArrayAttribute2.setByteArrayValue(byArray);
                                genericTemplate.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)byteArrayAttribute2);
                                this.c.setAttributeValues((Object)byteArrayAttribute, (Object)genericTemplate);
                            }
                        } else {
                            this.c.destroyObject(object7);
                            if (object4.getToken().getBooleanValue().booleanValue()) {
                                if (object3.getSetAttributes().size() > 0) {
                                    this.c.setAttributeValues((Object)object4, (Object)object3);
                                    if (byArray != null) {
                                        object4.getId().setByteArrayValue(byArray);
                                    }
                                }
                                key2 = object4;
                            } else {
                                byteArrayAttribute = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                                byteArrayAttribute.setBooleanValue(Boolean.TRUE);
                                object3.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)byteArrayAttribute);
                                key2 = (iaik.pkcs.pkcs11.objects.Key)this.c.copyObject((Object)object4, (Object)object3);
                            }
                        }
                    } else if (object4.getToken().getBooleanValue().booleanValue()) {
                        if (object3.getSetAttributes().size() > 0) {
                            this.c.setAttributeValues((Object)object4, (Object)object3);
                            if (byArray != null) {
                                object4.getId().setByteArrayValue(byArray);
                            }
                        }
                        key2 = object4;
                    } else {
                        byteArrayAttribute = new BooleanAttribute(iaik.pkcs.pkcs11.objects.Attribute.TOKEN);
                        byteArrayAttribute.setBooleanValue(Boolean.TRUE);
                        object3.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)byteArrayAttribute);
                        key2 = (iaik.pkcs.pkcs11.objects.Key)this.c.copyObject((Object)object4, (Object)object3);
                    }
                } else {
                    if (bl && object7 != null) {
                        this.c.destroyObject(object7);
                    }
                    object4 = object6.getKeyObject();
                    object3 = this.b((iaik.pkcs.pkcs11.objects.Key)object4);
                    object2 = this.a((byte[])null);
                    object3.getId().setByteArrayValue((byte[])object2);
                    object3.getLabel().setCharArrayValue(string.toCharArray());
                    key2 = (iaik.pkcs.pkcs11.objects.Key)this.c.createObject((Object)object3);
                }
                if (key2 instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
                    iAIKPKCS11Key = IAIKPKCS11PrivateKey.create(this.a, (iaik.pkcs.pkcs11.objects.PrivateKey)key2);
                } else if (key2 instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
                    iAIKPKCS11Key = IAIKPKCS11PublicKey.create(this.a, (iaik.pkcs.pkcs11.objects.PublicKey)key2);
                } else if (key2 instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
                    iAIKPKCS11Key = IAIKPKCS11SecretKey.create(this.a, (iaik.pkcs.pkcs11.objects.SecretKey)key2);
                } else {
                    throw new KeyStoreException("Unknown key type: " + key2.getClass().getName());
                }
                this.h.put(string, key2);
                this.e.put(string, iAIKPKCS11Key);
                this.d.add(string);
            } else {
                if (bl && object7 != null) {
                    this.c.destroyObject(object7);
                }
                object6 = this.a((byte[])null);
                object5 = key.getAlgorithm();
                if (key instanceof PrivateKey) {
                    token = new iaik.pkcs.pkcs11.objects.PrivateKey();
                    token.getToken().setBooleanValue(Boolean.TRUE);
                    token.getId().setByteArrayValue((byte[])object6);
                    token.getLabel().setCharArrayValue(string.toCharArray());
                    token.getPrivate().setBooleanValue(Boolean.TRUE);
                    token.getSensitive().setBooleanValue(Boolean.TRUE);
                    object4 = this.a(key);
                    object3 = this.d((String)object5);
                    this.a((iaik.pkcs.pkcs11.objects.PrivateKey)token, (java.security.cert.X509Certificate)x509Certificate, (MechanismInfo)object3);
                    object2 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object4, (Object)token).setUseUserRole(true);
                    object = KeyFactory.getInstance((String)object5, this.a.getProvider().getName());
                    iAIKPKCS11Key = (IAIKPKCS11Key)((java.lang.Object)((KeyFactory)object).generatePrivate((KeySpec)object2));
                } else if (key instanceof PublicKey) {
                    token = new iaik.pkcs.pkcs11.objects.PublicKey();
                    token.getToken().setBooleanValue(Boolean.TRUE);
                    token.getId().setByteArrayValue((byte[])object6);
                    token.getLabel().setCharArrayValue(string.toCharArray());
                    object4 = this.b(key);
                    object3 = this.d((String)object5);
                    this.a((iaik.pkcs.pkcs11.objects.PublicKey)token, (java.security.cert.X509Certificate)x509Certificate, (MechanismInfo)object3);
                    object2 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object4, (Object)token).setUseUserRole(true);
                    object = KeyFactory.getInstance((String)object5, this.a.getProvider().getName());
                    iAIKPKCS11Key = (IAIKPKCS11Key)((java.lang.Object)((KeyFactory)object).generatePublic((KeySpec)object2));
                } else if (key instanceof SecretKey) {
                    token = new iaik.pkcs.pkcs11.objects.SecretKey();
                    token.getToken().setBooleanValue(Boolean.TRUE);
                    token.getId().setByteArrayValue((byte[])object6);
                    token.getLabel().setCharArrayValue(string.toCharArray());
                    token.getPrivate().setBooleanValue(Boolean.TRUE);
                    token.getSensitive().setBooleanValue(Boolean.TRUE);
                    object4 = this.a((SecretKey)key);
                    object3 = (PKCS11KeySpec)new PKCS11KeySpec((KeySpec)object4, (Object)token).setUseUserRole(true);
                    object2 = SecretKeyFactory.getInstance((String)object5, this.a.getProvider().getName());
                    iAIKPKCS11Key = (IAIKPKCS11Key)((java.lang.Object)((SecretKeyFactory)object2).generateSecret((KeySpec)object3));
                } else {
                    throw new KeyStoreException("Unknown key type: " + key.getClass().getName());
                }
                key2 = iAIKPKCS11Key.getKeyObject();
                this.h.put(string, key2);
                this.e.put(string, iAIKPKCS11Key);
                this.d.add(string);
            }
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                object6 = new Object[x509CertificateArray.length];
                object6[0] = this.a((java.security.cert.Certificate)x509Certificate, key2.getId().getByteArrayValue(), string.toCharArray());
                for (int i2 = 1; i2 < x509CertificateArray.length; ++i2) {
                    object6[i2] = this.a((java.security.cert.Certificate)x509CertificateArray[i2], null, string.toCharArray());
                }
                this.i.put(string, object6);
                this.f.put(string, x509CertificateArray);
            }
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new KeyStoreException(generalSecurityException.toString());
        }
        finally {
            this.e();
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, java.security.cert.Certificate[] certificateArray) {
        throw new KeyStoreException("TokenKeyStoreSpi does not support storing encrypted keys");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int engineSize() {
        this.n();
        try {
            this.a();
        }
        finally {
            this.e();
        }
        return this.d.size();
    }

    public synchronized void engineStore(OutputStream outputStream, char[] cArray) {
        try {
            this.d();
            this.a.setUserPIN(this.c, this.p, cArray);
            if (outputStream != null) {
                IAIKPkcs11 iAIKPkcs11 = this.a.getProvider();
                this.a(iAIKPkcs11.getName(), outputStream);
            }
        }
        catch (TokenException tokenException) {
            throw new IOException("Error setting new user PIN: " + tokenException.toString());
        }
        finally {
            this.e();
        }
    }

    public TokenManager getTokenManager() {
        return this.a;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    protected synchronized void a(String string) {
        if (string != null) {
            Object object = (Object)this.h.get(string);
            if (object != null) {
                this.h.remove(string);
                if (!this.h.contains(object)) {
                    this.c.destroyObject(object);
                }
            }
            this.e.remove(string);
        }
    }

    protected synchronized void b(String string) {
        if (string != null) {
            Object[] objectArray = (Object[])this.i.get(string);
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    char[] cArray;
                    if (objectArray[i2] == null || (cArray = ((Storage)objectArray[i2]).getLabel().getCharArrayValue()) == null || !string.equals(new String(cArray))) continue;
                    this.c.destroyObject(objectArray[i2]);
                }
                this.i.remove(string);
            }
            this.f.remove(string);
        }
    }

    protected synchronized void c(String string) {
        if (string != null) {
            Object object = (Object)this.j.get(string);
            if (object != null) {
                this.c.destroyObject(object);
                this.j.remove(string);
            }
            this.g.remove(string);
        }
    }

    protected synchronized Object a(java.security.cert.Certificate certificate, byte[] byArray, char[] cArray) {
        if (certificate == null) {
            throw new NullPointerException("Argument \"certificate\" must not be null.");
        }
        try {
            this.d();
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        Object object = null;
        try {
            X509PublicKeyCertificate x509PublicKeyCertificate;
            if (certificate instanceof java.security.cert.X509Certificate) {
                java.lang.Object object2;
                java.lang.Object object3;
                X509Certificate x509Certificate = certificate instanceof X509Certificate ? (X509Certificate)certificate : new X509Certificate(certificate.getEncoded());
                java.lang.Object var7_8 = null;
                X509PublicKeyCertificate x509PublicKeyCertificate2 = new X509PublicKeyCertificate();
                byte[] byArray2 = DerCoder.encode((ASN1Object)new INTEGER(x509Certificate.getSerialNumber()));
                Name name = (Name)x509Certificate.getSubjectDN();
                Name name2 = (Name)x509Certificate.getIssuerDN();
                if (cArray == null) {
                    object3 = name.getRDN(ObjectID.commonName);
                    object2 = name2.getRDN(ObjectID.commonName);
                    cArray = ((String)object3 + "'s " + (object2 != null ? (String)object2 + " " : "") + "Certificate").toCharArray();
                }
                x509PublicKeyCertificate2.getToken().setBooleanValue(Boolean.TRUE);
                x509PublicKeyCertificate2.getPrivate().setBooleanValue(Boolean.FALSE);
                x509PublicKeyCertificate2.getLabel().setCharArrayValue(cArray);
                if (byArray != null) {
                    x509PublicKeyCertificate2.getId().setByteArrayValue(byArray);
                }
                object3 = name.getEncoded();
                x509PublicKeyCertificate2.getSubject().setByteArrayValue((byte[])object3);
                object2 = name2.getEncoded();
                x509PublicKeyCertificate2.getIssuer().setByteArrayValue((byte[])object2);
                x509PublicKeyCertificate2.getSerialNumber().setByteArrayValue(byArray2);
                x509PublicKeyCertificate2.getValue().setByteArrayValue(x509Certificate.getEncoded());
                x509PublicKeyCertificate = x509PublicKeyCertificate2;
            } else if (certificate instanceof AttributeCertificate) {
                java.lang.Object object4;
                AttributeCertificate attributeCertificate = (AttributeCertificate)certificate;
                X509AttributeCertificate x509AttributeCertificate = new X509AttributeCertificate();
                byte[] byArray3 = attributeCertificate.getSerialNumber().toByteArray();
                if (cArray == null) {
                    cArray = "Attribute Certificate".toCharArray();
                }
                byte[] byArray4 = DerCoder.encode((ASN1Object)attributeCertificate.getHolder().toASN1Object());
                byte[] byArray5 = DerCoder.encode((ASN1Object)attributeCertificate.getIssuer().toASN1Object());
                SEQUENCE sEQUENCE = new SEQUENCE();
                Enumeration enumeration = attributeCertificate.getAttributes();
                while (enumeration.hasMoreElements()) {
                    object4 = (Attribute)enumeration.nextElement();
                    sEQUENCE.addComponent((ASN1Object)object4.getType());
                }
                object4 = DerCoder.encode((ASN1Object)sEQUENCE);
                x509AttributeCertificate.getToken().setBooleanValue(Boolean.TRUE);
                x509AttributeCertificate.getPrivate().setBooleanValue(Boolean.FALSE);
                x509AttributeCertificate.getLabel().setCharArrayValue(cArray);
                x509AttributeCertificate.getOwner().setByteArrayValue(byArray4);
                x509AttributeCertificate.getAcIssuer().setByteArrayValue(byArray5);
                x509AttributeCertificate.getSerialNumber().setByteArrayValue(byArray3);
                x509AttributeCertificate.getAttrTypes().setByteArrayValue(object4);
                x509AttributeCertificate.getValue().setByteArrayValue(attributeCertificate.getEncoded());
                x509PublicKeyCertificate = x509AttributeCertificate;
            } else {
                throw new KeyStoreException("Unsupported certificate type: " + certificate.getClass().getName());
            }
            object = this.c.createObject((Object)x509PublicKeyCertificate);
        }
        catch (TokenException tokenException) {
            throw new KeyStoreException(tokenException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new KeyStoreException(generalSecurityException.toString());
        }
        return object;
    }

    protected synchronized iaik.pkcs.pkcs11.objects.Key a(iaik.pkcs.pkcs11.objects.Key key) {
        RSAPublicKey rSAPublicKey;
        java.lang.Object object;
        if (key instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
            if (key instanceof RSAPrivateKey) {
                object = new RSAPublicKey();
                object.getModulus().setByteArrayValue(((RSAPrivateKey)key).getModulus().getByteArrayValue());
                rSAPublicKey = object;
            } else if (key instanceof DSAPrivateKey) {
                object = new DSAPublicKey();
                object.getBase().setByteArrayValue(((DSAPrivateKey)key).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((DSAPrivateKey)key).getPrime().getByteArrayValue());
                object.getSubprime().setByteArrayValue(((DSAPrivateKey)key).getSubprime().getByteArrayValue());
                rSAPublicKey = object;
            } else if (key instanceof ECDSAPrivateKey) {
                object = new ECDSAPublicKey();
                object.getEcdsaParams().setByteArrayValue(((ECDSAPrivateKey)key).getEcdsaParams().getByteArrayValue());
                rSAPublicKey = object;
            } else if (key instanceof DHPrivateKey) {
                object = new DHPublicKey();
                object.getBase().setByteArrayValue(((DHPrivateKey)key).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((DHPrivateKey)key).getPrime().getByteArrayValue());
                rSAPublicKey = object;
            } else {
                rSAPublicKey = null;
            }
        } else if (key instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
            if (key instanceof RSAPublicKey) {
                object = new RSAPrivateKey();
                object.getModulus().setByteArrayValue(((RSAPublicKey)key).getModulus().getByteArrayValue());
                rSAPublicKey = object;
            } else if (key instanceof DSAPublicKey) {
                object = new DSAPrivateKey();
                object.getBase().setByteArrayValue(((DSAPublicKey)key).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((DSAPublicKey)key).getPrime().getByteArrayValue());
                object.getSubprime().setByteArrayValue(((DSAPublicKey)key).getSubprime().getByteArrayValue());
                rSAPublicKey = object;
            } else if (key instanceof ECDSAPublicKey) {
                object = new ECDSAPrivateKey();
                object.getEcdsaParams().setByteArrayValue(((ECDSAPublicKey)key).getEcdsaParams().getByteArrayValue());
                rSAPublicKey = object;
            } else if (key instanceof DHPublicKey) {
                object = new DHPrivateKey();
                object.getBase().setByteArrayValue(((DHPublicKey)key).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((DHPublicKey)key).getPrime().getByteArrayValue());
                rSAPublicKey = object;
            } else if (key instanceof KEAPublicKey) {
                object = new KEAPrivateKey();
                object.getBase().setByteArrayValue(((KEAPublicKey)key).getBase().getByteArrayValue());
                object.getPrime().setByteArrayValue(((KEAPublicKey)key).getPrime().getByteArrayValue());
                object.getSubprime().setByteArrayValue(((KEAPublicKey)key).getSubprime().getByteArrayValue());
                rSAPublicKey = object;
            } else {
                rSAPublicKey = null;
            }
        } else {
            rSAPublicKey = null;
        }
        if (rSAPublicKey != null) {
            this.c();
            this.b.findObjectsInit(rSAPublicKey);
            Object[] objectArray = this.b.findObjects(1);
            object = objectArray.length > 0 ? (iaik.pkcs.pkcs11.objects.Key)objectArray[0] : null;
            this.b.findObjectsFinal();
        } else {
            object = null;
        }
        return object;
    }

    protected MechanismInfo d(String string) {
        MechanismInfo mechanismInfo;
        Token token = this.a.getToken();
        if (token != null) {
            HashSet<Mechanism> hashSet = new HashSet<Mechanism>(Arrays.asList(token.getMechanismList()));
            if (string.equalsIgnoreCase("RSA")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)1L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)1L)));
                }
                if (hashSet.contains(Mechanism.get((long)4L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)4L)));
                }
                if (hashSet.contains(Mechanism.get((long)5L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)5L)));
                }
                if (hashSet.contains(Mechanism.get((long)6L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)6L)));
                }
                if (hashSet.contains(Mechanism.get((long)7L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)7L)));
                }
                if (hashSet.contains(Mechanism.get((long)8L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)8L)));
                }
                if (hashSet.contains(Mechanism.get((long)3L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)3L)));
                }
                if (hashSet.contains(Mechanism.get((long)2L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)2L)));
                }
                if (hashSet.contains(Mechanism.get((long)9L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)9L)));
                }
            } else if (string.equalsIgnoreCase("DSA")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)17L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)17L)));
                }
                if (hashSet.contains(Mechanism.get((long)18L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)18L)));
                }
            } else if (string.equalsIgnoreCase("DH")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)33L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)33L)));
                }
            } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)4161L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)4161L)));
                }
                if (hashSet.contains(Mechanism.get((long)4162L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)4162L)));
                }
                if (hashSet.contains(Mechanism.get((long)4177L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)4177L)));
                }
                if (hashSet.contains(Mechanism.get((long)4176L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)4176L)));
                }
                if (hashSet.contains(Mechanism.get((long)4178L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)4178L)));
                }
            } else if (string.equalsIgnoreCase("KEA")) {
                mechanismInfo = new MechanismInfo();
                if (hashSet.contains(Mechanism.get((long)4113L))) {
                    mechanismInfo = mechanismInfo.or(token.getMechanismInfo(Mechanism.get((long)4113L)));
                }
            } else {
                mechanismInfo = null;
            }
        } else {
            mechanismInfo = null;
        }
        return mechanismInfo;
    }

    protected void a(iaik.pkcs.pkcs11.objects.PrivateKey privateKey, java.security.cert.X509Certificate x509Certificate, MechanismInfo mechanismInfo) {
        KeyUsage keyUsage;
        if (privateKey == null) {
            throw new NullPointerException("Argument \"keyTemplate\" must not be null.");
        }
        if (x509Certificate != null) {
            X509Certificate x509Certificate2 = x509Certificate instanceof X509Certificate ? (X509Certificate)x509Certificate : new X509Certificate(x509Certificate.getEncoded());
            keyUsage = (KeyUsage)x509Certificate2.getExtension(KeyUsage.oid);
        } else {
            keyUsage = null;
        }
        if (keyUsage != null) {
            int n = keyUsage.get();
            if (mechanismInfo != null) {
                privateKey.getDecrypt().setBooleanValue(new Boolean(((n & 8) != 0 || (n & 4) != 0) && mechanismInfo.isDecrypt()));
                privateKey.getSign().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && mechanismInfo.isSign()));
                privateKey.getSignRecover().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && mechanismInfo.isSignRecover()));
                privateKey.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0 && mechanismInfo.isDerive()));
                privateKey.getUnwrap().setBooleanValue(new Boolean((n & 4) != 0 && mechanismInfo.isUnwrap()));
            } else {
                privateKey.getDecrypt().setBooleanValue(new Boolean((n & 8) != 0 || (n & 4) != 0));
                privateKey.getSign().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
                privateKey.getSignRecover().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
                privateKey.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0));
                privateKey.getUnwrap().setBooleanValue(new Boolean((n & 4) != 0));
            }
        } else if (mechanismInfo != null) {
            privateKey.getSign().setBooleanValue(new Boolean(mechanismInfo.isSign()));
            privateKey.getSignRecover().setBooleanValue(new Boolean(mechanismInfo.isSignRecover()));
            privateKey.getDecrypt().setBooleanValue(new Boolean(mechanismInfo.isDecrypt()));
            privateKey.getDerive().setBooleanValue(new Boolean(mechanismInfo.isDerive()));
            privateKey.getUnwrap().setBooleanValue(new Boolean(mechanismInfo.isUnwrap()));
        } else {
            privateKey.getSign().setBooleanValue(Boolean.TRUE);
            privateKey.getSignRecover().setBooleanValue(Boolean.TRUE);
            privateKey.getDecrypt().setBooleanValue(Boolean.TRUE);
            privateKey.getDerive().setBooleanValue(Boolean.TRUE);
            privateKey.getUnwrap().setBooleanValue(Boolean.TRUE);
        }
    }

    protected void a(iaik.pkcs.pkcs11.objects.PublicKey publicKey, java.security.cert.X509Certificate x509Certificate, MechanismInfo mechanismInfo) {
        KeyUsage keyUsage;
        if (publicKey == null) {
            throw new NullPointerException("Argument \"keyTemplate\" must not be null.");
        }
        if (x509Certificate != null) {
            X509Certificate x509Certificate2 = x509Certificate instanceof X509Certificate ? (X509Certificate)x509Certificate : new X509Certificate(x509Certificate.getEncoded());
            keyUsage = (KeyUsage)x509Certificate2.getExtension(KeyUsage.oid);
        } else {
            keyUsage = null;
        }
        if (keyUsage != null) {
            int n = keyUsage.get();
            if (mechanismInfo != null) {
                publicKey.getEncrypt().setBooleanValue(new Boolean((n & 8) != 0 && mechanismInfo.isEncrypt()));
                publicKey.getVerify().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && mechanismInfo.isVerify()));
                publicKey.getVerifyRecover().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && mechanismInfo.isVerifyRecover()));
                publicKey.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0 && mechanismInfo.isDerive()));
                publicKey.getWrap().setBooleanValue(new Boolean((n & 4) != 0 && mechanismInfo.isWrap()));
            } else {
                publicKey.getEncrypt().setBooleanValue(new Boolean((n & 8) != 0));
                publicKey.getVerify().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
                publicKey.getVerifyRecover().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
                publicKey.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0));
                publicKey.getWrap().setBooleanValue(new Boolean((n & 4) != 0));
            }
        } else if (mechanismInfo != null) {
            publicKey.getVerify().setBooleanValue(new Boolean(mechanismInfo.isVerify()));
            publicKey.getVerifyRecover().setBooleanValue(new Boolean(mechanismInfo.isVerifyRecover()));
            publicKey.getEncrypt().setBooleanValue(new Boolean(mechanismInfo.isEncrypt()));
            publicKey.getDerive().setBooleanValue(new Boolean(mechanismInfo.isDerive()));
            publicKey.getWrap().setBooleanValue(new Boolean(mechanismInfo.isWrap()));
        } else {
            publicKey.getVerify().setBooleanValue(Boolean.TRUE);
            publicKey.getVerifyRecover().setBooleanValue(Boolean.TRUE);
            publicKey.getEncrypt().setBooleanValue(Boolean.TRUE);
            publicKey.getDerive().setBooleanValue(Boolean.TRUE);
            publicKey.getWrap().setBooleanValue(Boolean.TRUE);
        }
    }

    protected KeySpec a(Key key) {
        Class clazz;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        String string = key.getAlgorithm();
        if (string.equalsIgnoreCase("RSA")) {
            clazz = key instanceof RSAPrivateCrtKey ? (q == null ? (q = TokenKeyStoreSpi.e("java.security.spec.RSAPrivateCrtKeySpec")) : q) : (r == null ? (r = TokenKeyStoreSpi.e("java.security.spec.RSAPrivateKeySpec")) : r);
        } else if (string.equalsIgnoreCase("DSA")) {
            clazz = s == null ? (s = TokenKeyStoreSpi.e("java.security.spec.DSAPrivateKeySpec")) : s;
        } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
            clazz = t == null ? (t = TokenKeyStoreSpi.e("java.security.spec.PKCS8EncodedKeySpec")) : t;
        } else if (string.equalsIgnoreCase("DH")) {
            clazz = u == null ? (u = TokenKeyStoreSpi.e("javax.crypto.spec.DHPrivateKeySpec")) : u;
        } else {
            throw new KeyStoreException("No means to convert key of algorithm: " + string);
        }
        return this.a(key, clazz);
    }

    protected KeySpec b(Key key) {
        Class clazz;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        String string = key.getAlgorithm();
        if (string.equalsIgnoreCase("RSA")) {
            clazz = v == null ? (v = TokenKeyStoreSpi.e("java.security.spec.RSAPublicKeySpec")) : v;
        } else if (string.equalsIgnoreCase("DSA")) {
            clazz = w == null ? (w = TokenKeyStoreSpi.e("java.security.spec.DSAPublicKeySpec")) : w;
        } else if (string.equalsIgnoreCase("ECDSA") || string.equalsIgnoreCase("EC")) {
            clazz = x == null ? (x = TokenKeyStoreSpi.e("java.security.spec.X509EncodedKeySpec")) : x;
        } else if (string.equalsIgnoreCase("DH")) {
            clazz = y == null ? (y = TokenKeyStoreSpi.e("javax.crypto.spec.DHPublicKeySpec")) : y;
        } else {
            throw new KeyStoreException("No means to convert key of algorithm: " + string);
        }
        return this.a(key, clazz);
    }

    protected KeySpec a(Key key, Class clazz) {
        KeyFactory keyFactory;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        try {
            keyFactory = this.o != null ? KeyFactory.getInstance(key.getAlgorithm(), this.o) : KeyFactory.getInstance(key.getAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        }
        java.lang.Object t = keyFactory.getKeySpec(key, clazz);
        return t;
    }

    protected KeySpec a(SecretKey secretKey) {
        if (secretKey == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        String string = secretKey.getAlgorithm();
        Class clazz = string.equalsIgnoreCase("DESede") ? (z == null ? (z = TokenKeyStoreSpi.e("javax.crypto.spec.DESedeKeySpec")) : z) : (string.equalsIgnoreCase("DES") ? (A == null ? (A = TokenKeyStoreSpi.e("javax.crypto.spec.DESKeySpec")) : A) : (B == null ? (B = TokenKeyStoreSpi.e("javax.crypto.spec.SecretKeySpec")) : B));
        SecretKeyFactory secretKeyFactory = this.o != null ? SecretKeyFactory.getInstance(string, this.o) : SecretKeyFactory.getInstance(string);
        KeySpec keySpec = secretKeyFactory.getKeySpec(secretKey, clazz);
        return keySpec;
    }

    protected iaik.pkcs.pkcs11.objects.Key b(iaik.pkcs.pkcs11.objects.Key key) {
        if (key == null) {
            throw new NullPointerException("Argument \"baseKey\" must not be null.");
        }
        iaik.pkcs.pkcs11.objects.Key key2 = (iaik.pkcs.pkcs11.objects.Key)key.clone();
        key2.getKeyGenMechanism().setPresent(false);
        key2.getLocal().setPresent(false);
        if (key2 instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
            iaik.pkcs.pkcs11.objects.PrivateKey privateKey = (iaik.pkcs.pkcs11.objects.PrivateKey)key2;
            privateKey.getAuthPinFlags().setPresent(false);
            privateKey.getAlwaysSensitive().setPresent(false);
            privateKey.getNeverExtractable().setPresent(false);
            if (key2 instanceof DHPrivateKey) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)key2;
                dHPrivateKey.getValueBits().setPresent(false);
            }
        } else if (key2 instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
            if (key2 instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key2;
                rSAPublicKey.getModulusBits().setPresent(false);
            }
        } else if (key2 instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
            iaik.pkcs.pkcs11.objects.SecretKey secretKey = (iaik.pkcs.pkcs11.objects.SecretKey)key2;
            secretKey.getAlwaysSensitive().setPresent(false);
            secretKey.getNeverExtractable().setPresent(false);
            iaik.pkcs.pkcs11.objects.Attribute attribute = (iaik.pkcs.pkcs11.objects.Attribute)secretKey.getAttributeTable().get(iaik.pkcs.pkcs11.objects.Attribute.VALUE_LEN);
            if (attribute != null) {
                attribute.setPresent(false);
            }
        }
        return key2;
    }

    protected synchronized byte[] a(byte[] byArray) {
        byte[] byArray2 = byArray != null && byArray.length > 0 ? byArray : (this.n == null ? new byte[20] : this.n);
        GenericTemplate genericTemplate = new GenericTemplate();
        ByteArrayAttribute byteArrayAttribute = new ByteArrayAttribute(iaik.pkcs.pkcs11.objects.Attribute.ID);
        byteArrayAttribute.setByteArrayValue(byArray2);
        genericTemplate.addAttribute((iaik.pkcs.pkcs11.objects.Attribute)byteArrayAttribute);
        boolean bl = false;
        while (!bl) {
            TokenKeyStoreSpi.b(byArray2);
            this.c.findObjectsInit((Object)genericTemplate);
            Object[] objectArray = this.c.findObjects(1);
            this.c.findObjectsFinal();
            bl = objectArray.length == 0;
        }
        this.n = byArray2;
        return this.n;
    }

    protected synchronized void a() {
        this.b();
    }

    synchronized void b() {
        try {
            if (this.a.isTokenPresent()) {
                if (!this.p()) {
                    this.m();
                    this.c();
                    this.o();
                }
            } else {
                this.m();
                this.m = null;
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void c() {
        if (this.b == null) {
            this.i();
        }
        if (this.l) {
            this.k();
        }
    }

    protected synchronized void d() {
        if (this.c == null) {
            this.j();
        }
        this.k();
    }

    protected synchronized void e() {
        if (this.b != null) {
            if (this.b != this.c) {
                this.a.disposeSession(this.b);
            }
            this.b = null;
        }
        if (this.c != null) {
            this.a.disposeSession(this.c);
            this.c = null;
        }
    }

    protected synchronized String a(Object object, Set set) {
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        if (object == null) {
            throw new NullPointerException("Argument \"pkcs11Object\" must not be null.");
        }
        if (set == null) {
            throw new NullPointerException("Argument \"usedAliases\" must not be null.");
        }
        String string = object instanceof Storage ? ((object4 = (object3 = (Storage)object).getLabel()) != null ? ((object2 = object4.getCharArrayValue()) != null ? new String((char[])object2) : String.valueOf(object.getObjectHandle())) : Object.getObjectClassName((Long)object.getObjectClass().getLongValue())) : Object.getObjectClassName((Long)object.getObjectClass().getLongValue());
        if (set.contains(string)) {
            object3 = new StringBuffer(string.length() + 16);
            ((StringBuffer)object3).append(string);
            ((StringBuffer)object3).append('(');
            ((StringBuffer)object3).append(object.getObjectHandle());
            ((StringBuffer)object3).append(')');
            string = ((StringBuffer)object3).toString();
        }
        int n = 2;
        object4 = string;
        while (set.contains(object4)) {
            object2 = new StringBuffer(string.length() + 4);
            ((StringBuffer)object2).append(string);
            ((StringBuffer)object2).append('[');
            ((StringBuffer)object2).append(n);
            ((StringBuffer)object2).append(']');
            object4 = ((StringBuffer)object2).toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List q() {
        ArrayList<Object> arrayList;
        block9: {
            arrayList = new ArrayList<Object>(2);
            this.b.findObjectsInit(null);
            try {
                while (true) {
                    try {
                        block6: while (true) {
                            Object[] objectArray;
                            if ((objectArray = this.b.findObjects(1)).length == 0) {
                                break block9;
                            }
                            int n = 0;
                            while (true) {
                                if (n >= objectArray.length) continue block6;
                                arrayList.add(objectArray[n]);
                                ++n;
                            }
                            break;
                        }
                    }
                    catch (TokenException tokenException) {
                        if (null != tokenException.getEncapsulatedException()) continue;
                        throw tokenException;
                    }
                    break;
                }
            }
            finally {
                this.b.findObjectsFinal();
            }
        }
        return arrayList;
    }

    protected synchronized void f() {
        Object[] objectArray;
        X509Certificate[] x509CertificateArray;
        java.lang.Object object;
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        java.lang.Object object5;
        Object object6;
        Object object7;
        Serializable serializable;
        java.lang.Object object8;
        Hashtable<java.lang.Object, java.lang.Object> hashtable;
        Vector vector;
        AttributeCertificate attributeCertificate;
        java.lang.Object object9;
        X509PublicKeyCertificate x509PublicKeyCertificate;
        Collection collection;
        List list = this.q();
        b b2 = new b(8);
        b b3 = new b(8);
        HashMap hashMap = new HashMap(8);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            collection = (Object)iterator.next();
            if (!(collection instanceof Certificate)) continue;
            if (collection instanceof X509PublicKeyCertificate) {
                x509PublicKeyCertificate = (X509PublicKeyCertificate)collection;
                object9 = x509PublicKeyCertificate.getValue().getByteArrayValue();
                if (object9 == null) continue;
                try {
                    attributeCertificate = new X509Certificate((InputStream)new ByteArrayInputStream((byte[])object9));
                    b3.a(attributeCertificate, x509PublicKeyCertificate);
                    vector = ((Name)attributeCertificate.getSubjectDN()).getRFC2253String();
                    hashtable = hashMap.get(vector);
                    if (hashtable == null) {
                        hashMap.put(vector, attributeCertificate);
                        continue;
                    }
                    if (hashtable instanceof X509Certificate) {
                        object8 = new Vector<AttributeCertificate>(2);
                        ((Vector)object8).addElement(hashtable);
                        ((Vector)object8).addElement(attributeCertificate);
                        hashMap.put(vector, object8);
                        continue;
                    }
                    object8 = (Vector)((java.lang.Object)hashtable);
                    ((Vector)object8).addElement(attributeCertificate);
                }
                catch (IOException iOException) {
                    IAIKPkcs11.errorStream_.println("Could not create Certificate object: " + iOException);
                    iOException.printStackTrace(IAIKPkcs11.errorStream_);
                }
                catch (CertificateException certificateException) {
                    IAIKPkcs11.errorStream_.println("Could not create Certificate object: " + certificateException);
                    certificateException.printStackTrace(IAIKPkcs11.errorStream_);
                }
                catch (RFC2253NameParserException rFC2253NameParserException) {
                    IAIKPkcs11.errorStream_.println("Could not create Certificate object: " + (java.lang.Object)((java.lang.Object)rFC2253NameParserException));
                    rFC2253NameParserException.printStackTrace(IAIKPkcs11.errorStream_);
                }
                continue;
            }
            if (!(collection instanceof X509AttributeCertificate)) continue;
            x509PublicKeyCertificate = (X509AttributeCertificate)collection;
            object9 = x509PublicKeyCertificate.getValue().getByteArrayValue();
            try {
                attributeCertificate = new AttributeCertificate(object9);
                b3.a(attributeCertificate, x509PublicKeyCertificate);
            }
            catch (CertificateException certificateException) {
                IAIKPkcs11.errorStream_.println("Could not create AttributeCertificate object: " + certificateException);
                certificateException.printStackTrace(IAIKPkcs11.errorStream_);
            }
        }
        collection = b3.b();
        x509PublicKeyCertificate = collection.iterator();
        while (x509PublicKeyCertificate.hasNext()) {
            object9 = x509PublicKeyCertificate.next();
            b2.a(object9, b3.a(object9));
        }
        object9 = new Hashtable(b3.a());
        attributeCertificate = new Hashtable(b3.a());
        vector = new Vector(b3.a());
        vector.addAll(b3.b());
        hashtable = new Hashtable();
        object8 = vector.iterator();
        int n = 0;
        while (object8.hasNext()) {
            serializable = (java.security.cert.Certificate)object8.next();
            if (serializable == null || (object7 = (Object)b3.a(serializable)) == null || !(serializable instanceof X509Certificate)) continue;
            object6 = (X509Certificate)serializable;
            object5 = (X509PublicKeyCertificate)object7;
            object4 = object5.getId().getByteArrayValue();
            if (object4 == null) continue;
            object3 = new ComparableByteArray((byte[])object4);
            object2 = new Integer(n++);
            object = (Vector)hashtable.get(object3);
            if (object != null) {
                object.add(object2);
            } else {
                object = new Vector(1);
                object.add(object2);
            }
            hashtable.put(object3, object);
            x509CertificateArray = this.a((X509Certificate)object6, hashMap, object5.getLabel().getCharArrayValue(), b2);
            objectArray = new Object[x509CertificateArray.length];
            for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                objectArray[i2] = (Object)b3.a(x509CertificateArray[i2]);
            }
            ((Hashtable)object9).put((iaik.pkcs.pkcs11.objects.PrivateKey)object2, (Object[])objectArray);
            attributeCertificate.put(object2, x509CertificateArray);
        }
        serializable = new LinkedList();
        object7 = new LinkedList();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object6 = (Object)iterator.next();
            if (!(object6 instanceof iaik.pkcs.pkcs11.objects.Key)) continue;
            object5 = (iaik.pkcs.pkcs11.objects.Key)object6;
            object4 = null;
            object3 = null;
            if (object5 instanceof iaik.pkcs.pkcs11.objects.PrivateKey) {
                object2 = (iaik.pkcs.pkcs11.objects.PrivateKey)object5;
                object3 = IAIKPKCS11PrivateKey.create(this.a, object2);
                object = object2.getId().getByteArrayValue();
                if (object != null && (objectArray = (Vector)hashtable.remove(x509CertificateArray = new ComparableByteArray((byte[])object))) != null) {
                    object4 = new Vector(1);
                    Iterator iterator2 = objectArray.iterator();
                    while (iterator2.hasNext()) {
                        Integer n2 = (Integer)iterator2.next();
                        X509Certificate[] x509CertificateArray2 = (X509Certificate[])attributeCertificate.remove(n2);
                        if (x509CertificateArray2 == null || x509CertificateArray2.length <= 0) continue;
                        Object[] objectArray2 = (Object[])((Hashtable)object9).remove(n2);
                        String string = this.a(objectArray2[0], this.d);
                        object4.add(string);
                        this.d.add(string);
                        this.f.put(string, x509CertificateArray2);
                        if (objectArray2 != null) {
                            this.i.put(string, objectArray2);
                        }
                        if (x509CertificateArray2.length <= 0) continue;
                        b3.b(x509CertificateArray2[0]);
                        b2.b(x509CertificateArray2[0]);
                    }
                }
                if (object3 == null) continue;
                if (object4 == null) {
                    object4 = new Vector(1);
                    x509CertificateArray = this.a((Object)object5, this.d);
                    object4.add(x509CertificateArray);
                    this.d.add(x509CertificateArray);
                }
                x509CertificateArray = object4.iterator();
                while (x509CertificateArray.hasNext()) {
                    objectArray = (String)x509CertificateArray.next();
                    this.h.put(objectArray, object5);
                    this.e.put(objectArray, object3);
                }
                continue;
            }
            if (object5 instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
                serializable.add(object5);
                continue;
            }
            if (object5 instanceof iaik.pkcs.pkcs11.objects.SecretKey) {
                object7.add(object5);
                continue;
            }
            throw new KeyStoreException("Unknown key type: " + object5.getClass().getName());
        }
        object6 = serializable.iterator();
        while (object6.hasNext()) {
            object5 = (iaik.pkcs.pkcs11.objects.PublicKey)object6.next();
            object4 = IAIKPKCS11PublicKey.create(this.a, (iaik.pkcs.pkcs11.objects.PublicKey)object5);
            object3 = this.a((Object)object5, this.d);
            this.h.put(object3, object5);
            this.e.put(object3, object4);
            this.d.add(object3);
        }
        object5 = object7.iterator();
        while (object5.hasNext()) {
            object4 = (iaik.pkcs.pkcs11.objects.SecretKey)object5.next();
            object3 = IAIKPKCS11SecretKey.create(this.a, (iaik.pkcs.pkcs11.objects.SecretKey)object4);
            object2 = this.a((Object)object4, this.d);
            this.h.put(object2, object4);
            this.e.put(object2, object3);
            this.d.add(object2);
        }
        vector = new Vector(b2.a());
        vector.addAll(b2.b());
        object8 = vector.iterator();
        while (object8.hasNext()) {
            object4 = (java.security.cert.Certificate)object8.next();
            if (object4 == null) continue;
            object3 = (Object)b2.a(object4);
            if (object3 != null) {
                object2 = this.a((Object)object3, this.d);
                this.j.put(object2, object3);
                this.g.put(object2, object4);
                this.d.add(object2);
            }
            b2.b(object4);
        }
    }

    protected synchronized void g() {
        this.d = new HashSet();
        this.e = new Hashtable();
        this.f = new Hashtable();
        this.g = new Hashtable();
        this.h = new Hashtable();
        this.i = new Hashtable();
        this.j = new Hashtable();
        this.l = !this.a.getProvider().isLoginKeystoreOnDemand();
        this.b(false);
        this.a.a(this);
    }

    protected synchronized X509Certificate[] a(X509Certificate x509Certificate, Map map, char[] cArray, b b2) {
        if (x509Certificate == null) {
            throw new NullPointerException("Argument \"userCertificate\" must not be null.");
        }
        if (map == null) {
            throw new NullPointerException("Argument \"subjectToCertificatesMap\" must not be null.");
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>(4);
        vector.add(x509Certificate);
        X509Certificate x509Certificate2 = x509Certificate;
        java.lang.Object object = null;
        int n = 100;
        try {
            java.lang.Object object2;
            java.lang.Object object3;
            java.lang.Object object4;
            java.lang.Object object5;
            Vector vector2;
            Name name = (Name)x509Certificate2.getIssuerDN();
            String string = name.getRFC2253String();
            java.lang.Object v = map.get(string);
            if (v == null) {
                object = null;
            } else if (v instanceof Vector) {
                vector2 = (Vector)v;
                object5 = vector2.iterator();
                while (object5.hasNext()) {
                    object4 = (X509Certificate)object5.next();
                    object3 = (X509PublicKeyCertificate)b2.a(object4);
                    if (object3 == null || !Arrays.equals(cArray, object2 = object3.getLabel().getCharArrayValue())) continue;
                    object = object4;
                    b2.b(object4);
                    break;
                }
                if (object == null) {
                    object = (X509Certificate)vector2.firstElement();
                }
            } else {
                object = (X509Certificate)v;
                vector2 = (X509PublicKeyCertificate)b2.a(object);
                if (vector2 != null && Arrays.equals(cArray, (char[])(object5 = (java.lang.Object)vector2.getLabel().getCharArrayValue()))) {
                    b2.b(object);
                }
            }
            while (object != null && !x509Certificate2.equals(object) && n-- > 0) {
                vector2 = (AuthorityKeyIdentifier)x509Certificate2.getExtension(AuthorityKeyIdentifier.oid);
                object5 = (SubjectKeyIdentifier)object.getExtension(SubjectKeyIdentifier.oid);
                if (vector2 == null || object5 == null || Arrays.equals(vector2.getKeyIdentifier(), object5.get())) {
                    vector.add((X509Certificate)object);
                    x509Certificate2 = object;
                    name = (Name)x509Certificate2.getIssuerDN();
                    string = name.getRFC2253String();
                    object = null;
                    v = map.get(string);
                    if (v == null) {
                        object = null;
                        continue;
                    }
                    if (v instanceof Vector) {
                        object4 = (Vector)v;
                        object3 = ((Vector)object4).iterator();
                        while (object3.hasNext()) {
                            char[] cArray2;
                            object2 = (X509Certificate)object3.next();
                            X509PublicKeyCertificate x509PublicKeyCertificate = (X509PublicKeyCertificate)b2.a(object2);
                            if (x509PublicKeyCertificate == null || !Arrays.equals(cArray, cArray2 = x509PublicKeyCertificate.getLabel().getCharArrayValue())) continue;
                            object = object2;
                            b2.b(object2);
                            break;
                        }
                        if (object != null) continue;
                        object = (X509Certificate)((Vector)object4).firstElement();
                        continue;
                    }
                    object = (X509Certificate)v;
                    object4 = (X509PublicKeyCertificate)b2.a(object);
                    if (object4 == null || !Arrays.equals(cArray, (char[])(object3 = (java.lang.Object)object4.getLabel().getCharArrayValue()))) continue;
                    b2.b(object);
                    continue;
                }
                break;
            }
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            rFC2253NameParserException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        catch (X509ExtensionException x509ExtensionException) {
            x509ExtensionException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        return vector.toArray(new X509Certificate[vector.size()]);
    }

    protected synchronized boolean h() {
        return !this.l;
    }

    protected synchronized void a(boolean bl) {
        if (bl == this.l) {
            this.l = !bl;
            this.b(false);
        }
    }

    protected synchronized void i() {
        try {
            this.b = this.c != null ? this.c : this.a.getSession(false);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void j() {
        try {
            this.c = this.a.getSession(true);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected String a(InputStream inputStream) {
        char[] cArray = new char[64];
        int n = 0;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        CharArrayWriter charArrayWriter = new CharArrayWriter(64);
        while ((n = inputStreamReader.read(cArray, 0, cArray.length)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        charArrayWriter.flush();
        return new String(charArrayWriter.toCharArray());
    }

    protected void a(String string, OutputStream outputStream) {
        outputStream.write(string.getBytes("UTF-8"));
    }

    protected synchronized boolean k() {
        boolean bl;
        try {
            if (this.b == null) {
                this.i();
            }
            bl = this.a.makeAuthorizedSession(this.b, null);
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        return bl;
    }

    protected synchronized void l() {
        try {
            this.a.logout();
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected synchronized void m() {
        this.d.clear();
        this.e.clear();
        this.f.clear();
        this.g.clear();
        this.h.clear();
        this.i.clear();
        this.j.clear();
    }

    protected void n() {
        this.o = this.a.getProvider().getKeystoreSupportProvider();
    }

    protected synchronized void o() {
        try {
            this.m = this.a.getToken().getTokenInfo();
            this.f();
            this.b(true);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace(IAIKPkcs11.errorStream_);
        }
        catch (TokenException tokenException) {
            tokenException.printStackTrace(IAIKPkcs11.errorStream_);
        }
    }

    protected synchronized boolean p() {
        if (this.k) {
            if (this.a.isTokenPresent()) {
                TokenInfo tokenInfo = this.a.getToken().getTokenInfo();
                if (!(this.m != null && this.m.getLabel().equals(tokenInfo.getLabel()) && this.m.getManufacturerID().equals(tokenInfo.getManufacturerID()) && this.m.getModel().equals(tokenInfo.getModel()) && this.m.getSerialNumber().equals(tokenInfo.getSerialNumber()) && this.m.getFreePrivateMemory() == tokenInfo.getFreePrivateMemory() && this.m.getFreePublicMemory() == tokenInfo.getFreePublicMemory())) {
                    this.k = false;
                }
            } else if (this.m != null) {
                this.k = false;
            }
        }
        return this.k;
    }

    protected void b(boolean bl) {
        this.k = bl;
    }

    protected void finalize() {
        if (this.a != null) {
            this.a.disposeSession(this.b);
            if (this.b != this.c) {
                this.a.disposeSession(this.c);
            }
        }
        super.finalize();
    }

    static Class e(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

