/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.hashes;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import java.security.MessageDigest;

public abstract class PKCS11Hash
extends MessageDigest
implements PKCS11EngineClass {
    protected TokenManager a;
    protected Session b;
    protected int c;
    protected Mechanism d;
    protected Mechanism[] e;
    protected MechanismInfo[][] f;
    protected boolean g;
    protected boolean h;
    protected boolean i;
    protected MessageDigest j;

    protected PKCS11Hash(String string, int n, Mechanism mechanism) {
        super(string);
        if (n < 0) {
            throw new NullPointerException("Argument \"hashValueLength\" must be >= 0.");
        }
        if (mechanism == null) {
            throw new NullPointerException("Argument \"mechanism\" must not be null.");
        }
        this.c = n;
        this.d = mechanism;
    }

    protected int engineGetDigestLength() {
        int n = this.i ? this.j.getDigestLength() : this.c;
        return n;
    }

    protected void engineUpdate(byte by) {
        if (!this.g) {
            this.c();
        }
        if (this.i) {
            this.j.update(by);
        } else {
            if (!this.h) {
                try {
                    this.e();
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 hash for next operation: " + tokenException.toString());
                }
            }
            byte[] byArray = new byte[]{by};
            try {
                this.b.digestUpdate(byArray);
            }
            catch (TokenException tokenException) {
                this.f();
                throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
            }
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("Arguments must satisfy ((offset + length) <= data.length).");
        }
        if (!this.g) {
            this.c();
        }
        if (this.i) {
            this.j.update(byArray, n, n2);
        } else {
            if (!this.h) {
                try {
                    this.e();
                }
                catch (TokenException tokenException) {
                    throw new IAIKPkcs11Exception("Could not reinitialize PKCS#11 hash for next operation: " + tokenException.toString());
                }
            }
            byte[] byArray2 = null;
            if (n == 0 && n2 == byArray.length) {
                byArray2 = byArray;
            } else {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
            try {
                this.b.digestUpdate(byArray2);
            }
            catch (TokenException tokenException) {
                this.f();
                throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
            }
        }
    }

    protected byte[] engineDigest() {
        if (!this.g) {
            this.c();
        }
        byte[] byArray = null;
        if (this.i) {
            byArray = this.j.digest();
        } else {
            try {
                byArray = this.b.digestFinal();
                this.h = false;
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error updating digest: " + (Object)((Object)tokenException));
            }
            finally {
                this.f();
            }
        }
        return byArray;
    }

    protected void engineReset() {
        if (this.i) {
            if (!this.g) {
                this.c();
            }
            this.j.reset();
        } else if (!this.g) {
            this.c();
        } else {
            this.f();
            try {
                this.e();
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error initializing the PKCS#11 digest: " + tokenException.toString());
            }
        }
    }

    protected Mechanism[] a() {
        if (this.e == null) {
            Mechanism mechanism = (Mechanism)this.d.clone();
            mechanism.setParameters(null);
            this.e = new Mechanism[]{mechanism};
        }
        return this.e;
    }

    public Mechanism getUsedMechanism() {
        return this.d;
    }

    protected MechanismInfo[][] b() {
        if (this.f == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setDigest(true);
            this.f = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.f;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.a();
            MechanismInfo[][] mechanismInfoArray = this.b();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    public TokenManager getTokenManager() {
        return this.a;
    }

    protected void c() {
        block4: {
            IAIKPkcs11 iAIKPkcs11 = (IAIKPkcs11)this.getProvider();
            this.a = iAIKPkcs11.getTokenManager();
            try {
                if (this.isSupportedBy(this.a)) {
                    this.e();
                    this.i = false;
                    break block4;
                }
                if (IAIKPkcs11.isEnableSoftwareDelegation()) {
                    this.g();
                    this.i = true;
                    break block4;
                }
                throw new IAIKPkcs11Exception("Software delegation is disabled and the current token does not support: " + this.d.toString());
            }
            catch (TokenException tokenException) {
                throw new IAIKPkcs11Exception("Error initializing the PKCS#11 digest: " + tokenException.toString());
            }
        }
        this.g = true;
    }

    protected void d() {
        if (this.b == null) {
            this.b = this.a.getSession(false);
        }
        this.a.makeAuthorizedSession(this.b, null);
    }

    protected void e() {
        this.d();
        this.b.digestInit(this.d);
        this.h = true;
    }

    protected void f() {
        if (this.h) {
            try {
                this.b.digestFinal();
            }
            catch (TokenException tokenException) {
                // empty catch block
            }
        }
        this.h = false;
        this.a.disposeSession(this.b);
        this.b = null;
    }

    protected void g() {
        DelegateProvider delegateProvider = this.a != null ? this.a.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.getAlgorithm();
        this.j = delegateProvider.getMessageDigest(string);
        if (this.j == null) {
            throw new IAIKPkcs11Exception("Could not get delegate message digest engine for " + string);
        }
    }

    public void setTokenManager(TokenManager tokenManager) {
        if (tokenManager == null) {
            throw new NullPointerException("Argument \"tokenManager\" must not be null.");
        }
        this.a = tokenManager;
        if (!this.g) {
            this.c();
        }
    }

    protected void finalize() {
        if (this.b != null) {
            this.f();
        }
        super.finalize();
    }
}

