/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.provider.DelegateProvider;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11Key;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;

public abstract class PKCS11SecretKeyFactory
extends SecretKeyFactorySpi
implements PKCS11EngineClass {
    protected TokenManager d;
    protected Session e;
    protected boolean f;
    protected PKCS11KeySpec g;
    protected SecretKeyFactory h;

    public boolean isSupportedBy(TokenManager tokenManager) {
        return true;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) {
        SecretKey secretKey;
        keySpec = IAIKPkcs11.getGlobalKeyHandler().handleSecretKeyFactoryGenerateSecret(this.a(), keySpec);
        if (keySpec instanceof PKCS11KeySpec) {
            secretKey = this.c(keySpec);
        } else {
            if (this.h == null) {
                this.f();
            }
            secretKey = this.h.generateSecret(keySpec);
        }
        return secretKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) {
        KeySpec keySpec;
        if (secretKey instanceof IAIKPKCS11Key) {
            keySpec = this.a(secretKey, clazz);
        } else {
            if (this.h == null) {
                this.f();
            }
            keySpec = this.h.getKeySpec(secretKey, clazz);
        }
        return keySpec;
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) {
        SecretKey secretKey2;
        secretKey = IAIKPkcs11.getGlobalKeyHandler().handleSecretKeyFactoryTranslateKey(this.a(), secretKey);
        if (secretKey instanceof IAIKPKCS11Key) {
            secretKey2 = this.a(secretKey);
        } else {
            if (this.h == null) {
                this.f();
            }
            secretKey2 = this.h.translateKey(secretKey);
        }
        return secretKey2;
    }

    protected abstract String a();

    protected abstract String b();

    protected abstract SecretKey c(KeySpec var1);

    protected abstract KeySpec a(SecretKey var1, Class var2);

    protected SecretKey a(SecretKey secretKey) {
        return secretKey;
    }

    protected java.security.Key a(iaik.pkcs.pkcs11.objects.Object object) {
        this.d();
        Key key = null;
        try {
            key = (Key)this.e.createObject(object);
        }
        catch (TokenException tokenException) {
            this.e();
            throw new InvalidKeySpecException("The secret key could not be generated using the given key spec: " + tokenException.toString());
        }
        IAIKPKCS11Key iAIKPKCS11Key = IAIKPKCS11Key.create(this.d, key);
        if (!key.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11Key.setSession(this.e);
        }
        this.e();
        this.d.notifyKeyStores();
        return iAIKPKCS11Key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void c() {
        if (this.g == null) throw new IAIKPkcs11Exception("Key factory is not initialized properly. The key spec is not set appropriately.");
        this.d = this.g.getTokenManager();
        try {
            if (this.a(this.e, this.g)) return;
            if (this.e == null) {
                this.e = this.d.getSession(this.g.isUseRwSession());
            }
            if (!this.g.isUseAnonymousRole()) {
                this.d.login(this.e, this.g.isUseSORole(), this.g.getPin());
                return;
            } else {
                this.d.makeAuthorizedSession(this.e, null);
            }
            return;
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void d() {
        this.c();
        this.f = true;
    }

    protected void e() {
        this.f = false;
        this.d.disposeSession(this.e);
        this.e = null;
    }

    protected void f() {
        DelegateProvider delegateProvider = this.d != null ? this.d.getProvider().getDelegateProvider() : IAIKPkcs11.getGlobalDelegateProvider();
        String string = this.b();
        this.h = delegateProvider.getSecretKeyFactory(string);
        if (this.h == null) {
            throw new IAIKPkcs11Exception("Could not get delegate secret key factory engine for " + string);
        }
    }

    protected boolean a(Session session, PKCS11KeySpec pKCS11KeySpec) {
        boolean bl = false;
        if (session != null && pKCS11KeySpec != null) {
            SessionInfo sessionInfo = session.getSessionInfo();
            Token token = session.getToken();
            State state = sessionInfo.getState();
            boolean bl2 = state.equals((Object)State.RO_USER_FUNCTIONS) || state.equals((Object)State.RW_USER_FUNCTIONS);
            bl = token.equals((Object)this.d.getToken()) && sessionInfo.isRwSession() != pKCS11KeySpec.isUseROSession() && bl2 == pKCS11KeySpec.isUseUserSession();
        }
        return bl;
    }

    protected void finalize() {
        if (this.e != null) {
            this.d.disposeSession(this.e);
        }
        super.finalize();
    }
}

